import { Target } from './target.js';
export type ValueOfConstArray<T> = T[Exclude<keyof T, keyof Array<any>>];
export declare const SupportedPackageManagers: readonly ["yarn"];
export declare const SupportedTestFrameworks: readonly ["ava"];
export type SupportedPackageManager = ValueOfConstArray<typeof SupportedPackageManagers>;
export type SupportedTestFramework = ValueOfConstArray<typeof SupportedTestFrameworks>;
export interface UserNapiConfig {
    /**
     * Name of the binary to be generated, default to `index`
     */
    binaryName?: string;
    /**
     * Name of the npm package, default to the name of root package.json name
     *
     * Always given `@scope/pkg` and arch suffix will be appended like `@scope/pkg-linux-gnu-x64`
     */
    packageName?: string;
    /**
     * All targets the crate will be compiled for
     */
    targets?: string[];
    /**
     * The npm client project uses.
     */
    npmClient?: string;
    /**
     * Whether generate const enum for typescript bindings
     */
    constEnum?: boolean;
    /**
     * dts header prepend to the generated dts file
     */
    dtsHeader?: string;
    /**
     * dts header file path to be prepended to the generated dts file
     * if both dtsHeader and dtsHeaderFile are provided, dtsHeaderFile will be used
     */
    dtsHeaderFile?: string;
    /**
     * wasm compilation options
     */
    wasm?: {
        /**
         * https://developer.mozilla.org/en-US/docs/WebAssembly/JavaScript_interface/Memory
         * @default 4000 pages (256MiB)
         */
        initialMemory?: number;
        /**
         * @default 65536 pages (4GiB)
         */
        maximumMemory?: number;
        /**
         * Browser wasm binding configuration
         */
        browser: {
            /**
             * Whether to use fs module in browser
             */
            fs?: boolean;
        };
    };
    /**
     * @deprecated binaryName instead
     */
    name?: string;
    /**
     * @deprecated use packageName instead
     */
    package?: {
        name?: string;
    };
    /**
     * @deprecated use targets instead
     */
    triples?: {
        /**
         * Whether enable default targets
         */
        defaults: boolean;
        /**
         * Additional targets to be compiled for
         */
        additional?: string[];
    };
}
export interface CommonPackageJsonFields {
    name: string;
    version: string;
    description?: string;
    keywords?: string[];
    author?: string;
    authors?: string[];
    license?: string;
    repository?: any;
    homepage?: any;
    engines?: Record<string, string>;
    publishConfig?: any;
    bugs?: any;
    napi?: UserNapiConfig;
    type?: 'module' | 'commonjs';
    scripts?: Record<string, string>;
    main?: string;
    module?: string;
    types?: string;
    browser?: string;
    exports?: any;
    dependencies?: Record<string, string>;
    devDependencies?: Record<string, string>;
    ava?: {
        timeout?: string;
    };
}
export type NapiConfig = Required<Pick<UserNapiConfig, 'binaryName' | 'packageName' | 'npmClient'>> & Pick<UserNapiConfig, 'wasm' | 'dtsHeader' | 'dtsHeaderFile' | 'constEnum'> & {
    targets: Target[];
    packageJson: CommonPackageJsonFields;
};
export declare function readNapiConfig(path: string, configPath?: string): Promise<NapiConfig>;
