import { join } from 'path';
import { fileURLToPath } from 'url';
import test from 'ava';
import { correctStringIdent, processTypeDef } from '../typegen.js';
test('should ident string correctly', (t) => {
    const input = `
  /**
   * should keep
   * class A {
   * foo = () => {}
   *   bar = () => {}
   * }
   */
  class A {
    foo() {
      a = b
    }

  bar = () => {

  }
      boz = 1
    }

  namespace B {
      namespace C {
  type D = A
      }
  }
`;
    t.snapshot(correctStringIdent(input, 0), 'original ident is 0');
    t.snapshot(correctStringIdent(input, 2), 'original ident is 2');
});
test('should process type def correctly', async (t) => {
    const { dts } = await processTypeDef(join(fileURLToPath(import.meta.url), '../', '__fixtures__', 'napi_type_def'), true);
    t.snapshot(dts);
});
test('should process type def with noConstEnum correctly', async (t) => {
    const { dts } = await processTypeDef(join(fileURLToPath(import.meta.url), '../', '__fixtures__', 'napi_type_def'), false);
    t.snapshot(dts);
});
//# sourceMappingURL=typegen.spec.js.map