// This file is generated by codegen/index.ts
// Do not edit this file manually
import { Command, Option } from 'clipanion';
export class BaseVersionCommand extends Command {
    static paths = [['version']];
    static usage = Command.Usage({
        description: 'Update version in created npm packages',
    });
    cwd = Option.String('--cwd', process.cwd(), {
        description: 'The working directory of where napi command will be executed in, all other paths options are relative to this path',
    });
    configPath = Option.String('--config-path,-c', {
        description: 'Path to `napi` config json file',
    });
    packageJsonPath = Option.String('--package-json-path', 'package.json', {
        description: 'Path to `package.json`',
    });
    npmDir = Option.String('--npm-dir', 'npm', {
        description: 'Path to the folder where the npm packages put',
    });
    getOptions() {
        return {
            cwd: this.cwd,
            configPath: this.configPath,
            packageJsonPath: this.packageJsonPath,
            npmDir: this.npmDir,
        };
    }
}
export function applyDefaultVersionOptions(options) {
    return {
        cwd: process.cwd(),
        packageJsonPath: 'package.json',
        npmDir: 'npm',
        ...options,
    };
}
//# sourceMappingURL=version.js.map