import { Command } from 'clipanion';
export declare abstract class BaseVersionCommand extends Command {
    static paths: string[][];
    static usage: import("clipanion").Usage;
    cwd: string;
    configPath?: string;
    packageJsonPath: string;
    npmDir: string;
    getOptions(): {
        cwd: string;
        configPath: string | undefined;
        packageJsonPath: string;
        npmDir: string;
    };
}
/**
 * Update version in created npm packages
 */
export interface VersionOptions {
    /**
     * The working directory of where napi command will be executed in, all other paths options are relative to this path
     *
     * @default process.cwd()
     */
    cwd?: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    /**
     * Path to `package.json`
     *
     * @default 'package.json'
     */
    packageJsonPath?: string;
    /**
     * Path to the folder where the npm packages put
     *
     * @default 'npm'
     */
    npmDir?: string;
}
export declare function applyDefaultVersionOptions(options: VersionOptions): {
    cwd: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    packageJsonPath: string;
    npmDir: string;
};
