// This file is generated by codegen/index.ts
// Do not edit this file manually
import { Command, Option } from 'clipanion';
export class BaseUniversalizeCommand extends Command {
    static paths = [['universalize']];
    static usage = Command.Usage({
        description: 'Combile built binaries into one universal binary',
    });
    cwd = Option.String('--cwd', process.cwd(), {
        description: 'The working directory of where napi command will be executed in, all other paths options are relative to this path',
    });
    configPath = Option.String('--config-path,-c', {
        description: 'Path to `napi` config json file',
    });
    packageJsonPath = Option.String('--package-json-path', 'package.json', {
        description: 'Path to `package.json`',
    });
    outputDir = Option.String('--output-dir,-o', './', {
        description: 'Path to the folder where all built `.node` files put, same as `--output-dir` of build command',
    });
    getOptions() {
        return {
            cwd: this.cwd,
            configPath: this.configPath,
            packageJsonPath: this.packageJsonPath,
            outputDir: this.outputDir,
        };
    }
}
export function applyDefaultUniversalizeOptions(options) {
    return {
        cwd: process.cwd(),
        packageJsonPath: 'package.json',
        outputDir: './',
        ...options,
    };
}
//# sourceMappingURL=universalize.js.map