import { Command } from 'clipanion';
export declare abstract class BaseUniversalizeCommand extends Command {
    static paths: string[][];
    static usage: import("clipanion").Usage;
    cwd: string;
    configPath?: string;
    packageJsonPath: string;
    outputDir: string;
    getOptions(): {
        cwd: string;
        configPath: string | undefined;
        packageJsonPath: string;
        outputDir: string;
    };
}
/**
 * Combile built binaries into one universal binary
 */
export interface UniversalizeOptions {
    /**
     * The working directory of where napi command will be executed in, all other paths options are relative to this path
     *
     * @default process.cwd()
     */
    cwd?: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    /**
     * Path to `package.json`
     *
     * @default 'package.json'
     */
    packageJsonPath?: string;
    /**
     * Path to the folder where all built `.node` files put, same as `--output-dir` of build command
     *
     * @default './'
     */
    outputDir?: string;
}
export declare function applyDefaultUniversalizeOptions(options: UniversalizeOptions): {
    cwd: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    packageJsonPath: string;
    outputDir: string;
};
