import { Command } from 'clipanion';
export declare abstract class BaseRenameCommand extends Command {
    static paths: string[][];
    static usage: import("clipanion").Usage;
    cwd: string;
    configPath?: string;
    packageJsonPath: string;
    npmDir: string;
    $$name?: string;
    binaryName?: string;
    packageName?: string;
    manifestPath: string;
    repository?: string;
    description?: string;
    getOptions(): {
        cwd: string;
        configPath: string | undefined;
        packageJsonPath: string;
        npmDir: string;
        name: string | undefined;
        binaryName: string | undefined;
        packageName: string | undefined;
        manifestPath: string;
        repository: string | undefined;
        description: string | undefined;
    };
}
/**
 * Rename the NAPI-RS project
 */
export interface RenameOptions {
    /**
     * The working directory of where napi command will be executed in, all other paths options are relative to this path
     *
     * @default process.cwd()
     */
    cwd?: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    /**
     * Path to `package.json`
     *
     * @default 'package.json'
     */
    packageJsonPath?: string;
    /**
     * Path to the folder where the npm packages put
     *
     * @default 'npm'
     */
    npmDir?: string;
    /**
     * The new name of the project
     */
    name?: string;
    /**
     * The new binary name *.node files
     */
    binaryName?: string;
    /**
     * The new package name of the project
     */
    packageName?: string;
    /**
     * Path to `Cargo.toml`
     *
     * @default 'Cargo.toml'
     */
    manifestPath?: string;
    /**
     * The new repository of the project
     */
    repository?: string;
    /**
     * The new description of the project
     */
    description?: string;
}
export declare function applyDefaultRenameOptions(options: RenameOptions): {
    cwd: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    packageJsonPath: string;
    npmDir: string;
    /**
     * The new name of the project
     */
    name?: string;
    /**
     * The new binary name *.node files
     */
    binaryName?: string;
    /**
     * The new package name of the project
     */
    packageName?: string;
    manifestPath: string;
    /**
     * The new repository of the project
     */
    repository?: string;
    /**
     * The new description of the project
     */
    description?: string;
};
