// This file is generated by codegen/index.ts
// Do not edit this file manually
import { Command, Option } from 'clipanion';
export class BasePrePublishCommand extends Command {
    static paths = [['pre-publish'], ['prepublish']];
    static usage = Command.Usage({
        description: 'Update package.json and copy addons into per platform packages',
    });
    cwd = Option.String('--cwd', process.cwd(), {
        description: 'The working directory of where napi command will be executed in, all other paths options are relative to this path',
    });
    configPath = Option.String('--config-path,-c', {
        description: 'Path to `napi` config json file',
    });
    packageJsonPath = Option.String('--package-json-path', 'package.json', {
        description: 'Path to `package.json`',
    });
    npmDir = Option.String('--npm-dir,-p', 'npm', {
        description: 'Path to the folder where the npm packages put',
    });
    tagStyle = Option.String('--tag-style,--tagstyle,-t', 'lerna', {
        description: 'git tag style, `npm` or `lerna`',
    });
    ghRelease = Option.Boolean('--gh-release', true, {
        description: 'Whether create GitHub release',
    });
    ghReleaseName = Option.String('--gh-release-name', {
        description: 'GitHub release name',
    });
    ghReleaseId = Option.String('--gh-release-id', {
        description: 'Existing GitHub release id',
    });
    dryRun = Option.Boolean('--dry-run', false, {
        description: 'Dry run without touching file system',
    });
    getOptions() {
        return {
            cwd: this.cwd,
            configPath: this.configPath,
            packageJsonPath: this.packageJsonPath,
            npmDir: this.npmDir,
            tagStyle: this.tagStyle,
            ghRelease: this.ghRelease,
            ghReleaseName: this.ghReleaseName,
            ghReleaseId: this.ghReleaseId,
            dryRun: this.dryRun,
        };
    }
}
export function applyDefaultPrePublishOptions(options) {
    return {
        cwd: process.cwd(),
        packageJsonPath: 'package.json',
        npmDir: 'npm',
        tagStyle: 'lerna',
        ghRelease: true,
        dryRun: false,
        ...options,
    };
}
//# sourceMappingURL=pre-publish.js.map