import { Command } from 'clipanion';
export declare abstract class BasePrePublishCommand extends Command {
    static paths: string[][];
    static usage: import("clipanion").Usage;
    cwd: string;
    configPath?: string;
    packageJsonPath: string;
    npmDir: string;
    tagStyle: string;
    ghRelease: boolean;
    ghReleaseName?: string;
    ghReleaseId?: string;
    dryRun: boolean;
    getOptions(): {
        cwd: string;
        configPath: string | undefined;
        packageJsonPath: string;
        npmDir: string;
        tagStyle: string;
        ghRelease: boolean;
        ghReleaseName: string | undefined;
        ghReleaseId: string | undefined;
        dryRun: boolean;
    };
}
/**
 * Update package.json and copy addons into per platform packages
 */
export interface PrePublishOptions {
    /**
     * The working directory of where napi command will be executed in, all other paths options are relative to this path
     *
     * @default process.cwd()
     */
    cwd?: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    /**
     * Path to `package.json`
     *
     * @default 'package.json'
     */
    packageJsonPath?: string;
    /**
     * Path to the folder where the npm packages put
     *
     * @default 'npm'
     */
    npmDir?: string;
    /**
     * git tag style, `npm` or `lerna`
     *
     * @default 'lerna'
     */
    tagStyle?: 'npm' | 'lerna';
    /**
     * Whether create GitHub release
     *
     * @default true
     */
    ghRelease?: boolean;
    /**
     * GitHub release name
     */
    ghReleaseName?: string;
    /**
     * Existing GitHub release id
     */
    ghReleaseId?: string;
    /**
     * Dry run without touching file system
     *
     * @default false
     */
    dryRun?: boolean;
}
export declare function applyDefaultPrePublishOptions(options: PrePublishOptions): {
    cwd: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    packageJsonPath: string;
    npmDir: string;
    tagStyle: string;
    ghRelease: boolean;
    /**
     * GitHub release name
     */
    ghReleaseName?: string;
    /**
     * Existing GitHub release id
     */
    ghReleaseId?: string;
    dryRun: boolean;
};
