import { Command } from 'clipanion';
export declare abstract class BaseNewCommand extends Command {
    static paths: string[][];
    static usage: import("clipanion").Usage;
    $$path: string | undefined;
    $$name?: string;
    minNodeApiVersion: number;
    packageManager: string;
    license: string;
    targets: string[];
    enableDefaultTargets: boolean;
    enableAllTargets: boolean;
    enableTypeDef: boolean;
    enableGithubActions: boolean;
    testFramework: string;
    dryRun: boolean;
    getOptions(): {
        path: string | undefined;
        name: string | undefined;
        minNodeApiVersion: number;
        packageManager: string;
        license: string;
        targets: string[];
        enableDefaultTargets: boolean;
        enableAllTargets: boolean;
        enableTypeDef: boolean;
        enableGithubActions: boolean;
        testFramework: string;
        dryRun: boolean;
    };
}
/**
 * Create a new project with pre-configured boilerplate
 */
export interface NewOptions {
    /**
     * The path where the NAPI-RS project will be created.
     */
    path?: string;
    /**
     * The name of the project, default to the name of the directory if not provided
     */
    name?: string;
    /**
     * The minimum Node-API version to support
     *
     * @default 4
     */
    minNodeApiVersion?: number;
    /**
     * The package manager to use. Only support yarn 4.x for now.
     *
     * @default 'yarn'
     */
    packageManager?: string;
    /**
     * License for open-sourced project
     *
     * @default 'MIT'
     */
    license?: string;
    /**
     * All targets the crate will be compiled for.
     *
     * @default []
     */
    targets?: string[];
    /**
     * Whether enable default targets
     *
     * @default true
     */
    enableDefaultTargets?: boolean;
    /**
     * Whether enable all targets
     *
     * @default false
     */
    enableAllTargets?: boolean;
    /**
     * Whether enable the `type-def` feature for typescript definitions auto-generation
     *
     * @default true
     */
    enableTypeDef?: boolean;
    /**
     * Whether generate preconfigured GitHub Actions workflow
     *
     * @default true
     */
    enableGithubActions?: boolean;
    /**
     * The JavaScript test framework to use, only support `ava` for now
     *
     * @default 'ava'
     */
    testFramework?: string;
    /**
     * Whether to run the command in dry-run mode
     *
     * @default false
     */
    dryRun?: boolean;
}
export declare function applyDefaultNewOptions(options: NewOptions): {
    /**
     * The path where the NAPI-RS project will be created.
     */
    path?: string;
    /**
     * The name of the project, default to the name of the directory if not provided
     */
    name?: string;
    minNodeApiVersion: number;
    packageManager: string;
    license: string;
    targets: string[];
    enableDefaultTargets: boolean;
    enableAllTargets: boolean;
    enableTypeDef: boolean;
    enableGithubActions: boolean;
    testFramework: string;
    dryRun: boolean;
};
