import { Command } from 'clipanion';
export declare abstract class BaseCreateNpmDirsCommand extends Command {
    static paths: string[][];
    static usage: import("clipanion").Usage;
    cwd: string;
    configPath?: string;
    packageJsonPath: string;
    npmDir: string;
    dryRun: boolean;
    getOptions(): {
        cwd: string;
        configPath: string | undefined;
        packageJsonPath: string;
        npmDir: string;
        dryRun: boolean;
    };
}
/**
 * Create npm package dirs for different platforms
 */
export interface CreateNpmDirsOptions {
    /**
     * The working directory of where napi command will be executed in, all other paths options are relative to this path
     *
     * @default process.cwd()
     */
    cwd?: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    /**
     * Path to `package.json`
     *
     * @default 'package.json'
     */
    packageJsonPath?: string;
    /**
     * Path to the folder where the npm packages put
     *
     * @default 'npm'
     */
    npmDir?: string;
    /**
     * Dry run without touching file system
     *
     * @default false
     */
    dryRun?: boolean;
}
export declare function applyDefaultCreateNpmDirsOptions(options: CreateNpmDirsOptions): {
    cwd: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    packageJsonPath: string;
    npmDir: string;
    dryRun: boolean;
};
