// This file is generated by codegen/index.ts
// Do not edit this file manually
import { Command, Option } from 'clipanion';
export class BaseBuildCommand extends Command {
    static paths = [['build']];
    static usage = Command.Usage({
        description: 'Build the NAPI-RS project',
    });
    target = Option.String('--target,-t', {
        description: 'Build for the target triple, bypassed to `cargo build --target`',
    });
    cwd = Option.String('--cwd', {
        description: 'The working directory of where napi command will be executed in, all other paths options are relative to this path',
    });
    manifestPath = Option.String('--manifest-path', {
        description: 'Path to `Cargo.toml`',
    });
    configPath = Option.String('--config-path,-c', {
        description: 'Path to `napi` config json file',
    });
    packageJsonPath = Option.String('--package-json-path', {
        description: 'Path to `package.json`',
    });
    targetDir = Option.String('--target-dir', {
        description: 'Directory for all crate generated artifacts, see `cargo build --target-dir`',
    });
    outputDir = Option.String('--output-dir,-o', {
        description: 'Path to where all the built files would be put. Default to the crate folder',
    });
    platform = Option.Boolean('--platform', {
        description: 'Add platform triple to the generated nodejs binding file, eg: `[name].linux-x64-gnu.node`',
    });
    jsPackageName = Option.String('--js-package-name', {
        description: 'Package name in generated js binding file. Only works with `--platform` flag',
    });
    constEnum = Option.Boolean('--const-enum', {
        description: 'Whether generate const enum for typescript bindings',
    });
    jsBinding = Option.String('--js', {
        description: 'Path and filename of generated JS binding file. Only works with `--platform` flag. Relative to `--output-dir`.',
    });
    noJsBinding = Option.Boolean('--no-js', {
        description: 'Whether to disable the generation JS binding file. Only works with `--platform` flag.',
    });
    dts = Option.String('--dts', {
        description: 'Path and filename of generated type def file. Relative to `--output-dir`',
    });
    dtsHeader = Option.String('--dts-header', {
        description: 'Custom file header for generated type def file. Only works when `typedef` feature enabled.',
    });
    noDtsHeader = Option.Boolean('--no-dts-header', {
        description: 'Whether to disable the default file header for generated type def file. Only works when `typedef` feature enabled.',
    });
    dtsCache = Option.Boolean('--dts-cache', true, {
        description: 'Whether to enable the dts cache, default to true',
    });
    esm = Option.Boolean('--esm', {
        description: 'Whether to emit an ESM JS binding file instead of CJS format. Only works with `--platform` flag.',
    });
    strip = Option.Boolean('--strip,-s', {
        description: 'Whether strip the library to achieve the minimum file size',
    });
    release = Option.Boolean('--release,-r', {
        description: 'Build in release mode',
    });
    verbose = Option.Boolean('--verbose,-v', {
        description: 'Verbosely log build command trace',
    });
    bin = Option.String('--bin', {
        description: 'Build only the specified binary',
    });
    package = Option.String('--package,-p', {
        description: 'Build the specified library or the one at cwd',
    });
    profile = Option.String('--profile', {
        description: 'Build artifacts with the specified profile',
    });
    crossCompile = Option.Boolean('--cross-compile,-x', {
        description: '[experimental] cross-compile for the specified target with `cargo-xwin` on windows and `cargo-zigbuild` on other platform',
    });
    useCross = Option.Boolean('--use-cross', {
        description: '[experimental] use [cross](https://github.com/cross-rs/cross) instead of `cargo`',
    });
    useNapiCross = Option.Boolean('--use-napi-cross', {
        description: '[experimental] use @napi-rs/cross-toolchain to cross-compile Linux arm/arm64/x64 gnu targets.',
    });
    watch = Option.Boolean('--watch,-w', {
        description: 'watch the crate changes and build continuously with `cargo-watch` crates',
    });
    features = Option.Array('--features,-F', {
        description: 'Space-separated list of features to activate',
    });
    allFeatures = Option.Boolean('--all-features', {
        description: 'Activate all available features',
    });
    noDefaultFeatures = Option.Boolean('--no-default-features', {
        description: 'Do not activate the `default` feature',
    });
    getOptions() {
        return {
            target: this.target,
            cwd: this.cwd,
            manifestPath: this.manifestPath,
            configPath: this.configPath,
            packageJsonPath: this.packageJsonPath,
            targetDir: this.targetDir,
            outputDir: this.outputDir,
            platform: this.platform,
            jsPackageName: this.jsPackageName,
            constEnum: this.constEnum,
            jsBinding: this.jsBinding,
            noJsBinding: this.noJsBinding,
            dts: this.dts,
            dtsHeader: this.dtsHeader,
            noDtsHeader: this.noDtsHeader,
            dtsCache: this.dtsCache,
            esm: this.esm,
            strip: this.strip,
            release: this.release,
            verbose: this.verbose,
            bin: this.bin,
            package: this.package,
            profile: this.profile,
            crossCompile: this.crossCompile,
            useCross: this.useCross,
            useNapiCross: this.useNapiCross,
            watch: this.watch,
            features: this.features,
            allFeatures: this.allFeatures,
            noDefaultFeatures: this.noDefaultFeatures,
        };
    }
}
export function applyDefaultBuildOptions(options) {
    return {
        dtsCache: true,
        ...options,
    };
}
//# sourceMappingURL=build.js.map