import { Command } from 'clipanion';
export declare abstract class BaseBuildCommand extends Command {
    static paths: string[][];
    static usage: import("clipanion").Usage;
    target?: string;
    cwd?: string;
    manifestPath?: string;
    configPath?: string;
    packageJsonPath?: string;
    targetDir?: string;
    outputDir?: string;
    platform?: boolean;
    jsPackageName?: string;
    constEnum?: boolean;
    jsBinding?: string;
    noJsBinding?: boolean;
    dts?: string;
    dtsHeader?: string;
    noDtsHeader?: boolean;
    dtsCache: boolean;
    esm?: boolean;
    strip?: boolean;
    release?: boolean;
    verbose?: boolean;
    bin?: string;
    package?: string;
    profile?: string;
    crossCompile?: boolean;
    useCross?: boolean;
    useNapiCross?: boolean;
    watch?: boolean;
    features?: string[];
    allFeatures?: boolean;
    noDefaultFeatures?: boolean;
    getOptions(): {
        target: string | undefined;
        cwd: string | undefined;
        manifestPath: string | undefined;
        configPath: string | undefined;
        packageJsonPath: string | undefined;
        targetDir: string | undefined;
        outputDir: string | undefined;
        platform: boolean | undefined;
        jsPackageName: string | undefined;
        constEnum: boolean | undefined;
        jsBinding: string | undefined;
        noJsBinding: boolean | undefined;
        dts: string | undefined;
        dtsHeader: string | undefined;
        noDtsHeader: boolean | undefined;
        dtsCache: boolean;
        esm: boolean | undefined;
        strip: boolean | undefined;
        release: boolean | undefined;
        verbose: boolean | undefined;
        bin: string | undefined;
        package: string | undefined;
        profile: string | undefined;
        crossCompile: boolean | undefined;
        useCross: boolean | undefined;
        useNapiCross: boolean | undefined;
        watch: boolean | undefined;
        features: string[] | undefined;
        allFeatures: boolean | undefined;
        noDefaultFeatures: boolean | undefined;
    };
}
/**
 * Build the NAPI-RS project
 */
export interface BuildOptions {
    /**
     * Build for the target triple, bypassed to `cargo build --target`
     */
    target?: string;
    /**
     * The working directory of where napi command will be executed in, all other paths options are relative to this path
     */
    cwd?: string;
    /**
     * Path to `Cargo.toml`
     */
    manifestPath?: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    /**
     * Path to `package.json`
     */
    packageJsonPath?: string;
    /**
     * Directory for all crate generated artifacts, see `cargo build --target-dir`
     */
    targetDir?: string;
    /**
     * Path to where all the built files would be put. Default to the crate folder
     */
    outputDir?: string;
    /**
     * Add platform triple to the generated nodejs binding file, eg: `[name].linux-x64-gnu.node`
     */
    platform?: boolean;
    /**
     * Package name in generated js binding file. Only works with `--platform` flag
     */
    jsPackageName?: string;
    /**
     * Whether generate const enum for typescript bindings
     */
    constEnum?: boolean;
    /**
     * Path and filename of generated JS binding file. Only works with `--platform` flag. Relative to `--output-dir`.
     */
    jsBinding?: string;
    /**
     * Whether to disable the generation JS binding file. Only works with `--platform` flag.
     */
    noJsBinding?: boolean;
    /**
     * Path and filename of generated type def file. Relative to `--output-dir`
     */
    dts?: string;
    /**
     * Custom file header for generated type def file. Only works when `typedef` feature enabled.
     */
    dtsHeader?: string;
    /**
     * Whether to disable the default file header for generated type def file. Only works when `typedef` feature enabled.
     */
    noDtsHeader?: boolean;
    /**
     * Whether to enable the dts cache, default to true
     *
     * @default true
     */
    dtsCache?: boolean;
    /**
     * Whether to emit an ESM JS binding file instead of CJS format. Only works with `--platform` flag.
     */
    esm?: boolean;
    /**
     * Whether strip the library to achieve the minimum file size
     */
    strip?: boolean;
    /**
     * Build in release mode
     */
    release?: boolean;
    /**
     * Verbosely log build command trace
     */
    verbose?: boolean;
    /**
     * Build only the specified binary
     */
    bin?: string;
    /**
     * Build the specified library or the one at cwd
     */
    package?: string;
    /**
     * Build artifacts with the specified profile
     */
    profile?: string;
    /**
     * [experimental] cross-compile for the specified target with `cargo-xwin` on windows and `cargo-zigbuild` on other platform
     */
    crossCompile?: boolean;
    /**
     * [experimental] use [cross](https://github.com/cross-rs/cross) instead of `cargo`
     */
    useCross?: boolean;
    /**
     * [experimental] use @napi-rs/cross-toolchain to cross-compile Linux arm/arm64/x64 gnu targets.
     */
    useNapiCross?: boolean;
    /**
     * watch the crate changes and build continuously with `cargo-watch` crates
     */
    watch?: boolean;
    /**
     * Space-separated list of features to activate
     */
    features?: string[];
    /**
     * Activate all available features
     */
    allFeatures?: boolean;
    /**
     * Do not activate the `default` feature
     */
    noDefaultFeatures?: boolean;
}
export declare function applyDefaultBuildOptions(options: BuildOptions): {
    /**
     * Build for the target triple, bypassed to `cargo build --target`
     */
    target?: string;
    /**
     * The working directory of where napi command will be executed in, all other paths options are relative to this path
     */
    cwd?: string;
    /**
     * Path to `Cargo.toml`
     */
    manifestPath?: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    /**
     * Path to `package.json`
     */
    packageJsonPath?: string;
    /**
     * Directory for all crate generated artifacts, see `cargo build --target-dir`
     */
    targetDir?: string;
    /**
     * Path to where all the built files would be put. Default to the crate folder
     */
    outputDir?: string;
    /**
     * Add platform triple to the generated nodejs binding file, eg: `[name].linux-x64-gnu.node`
     */
    platform?: boolean;
    /**
     * Package name in generated js binding file. Only works with `--platform` flag
     */
    jsPackageName?: string;
    /**
     * Whether generate const enum for typescript bindings
     */
    constEnum?: boolean;
    /**
     * Path and filename of generated JS binding file. Only works with `--platform` flag. Relative to `--output-dir`.
     */
    jsBinding?: string;
    /**
     * Whether to disable the generation JS binding file. Only works with `--platform` flag.
     */
    noJsBinding?: boolean;
    /**
     * Path and filename of generated type def file. Relative to `--output-dir`
     */
    dts?: string;
    /**
     * Custom file header for generated type def file. Only works when `typedef` feature enabled.
     */
    dtsHeader?: string;
    /**
     * Whether to disable the default file header for generated type def file. Only works when `typedef` feature enabled.
     */
    noDtsHeader?: boolean;
    dtsCache: boolean;
    /**
     * Whether to emit an ESM JS binding file instead of CJS format. Only works with `--platform` flag.
     */
    esm?: boolean;
    /**
     * Whether strip the library to achieve the minimum file size
     */
    strip?: boolean;
    /**
     * Build in release mode
     */
    release?: boolean;
    /**
     * Verbosely log build command trace
     */
    verbose?: boolean;
    /**
     * Build only the specified binary
     */
    bin?: string;
    /**
     * Build the specified library or the one at cwd
     */
    package?: string;
    /**
     * Build artifacts with the specified profile
     */
    profile?: string;
    /**
     * [experimental] cross-compile for the specified target with `cargo-xwin` on windows and `cargo-zigbuild` on other platform
     */
    crossCompile?: boolean;
    /**
     * [experimental] use [cross](https://github.com/cross-rs/cross) instead of `cargo`
     */
    useCross?: boolean;
    /**
     * [experimental] use @napi-rs/cross-toolchain to cross-compile Linux arm/arm64/x64 gnu targets.
     */
    useNapiCross?: boolean;
    /**
     * watch the crate changes and build continuously with `cargo-watch` crates
     */
    watch?: boolean;
    /**
     * Space-separated list of features to activate
     */
    features?: string[];
    /**
     * Activate all available features
     */
    allFeatures?: boolean;
    /**
     * Do not activate the `default` feature
     */
    noDefaultFeatures?: boolean;
};
