// This file is generated by codegen/index.ts
// Do not edit this file manually
import { Command, Option } from 'clipanion';
export class BaseArtifactsCommand extends Command {
    static paths = [['artifacts']];
    static usage = Command.Usage({
        description: 'Copy artifacts from Github Actions into npm packages and ready to publish',
    });
    cwd = Option.String('--cwd', process.cwd(), {
        description: 'The working directory of where napi command will be executed in, all other paths options are relative to this path',
    });
    configPath = Option.String('--config-path,-c', {
        description: 'Path to `napi` config json file',
    });
    packageJsonPath = Option.String('--package-json-path', 'package.json', {
        description: 'Path to `package.json`',
    });
    outputDir = Option.String('--output-dir,-o,-d', './artifacts', {
        description: 'Path to the folder where all built `.node` files put, same as `--output-dir` of build command',
    });
    npmDir = Option.String('--npm-dir', 'npm', {
        description: 'Path to the folder where the npm packages put',
    });
    buildOutputDir = Option.String('--build-output-dir', {
        description: 'Path to the build output dir, only needed when targets contains `wasm32-wasi-*`',
    });
    getOptions() {
        return {
            cwd: this.cwd,
            configPath: this.configPath,
            packageJsonPath: this.packageJsonPath,
            outputDir: this.outputDir,
            npmDir: this.npmDir,
            buildOutputDir: this.buildOutputDir,
        };
    }
}
export function applyDefaultArtifactsOptions(options) {
    return {
        cwd: process.cwd(),
        packageJsonPath: 'package.json',
        outputDir: './artifacts',
        npmDir: 'npm',
        ...options,
    };
}
//# sourceMappingURL=artifacts.js.map