import { Command } from 'clipanion';
export declare abstract class BaseArtifactsCommand extends Command {
    static paths: string[][];
    static usage: import("clipanion").Usage;
    cwd: string;
    configPath?: string;
    packageJsonPath: string;
    outputDir: string;
    npmDir: string;
    buildOutputDir?: string;
    getOptions(): {
        cwd: string;
        configPath: string | undefined;
        packageJsonPath: string;
        outputDir: string;
        npmDir: string;
        buildOutputDir: string | undefined;
    };
}
/**
 * Copy artifacts from Github Actions into npm packages and ready to publish
 */
export interface ArtifactsOptions {
    /**
     * The working directory of where napi command will be executed in, all other paths options are relative to this path
     *
     * @default process.cwd()
     */
    cwd?: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    /**
     * Path to `package.json`
     *
     * @default 'package.json'
     */
    packageJsonPath?: string;
    /**
     * Path to the folder where all built `.node` files put, same as `--output-dir` of build command
     *
     * @default './artifacts'
     */
    outputDir?: string;
    /**
     * Path to the folder where the npm packages put
     *
     * @default 'npm'
     */
    npmDir?: string;
    /**
     * Path to the build output dir, only needed when targets contains `wasm32-wasi-*`
     */
    buildOutputDir?: string;
}
export declare function applyDefaultArtifactsOptions(options: ArtifactsOptions): {
    cwd: string;
    /**
     * Path to `napi` config json file
     */
    configPath?: string;
    packageJsonPath: string;
    outputDir: string;
    npmDir: string;
    /**
     * Path to the build output dir, only needed when targets contains `wasm32-wasi-*`
     */
    buildOutputDir?: string;
};
