export declare const WASI_WORKER_TEMPLATE = "import fs from \"node:fs\";\nimport { createRequire } from \"node:module\";\nimport { parse } from \"node:path\";\nimport { WASI } from \"node:wasi\";\nimport { parentPort, Worker } from \"node:worker_threads\";\n\nconst require = createRequire(import.meta.url);\n\nconst { instantiateNapiModuleSync, MessageHandler, getDefaultContext } = require(\"@napi-rs/wasm-runtime\");\n\nif (parentPort) {\n  parentPort.on(\"message\", (data) => {\n    globalThis.onmessage({ data });\n  });\n}\n\nObject.assign(globalThis, {\n  self: globalThis,\n  require,\n  Worker,\n  importScripts: function (f) {\n    ;(0, eval)(fs.readFileSync(f, \"utf8\") + \"//# sourceURL=\" + f);\n  },\n  postMessage: function (msg) {\n    if (parentPort) {\n      parentPort.postMessage(msg);\n    }\n  },\n});\n\nconst emnapiContext = getDefaultContext();\n\nconst __rootDir = parse(process.cwd()).root;\n\nconst handler = new MessageHandler({\n  onLoad({ wasmModule, wasmMemory }) {\n    const wasi = new WASI({\n      version: 'preview1',\n      env: process.env,\n      preopens: {\n        [__rootDir]: __rootDir,\n      },\n    });\n\n    return instantiateNapiModuleSync(wasmModule, {\n      childThread: true,\n      wasi,\n      context: emnapiContext,\n      overwriteImports(importObject) {\n        importObject.env = {\n          ...importObject.env,\n          ...importObject.napi,\n          ...importObject.emnapi,\n          memory: wasmMemory\n        };\n      },\n    });\n  },\n});\n\nglobalThis.onmessage = function (e) {\n  handler.handle(e);\n};\n";
export declare const createWasiBrowserWorkerBinding: (fs: boolean) => string;
