import { createRequire } from 'node:module';
/** @internal */
export function loadBindings(moduleUrl, moduleName) {
    const require = createRequire(moduleUrl);
    const pathsToTry = [];
    for (const dir of ['.', '..']) {
        for (const subdir of ['', 'build/Release', 'build/Debug']) {
            for (const filename of [
                withTuple(moduleName),
                withExtendedTuple(moduleName),
                moduleName,
            ]) {
                const pathToTry = modulePath(joinPath(dir, subdir), filename);
                pathsToTry.push(pathToTry);
            }
        }
    }
    for (const pathToTry of pathsToTry) {
        try {
            return require(pathToTry);
            // eslint-disable-next-line
        }
        catch (e) { }
    }
    throw new Error(`No native build was found for ${moduleName}, imported from ${moduleUrl}. Checked paths:
${pathsToTry.join('\n')}`);
}
function joinPath(...parts) {
    return parts.filter((p) => p != '').join('/');
}
function modulePath(dir, moduleName) {
    return joinPath(dir, `${moduleName}.node`);
}
function withTuple(name) {
    return `${name}.${process.platform}-${process.arch}`;
}
function withExtendedTuple(name) {
    // we are not supporting alpine for now
    let tag;
    switch (process.platform) {
        case 'linux':
            tag = '-gnu';
            break;
        case 'win32':
            tag = '-msvc';
            break;
        default:
            tag = '';
            break;
    }
    return `${name}.${process.platform}-${process.arch}${tag}`;
}
