#ifndef TUTA_RAND_H
#define TUTA_RAND_H

#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Overwrite entropy with the contents of the buffer. Up to AMOUNT_OF_ENTROPY can be loaded at once.
 *
 * @param bytes  random bytes to be generated by the caller (NOTE: take care to clear this buffer afterward!)
 * @param amount number of bytes in the buffer
 * @return       how much entropy is left (negative value if the amount is greater than the size of the entropy pool)
 */
long TUTA_inject_entropy(const void *bytes, size_t amount);

#ifdef __cplusplus
}
#endif

#endif
