// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for Tamil (`ta`).
class AppLocalizationsTa extends AppLocalizations {
  AppLocalizationsTa([String locale = 'ta']) : super(locale);

  @override
  String get aboutTitle => 'பற்றி';

  @override
  String get aboutSlogan => 'அடுத்த நிறுத்தம்: அணுகல்';

  @override
  String get aboutVersionLabel => 'பதிப்பு';

  @override
  String get aboutAuthorsLabel => 'ஆசிரியர்கள்';

  @override
  String aboutAuthorsDescription(String appName) {
    return '$appName பங்களிப்பாளர்கள்';
  }

  @override
  String get aboutPrivacyPolicyLabel => 'தனியுரிமைக் கொள்கை';

  @override
  String get aboutIdeaLabel => 'சிந்தனை';

  @override
  String get aboutIdeaDescription =>
      'செம்னிட்ச் தொழில்நுட்ப பல்கலைக்கழகம்\n பேராசிரியர்சிப் சுற்று மற்றும் கணினி வடிவமைப்பு';

  @override
  String get aboutLicenseLabel => 'உரிமம்';

  @override
  String get aboutLicensePackageLabel => 'பயன்படுத்தப்பட்ட தொகுப்புகளின் உரிமங்கள்';

  @override
  String get aboutSourceCodeLabel => 'மூலக் குறியீடு';

  @override
  String get aboutStatisticLabel => 'Statistic';

  @override
  String get helpTitle => 'உதவி';

  @override
  String get helpOnboardingLabel => 'அறிமுகத்தை மீண்டும் பாருங்கள்';

  @override
  String get helpReportErrorLabel => 'பிழையைப் புகாரளிக்கவும்';

  @override
  String get helpImproveTranslationLabel => 'மொழிபெயர்ப்பை மேம்படுத்தவும்';

  @override
  String get onboardingGreetingTitle => 'ஏய்!';

  @override
  String get onboardingGreetingDescription =>
      'நீங்கள் இங்கே இருக்கிறீர்கள் என்பதில் நாங்கள் மகிழ்ச்சியடைகிறோம், பொது போக்குவரத்தை மேம்படுத்த உங்கள் பங்கைச் செய்ய விரும்புகிறோம்.';

  @override
  String get onboardingGreetingButton => 'இது எவ்வாறு செயல்படுகிறது என்பது இங்கே';

  @override
  String get onboardingSurveyingTitle => 'பாருங்கள்';

  @override
  String get onboardingSurveyingDescription =>
      'அதன் தற்போதைய நிலையை ஆய்வு செய்ய அருகிலுள்ள நிறுத்தத்திற்குச் செல்லுங்கள்.';

  @override
  String get onboardingSurveyingButton => 'நான் அதை செய்வேன்';

  @override
  String get onboardingAnsweringTitle => 'இப்போது அது உங்கள் முறை';

  @override
  String get onboardingAnsweringDescription =>
      'தரவைச் சேகரிக்க பயன்பாட்டில் ஒரு மார்க்கரைத் தேர்ந்தெடுத்து காட்டப்பட்ட கேள்விகளுக்கு பதிலளிக்கவும்.';

  @override
  String get onboardingAnsweringButton => 'சரி, கிடைத்தது';

  @override
  String get onboardingContributingTitle => 'பகிர்வு அக்கறை கொண்டுள்ளது';

  @override
  String get onboardingContributingDescription =>
      'உங்கள் பதில்களை ஓபன்ச்ட்ரீட்மேப்பில் பதிவேற்றவும் அவற்றை உலகம் முழுவதும் பகிர்ந்து கொள்ளவும்.';

  @override
  String get onboardingContributingButton => 'இங்கே நாம் செல்கிறோம்';

  @override
  String get privacyPolicyTitle => 'தனியுரிமைக் கொள்கை';

  @override
  String get settingsTitle => 'அமைப்புகள்';

  @override
  String get settingsProfessionalQuestionsLabel => 'காட்சி Professional கேள்விகள்';

  @override
  String get settingsProfessionalQuestionsDescription =>
      'க்கு safety reasons only intended க்கு professionals';

  @override
  String get settingsThemeLabel => 'Color Scheme of the பயன்பாடு';

  @override
  String get settingsThemeDialogTitle => 'தேர்ந்தெடு theme';

  @override
  String get settingsThemeOptionSystem => 'மண்டலம் Setting';

  @override
  String get settingsThemeOptionLight => 'ஒளி';

  @override
  String get settingsThemeOptionDark => 'இருள்';

  @override
  String get logoutDialogTitle => 'ஒஎச்எம் இலிருந்து வெளியேறவா?';

  @override
  String get logoutDialogDescription =>
      'If you log out, you can இல்லை longer upload changes பெறுநர் OpenStreetMap.';

  @override
  String get loginHint => 'Log in with your OpenStreetMap account பெறுநர் upload your changes.';

  @override
  String get numberInputPlaceholder => 'இங்கே உள்ளிடவும்…';

  @override
  String get numberInputFallbackName => 'மதிப்பு';

  @override
  String get numberInputValidationError => 'தவறான எண்';

  @override
  String numberInputValidationErrorMax(String nameString, num max, String unit) {
    return '$nameString $max $unit ஐ விட குறைவாக இருக்க வேண்டும்.';
  }

  @override
  String numberInputValidationErrorMin(String nameString, num min, String unit) {
    return '$nameString $min $unit ஐ விட அதிகமாக இருக்க வேண்டும்.';
  }

  @override
  String get stringInputPlaceholder => 'இங்கே உள்ளிடவும்…';

  @override
  String get stringInputValidationErrorMin => 'உள்ளீடு மிகக் குறைவு';

  @override
  String changesetCommentMessage(String mapFeaturesString, String stopsString) {
    return '$stopsString நிறுத்தப் பகுதியில் $mapFeaturesString இல் விவரங்களைச் சேர்.';
  }

  @override
  String get changesetCommentConjunctionString => 'மற்றும்';

  @override
  String get uploadMessageSuccess => 'மாற்றங்கள் வெற்றிகரமாக பதிவேற்றப்பட்டன.';

  @override
  String get uploadMessageServerConnectionError => 'பிழை: OSM சேவையகத்துடன் எந்த தொடர்பும் இல்லை.';

  @override
  String get uploadMessageUnknownConnectionError => 'பரிமாற்றத்தின் போது தெரியாத பிழை.';

  @override
  String get queryMessageServerUnavailableError =>
      'சேவையகம் கிடைக்கவில்லை அல்லது அதிக சுமை. பின்னர் மீண்டும் முயற்சிக்கவும்.';

  @override
  String get queryMessageTooManyRequestsError => 'சேவையகத்திற்கு பல கோரிக்கைகள்.';

  @override
  String get queryMessageConnectionTimeoutError => 'பிழை: சேவையக வினவல் நேரம் முடிந்தது.';

  @override
  String get queryMessageReceiveTimeoutError => 'பிழை: தரவைப் பெறுவது நேரம் முடிந்தது.';

  @override
  String get queryMessageUnknownServerCommunicationError =>
      'சேவையக தகவல்தொடர்பு போது தெரியாத பிழை.';

  @override
  String get queryMessageUnknownError => 'தெரியாத பிழை.';

  @override
  String questionnaireSummaryDedicatedMessage(String userName) {
    return 'உங்கள் பதில்களுக்கு நன்றி $userName. \nபதிவேற்றுவதற்கு முன் அவற்றைச் சரிபார்.';
  }

  @override
  String get questionnaireSummaryUndedicatedMessage =>
      'உங்கள் பதில்களுக்கு நன்றி.\n பதிவேற்றுவதற்கு முன் அவற்றை சரிபார்க்கவும்.';

  @override
  String get back => 'பின்';

  @override
  String get next => 'அடுத்தது';

  @override
  String get cancel => 'ரத்துசெய்';

  @override
  String get confirm => 'உறுதிப்படுத்தவும்';

  @override
  String get finish => 'முடிக்க';

  @override
  String get login => 'புகுபதிகை';

  @override
  String get logout => 'விடுபதிகை';

  @override
  String get skip => 'தவிர்';

  @override
  String get yes => 'ஆம்';

  @override
  String get no => 'இல்லை';

  @override
  String days(num day) {
    String _temp0 = intl.Intl.pluralLogic(
      day,
      locale: localeName,
      other: '$day நாட்கள்',
      one: '1 நாள்',
    );
    return '$_temp0';
  }

  @override
  String hours(num hour) {
    String _temp0 = intl.Intl.pluralLogic(
      hour,
      locale: localeName,
      other: '$hour மணிநேரங்கள்',
      one: '1 மணிநேரம்',
    );
    return '$_temp0';
  }

  @override
  String minutes(num minute) {
    String _temp0 = intl.Intl.pluralLogic(
      minute,
      locale: localeName,
      other: '$minute நிமையங்கள்',
      one: '1 நிமையம்',
    );
    return '$_temp0';
  }

  @override
  String seconds(num second) {
    String _temp0 = intl.Intl.pluralLogic(
      second,
      locale: localeName,
      other: '$second விநாடிகள்',
      one: '1 விநாடி',
    );
    return '$_temp0';
  }

  @override
  String get and => 'மற்றும்';

  @override
  String get more => 'மேலும்';

  @override
  String get element => 'தனிமம்';

  @override
  String get durationInputDaysLabel => 'நாட்கள்';

  @override
  String get durationInputHoursLabel => 'மணி';

  @override
  String get durationInputMinutesLabel => 'நிமிடங்கள்';

  @override
  String get durationInputSecondsLabel => 'நொடிகள்';

  @override
  String get osmAttributionText => 'தரவு © OpenStreetMap பங்களிப்பாளர்கள்';

  @override
  String changesetWithStopNameText(String elements, String stopArea) {
    return 'நிறுத்தப் பகுதியில் $elements இல் விவரங்களைச் சேர்க்கப்பட்டது $stopArea.';
  }

  @override
  String changesetWithoutStopNameText(String elements) {
    return 'நிறுத்தப் பகுதியில் $elements இல் விவரங்கள் சேர்க்கப்பட்டன.';
  }

  @override
  String get mapFeatureBusStop => 'Bus நிறுத்து';

  @override
  String get mapFeatureTramStop => 'Tram நிறுத்து';

  @override
  String get mapFeatureTrainPlatform => 'ரயில் தளம்';

  @override
  String get mapFeaturePlatform => 'Platform';

  @override
  String get mapFeatureStopPole => 'நிறுத்து முனைமம்';

  @override
  String get mapFeatureStation => 'நிலையம்';

  @override
  String get mapFeatureTicketSalesPoint => 'Ticket sales புள்ளியம்';

  @override
  String get mapFeatureInformationPoint => 'செய்தி புள்ளியம்';

  @override
  String get mapFeatureStationMap => 'நிலையம்/நிறுத்தம் வரைபடம்';

  @override
  String get mapFeatureTicketMachine => 'சீட்டு இயந்திரம்';

  @override
  String get mapFeatureParkingSpot => 'நிறுத்தும் இடம்';

  @override
  String get mapFeatureTaxiStand => 'டாக்சி நிறுத்தும் இடம்';

  @override
  String get mapFeatureToilets => 'கழிப்பறைகள்';

  @override
  String get mapFeatureLuggageLockers => 'லக்கேஜ் லாக்கர்கள்';

  @override
  String get mapFeatureLuggageTransport => 'சாமான்கள் போக்குவரத்து';

  @override
  String get mapFeatureInformationTerminal => 'செய்தி முனையத்தில்';

  @override
  String get mapFeatureInformationCallPoint => 'செய்தி நெடுவரிசை';

  @override
  String get mapFeatureHelpPoint => 'உதவி புள்ளியம்';

  @override
  String get mapFeatureEmergencyCallPoint => 'Emergency call புள்ளியம்';

  @override
  String get mapFeatureEntrance => 'நுழைவு';

  @override
  String get mapFeatureFootpath => 'நடைபாதை';

  @override
  String get mapFeatureCyclePath => 'Cycle பாதை';

  @override
  String get mapFeatureFootAndCyclePath => 'Foot & cycle பாதை';

  @override
  String get mapFeatureStairs => 'படிக்கட்டுகள்';

  @override
  String get mapFeatureElevator => 'மின்தூக்கி';

  @override
  String get mapFeatureEscalator => 'மின்சறுக்கி';

  @override
  String get mapFeatureCycleBarrier => 'சுழற்சி தடை';

  @override
  String get mapFeatureCrossing => 'பாதை கடத்தல்';

  @override
  String get mapFeatureTramCrossing => 'மின்வண்டி கடத்தல்';

  @override
  String get mapFeatureRailroadCrossing => 'தொடர்வண்டிபாதை கடத்தல்';

  @override
  String get mapFeatureFootwayCrossing => 'நடைபாதை கடத்தல்';

  @override
  String get mapFeatureCyclewayCrossing => 'மிதிவண்டி கடத்தல்';

  @override
  String get mapFeatureCurb => 'கடிவாளம்';

  @override
  String get mapFeaturePedestrianLights => 'பாதசாரி விளக்குகள்';

  @override
  String mapFeatureBusPlatformNumber(String number) {
    return 'Platform: $number';
  }

  @override
  String mapFeatureTrainPlatformNumber(String number) {
    return 'Platform: $number';
  }

  @override
  String get semanticsLoginHint =>
      'உங்கள் மாற்றங்களை பதிவேற்ற உங்கள் openstreetmap கணக்கில் உள்நுழைக.';

  @override
  String get semanticsFlutterMap => 'வரைபடத் திரை';

  @override
  String get semanticsReturnToMap => 'கேள்வித்தாளை மூடி வரைபடத்திற்குத் திரும்புக';

  @override
  String semanticsDotsIndicator(num number) {
    return 'பக்கம் $number';
  }

  @override
  String semanticsPageIndicators(num number) {
    return '$number அறிமுக பக்கங்கள் உள்ளன, நீங்கள் கேட்க விரும்பும் ஒன்றைத் தேர்ந்தெடுக்கவும்.';
  }

  @override
  String semanticsIntroductionPage(num number, num count) {
    return 'அறிமுகம் பக்கம் $count இல் $number';
  }

  @override
  String get semanticsSlogan => 'முழக்கம்';

  @override
  String get semanticsMFundImage => 'Mfund ஆல் நிதியளிக்கப்பட்டது';

  @override
  String get semanticsFederalMinistryImage =>
      'நடு போக்குவரத்து மற்றும் டிசிட்டல் உள்கட்டமைப்பு அமைச்சகம் நிதியளித்தது';

  @override
  String get semanticsSettingsDialogBox =>
      'உங்களுக்கு விருப்பமான பயன்பாட்டு கருப்பொருள் தேர்வு செய்யவும்';

  @override
  String get semanticsNavigationMenu => 'வழிசெலுத்தல் பட்டியல்';

  @override
  String get semanticsResetRotationButton => 'வரைபட சுழற்சியை வடக்கே மீட்டமைக்கவும்.';

  @override
  String get semanticsCurrentLocationButton => 'தற்போதைய இடத்திற்கு வரைபடத்தை அமைக்கவும்.';

  @override
  String get semanticsZoomInButton => 'வரைபடத்தில் பெரிதாக்கு';

  @override
  String get semanticsZoomOutButton => 'வரைபடத்தை பெரிதாக்கவும்';

  @override
  String get semanticsQuestionSentence => 'கேள்வி: ';

  @override
  String get semanticsUploadQuestionsButton => 'பதில்களைப் பதிவேற்றவும்';

  @override
  String get semanticsBackQuestionButton => 'முந்தைய கேள்விக்குத் திரும்பு.';

  @override
  String get semanticsNextQuestionButton => 'அடுத்த கேள்வி';

  @override
  String get semanticsSkipQuestionButton => 'கேள்வியைத் தவிர்க்கவும்';

  @override
  String get semanticsFinishQuestionnaireButton => 'வினாத்தாளை முடிக்கவும்';

  @override
  String get semanticsSummary => 'சுருக்கம்';

  @override
  String get semanticsCloseNavigationMenuButton => 'வழிசெலுத்தல் மெனுவை மூடு.';

  @override
  String get semanticsCloseQuestionnaireAnnounce => 'கேள்வித்தாள் மூடப்பட்டுள்ளது';

  @override
  String get semanticsOpenQuestionnaireAnnounce => 'கேள்வித்தாள் திறந்திருக்கும்';

  @override
  String semanticsUser(Object username) {
    return 'பயனர் $username திறந்த உலாவி சுயவிவரத்திற்கு செயல்படுத்தவும்';
  }

  @override
  String get semanticsLogout => 'உங்கள் பயனர் கணக்கிலிருந்து வெளியேறவும்';

  @override
  String get semanticsClearField => 'தெளிவான புலம்';

  @override
  String get semanticsDurationAnswerReset => 'காலத்தை மீட்டமை';

  @override
  String get semanticsDurationAnswerStartStopwatch => 'ச்டாப்ப்வாட்சைத் தொடங்குங்கள்';

  @override
  String get semanticsDurationAnswerStopStopwatch => 'ச்டாப்வாட்சை நிறுத்து';

  @override
  String get semanticsReviewQuestion => 'கேள்விக்குத் திரும்பவும்';

  @override
  String get semanticsNextStepOnboarding => 'அடுத்த பக்கம்';

  @override
  String get semanticsFinishOnboarding => 'அறிமுகத்தை முடிக்கவும்';

  @override
  String get semanticsAttribution => 'பண்புக்கூறு';
}
