// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for Russian (`ru`).
class AppLocalizationsRu extends AppLocalizations {
  AppLocalizationsRu([String locale = 'ru']) : super(locale);

  @override
  String get aboutTitle => 'О приложении';

  @override
  String get aboutSlogan => 'Следующая остановка — Доступность';

  @override
  String get aboutVersionLabel => 'Версия';

  @override
  String get aboutAuthorsLabel => 'Авторы';

  @override
  String aboutAuthorsDescription(String appName) {
    return 'Внёсшие вклад в разработку $appName';
  }

  @override
  String get aboutPrivacyPolicyLabel => 'Политика конфиденциальности';

  @override
  String get aboutIdeaLabel => 'Авторы идеи';

  @override
  String get aboutIdeaDescription =>
      'Хемницкий технологический университет\nПрофессорское проектирование схем и систем';

  @override
  String get aboutLicenseLabel => 'Лицензия';

  @override
  String get aboutLicensePackageLabel => 'Лицензии используемых компонентов';

  @override
  String get aboutSourceCodeLabel => 'Исходный код';

  @override
  String get aboutStatisticLabel => 'Statistic';

  @override
  String get helpTitle => 'Помощь';

  @override
  String get helpOnboardingLabel => 'Посмотреть онбординг ещё раз';

  @override
  String get helpReportErrorLabel => 'Сообщить об ошибке';

  @override
  String get helpImproveTranslationLabel => 'Помочь перевести приложение';

  @override
  String get onboardingGreetingTitle => 'Привет!';

  @override
  String get onboardingGreetingDescription =>
      'Мы рады, что вы здесь и хотите внести вклад в улучшении общественного транспорта.';

  @override
  String get onboardingGreetingButton => 'Вот как это работает';

  @override
  String get onboardingSurveyingTitle => 'Осмотритесь';

  @override
  String get onboardingSurveyingDescription =>
      'Подойдите к ближайшей остановке, чтобы оценить её состояние.';

  @override
  String get onboardingSurveyingButton => 'Я сделаю это';

  @override
  String get onboardingAnsweringTitle => 'Теперь ваш ход';

  @override
  String get onboardingAnsweringDescription =>
      'Чтобы собрать данные, выберите маркер на карте и отвечайте на вопросы.';

  @override
  String get onboardingAnsweringButton => 'Ладно, понятно';

  @override
  String get onboardingContributingTitle => 'Делиться — значит заботиться';

  @override
  String get onboardingContributingDescription =>
      'Ваши ответы будут загружены в OpenStreetMap, чтобы их мог увидеть весь мир.';

  @override
  String get onboardingContributingButton => 'Начнём же';

  @override
  String get privacyPolicyTitle => 'Политика конфиденциальности';

  @override
  String get settingsTitle => 'Настройки';

  @override
  String get settingsProfessionalQuestionsLabel => 'Отображать сложные вопросы';

  @override
  String get settingsProfessionalQuestionsDescription =>
      'Из соображений безопасности предназначено только для профессионалов';

  @override
  String get settingsThemeLabel => 'Цветовая схема приложения';

  @override
  String get settingsThemeDialogTitle => 'Выбрать тему';

  @override
  String get settingsThemeOptionSystem => 'Как в системе';

  @override
  String get settingsThemeOptionLight => 'Светлая';

  @override
  String get settingsThemeOptionDark => 'Тёмная';

  @override
  String get logoutDialogTitle => 'Выйти из OSM?';

  @override
  String get logoutDialogDescription =>
      'После выхода из аккаунта, вы не сможете загружать изменения в OpenStreetMap.';

  @override
  String get loginHint => 'Войти в учётную запись OpenStreetMap, чтобы загрузить изменения.';

  @override
  String get numberInputPlaceholder => 'Вводите здесь…';

  @override
  String get numberInputFallbackName => 'Значение';

  @override
  String get numberInputValidationError => 'Неверный номер';

  @override
  String numberInputValidationErrorMax(String nameString, num max, String unit) {
    return '$nameString должен быть меньше $max$unit.';
  }

  @override
  String numberInputValidationErrorMin(String nameString, num min, String unit) {
    return '$nameString должен быть больше $min $unit.';
  }

  @override
  String get stringInputPlaceholder => 'Вводите здесь…';

  @override
  String get stringInputValidationErrorMin => 'Введённое слишком коротко';

  @override
  String changesetCommentMessage(String mapFeaturesString, String stopsString) {
    return 'Добавлены сведения в $mapFeaturesString про остановку $stopsString.';
  }

  @override
  String get changesetCommentConjunctionString => 'и';

  @override
  String get uploadMessageSuccess => 'Правки успешно отправлены.';

  @override
  String get uploadMessageServerConnectionError => 'Ошибка: Нет связи с сервером OSM.';

  @override
  String get uploadMessageUnknownConnectionError => 'Неизвестная ошибка во время передачи.';

  @override
  String get queryMessageServerUnavailableError =>
      'Сервер недоступен или перегружен. Попробуйте позже.';

  @override
  String get queryMessageTooManyRequestsError => 'Слишком много запросов к серверу.';

  @override
  String get queryMessageConnectionTimeoutError => 'Ошибка: таймаут ответа сервера.';

  @override
  String get queryMessageReceiveTimeoutError => 'Ошибка: таймаут получения данных.';

  @override
  String get queryMessageUnknownServerCommunicationError =>
      'Неизвестная ошибка при общении с сервером.';

  @override
  String get queryMessageUnknownError => 'Неизвестная ошибка.';

  @override
  String questionnaireSummaryDedicatedMessage(String userName) {
    return 'Спасибо, $userName, за ваши ответы.\nПожалуйста, проверьте их перед отправкой.';
  }

  @override
  String get questionnaireSummaryUndedicatedMessage =>
      'Спасибо за ваши ответы.\nПожалуйста, проверьте их перед отправкой.';

  @override
  String get back => 'Назад';

  @override
  String get next => 'Вперед';

  @override
  String get cancel => 'Отмена';

  @override
  String get confirm => 'Подтвердить';

  @override
  String get finish => 'Завершить';

  @override
  String get login => 'Войти';

  @override
  String get logout => 'Выйти';

  @override
  String get skip => 'Пропустить';

  @override
  String get yes => 'Да';

  @override
  String get no => 'Нет';

  @override
  String days(num day) {
    String _temp0 = intl.Intl.pluralLogic(
      day,
      locale: localeName,
      other: '$day дней',
      one: '1 день',
    );
    return '$_temp0';
  }

  @override
  String hours(num hour) {
    String _temp0 = intl.Intl.pluralLogic(
      hour,
      locale: localeName,
      other: '$hour часов',
      one: '1 час',
    );
    return '$_temp0';
  }

  @override
  String minutes(num minute) {
    String _temp0 = intl.Intl.pluralLogic(
      minute,
      locale: localeName,
      other: '$minute минуты',
      one: '1 минута',
    );
    return '$_temp0';
  }

  @override
  String seconds(num second) {
    String _temp0 = intl.Intl.pluralLogic(
      second,
      locale: localeName,
      other: '$second секунд',
      one: '1 секунда',
    );
    return '$_temp0';
  }

  @override
  String get and => 'и';

  @override
  String get more => 'больше';

  @override
  String get element => 'элемент';

  @override
  String get durationInputDaysLabel => 'дней';

  @override
  String get durationInputHoursLabel => 'часов';

  @override
  String get durationInputMinutesLabel => 'минут';

  @override
  String get durationInputSecondsLabel => 'секунд';

  @override
  String get osmAttributionText => 'Данные участников © OpenStreetMap';

  @override
  String changesetWithStopNameText(String elements, String stopArea) {
    return 'Добавлены подробности к $elements в остановочной зоне $stopArea.';
  }

  @override
  String changesetWithoutStopNameText(String elements) {
    return 'Добавлены подробности к $elements в остановочной зоне.';
  }

  @override
  String get mapFeatureBusStop => 'Автобусная остановка';

  @override
  String get mapFeatureTramStop => 'Трамвайная остановка';

  @override
  String get mapFeatureTrainPlatform => 'Платформа поезда';

  @override
  String get mapFeaturePlatform => 'Платформа';

  @override
  String get mapFeatureStopPole => 'Знак стоп';

  @override
  String get mapFeatureStation => 'Станция';

  @override
  String get mapFeatureTicketSalesPoint => 'Место продажи билетов';

  @override
  String get mapFeatureInformationPoint => 'Информационный пункт';

  @override
  String get mapFeatureStationMap => 'Карта станций и остановок';

  @override
  String get mapFeatureTicketMachine => 'Автомат продажи билетов';

  @override
  String get mapFeatureParkingSpot => 'Парковочное место';

  @override
  String get mapFeatureTaxiStand => 'Стоянка такси';

  @override
  String get mapFeatureToilets => 'Туалеты';

  @override
  String get mapFeatureLuggageLockers => 'Камеры хранения';

  @override
  String get mapFeatureLuggageTransport => 'Перевоз багажа';

  @override
  String get mapFeatureInformationTerminal => 'Информационный треминал';

  @override
  String get mapFeatureInformationCallPoint => 'Стойка информации';

  @override
  String get mapFeatureHelpPoint => 'Пункт помощи';

  @override
  String get mapFeatureEmergencyCallPoint => 'Пункт экстренного вызова';

  @override
  String get mapFeatureEntrance => 'Вход';

  @override
  String get mapFeatureFootpath => 'Пешеходная дорожка';

  @override
  String get mapFeatureCyclePath => 'Велосипедная дорожка';

  @override
  String get mapFeatureFootAndCyclePath => 'Пешая и велосипедная дорожка';

  @override
  String get mapFeatureStairs => 'Лестницы';

  @override
  String get mapFeatureElevator => 'Лифт';

  @override
  String get mapFeatureEscalator => 'Эскалатор';

  @override
  String get mapFeatureCycleBarrier => 'Велосипедный барьер';

  @override
  String get mapFeatureCrossing => 'Переход';

  @override
  String get mapFeatureTramCrossing => 'Трамвайный переезд';

  @override
  String get mapFeatureRailroadCrossing => 'Железнодорожный переход';

  @override
  String get mapFeatureFootwayCrossing => 'Пешеходный переход';

  @override
  String get mapFeatureCyclewayCrossing => 'Велосипедный переход';

  @override
  String get mapFeatureCurb => 'Бордюр';

  @override
  String get mapFeaturePedestrianLights => 'Пешеходный светофор';

  @override
  String mapFeatureBusPlatformNumber(String number) {
    return 'Платформа: $number';
  }

  @override
  String mapFeatureTrainPlatformNumber(String number) {
    return 'Платформа: $number';
  }

  @override
  String get semanticsLoginHint => 'Войти в учётную запись OpenStreetMap, чтобы залить изменения.';

  @override
  String get semanticsFlutterMap => 'Экран карты';

  @override
  String get semanticsReturnToMap => 'Закрыть опросник и вернуться на карту';

  @override
  String semanticsDotsIndicator(num number) {
    return 'Страница $number';
  }

  @override
  String semanticsPageIndicators(num number) {
    return 'Есть $number страницы введения, выберите ту, которую вы хотели бы услышать.';
  }

  @override
  String semanticsIntroductionPage(num number, num count) {
    return 'Страница введения $number из $count';
  }

  @override
  String get semanticsSlogan => 'Призыв';

  @override
  String get semanticsMFundImage => 'Финансируется немецким mFUND';

  @override
  String get semanticsFederalMinistryImage =>
      'Финансируется министерством транспорта и цифровой инфраструктуры Германии';

  @override
  String get semanticsSettingsDialogBox => 'Выберите тему оформления';

  @override
  String get semanticsNavigationMenu => 'Меню навигации';

  @override
  String get semanticsResetRotationButton => 'Сбросить поворот карты к северу.';

  @override
  String get semanticsCurrentLocationButton => 'Настройте карту на текущее местоположение.';

  @override
  String get semanticsZoomInButton => 'Приближение в карте';

  @override
  String get semanticsZoomOutButton => 'Отдаление в карте';

  @override
  String get semanticsQuestionSentence => 'Вопрос: ';

  @override
  String get semanticsUploadQuestionsButton => 'Загрузка ответов';

  @override
  String get semanticsBackQuestionButton => 'Вернуться к предыдущему вопросу.';

  @override
  String get semanticsNextQuestionButton => 'Следующий вопрос';

  @override
  String get semanticsSkipQuestionButton => 'Пропустить вопрос';

  @override
  String get semanticsFinishQuestionnaireButton => 'Закончить опросник';

  @override
  String get semanticsSummary => 'Вкратце';

  @override
  String get semanticsCloseNavigationMenuButton => 'Закрыть меню навигации.';

  @override
  String get semanticsCloseQuestionnaireAnnounce => 'Вопросник закрыт';

  @override
  String get semanticsOpenQuestionnaireAnnounce => 'Вопросник открыт';

  @override
  String semanticsUser(Object username) {
    return 'Пользователь $username активируется для открытия профиля обозревателя';
  }

  @override
  String get semanticsLogout => 'Выйти из учётной записи пользователя';

  @override
  String get semanticsClearField => 'Очистить поле';

  @override
  String get semanticsDurationAnswerReset => 'Сбросить продолжительность';

  @override
  String get semanticsDurationAnswerStartStopwatch => 'Начать стоп-часы';

  @override
  String get semanticsDurationAnswerStopStopwatch => 'Остановить стоп-часы';

  @override
  String get semanticsReviewQuestion => 'Активировать чтобы вернуться к вопросу';

  @override
  String get semanticsNextStepOnboarding => 'Следующая страница';

  @override
  String get semanticsFinishOnboarding => 'Закончить введение';

  @override
  String get semanticsAttribution => 'Атрибуция';
}
