/// Country codes (ISO 3166-1) to official language codes (ISO 639-1) mapping.
///
/// Created from the following SPARQL wikidata query:
/// ```
/// SELECT DISTINCT ?ISO_Country (GROUP_CONCAT(?ISO_Language) as ?ISO_Languages) WHERE {
///   SERVICE wikibase:label { bd:serviceParam wikibase:language "en". }
///
///   ?item wdt:P31 wd:Q6256;
///
///   { ?item wdt:P297 ?ISO_Country. }
///   { ?item wdt:P37 ?officalLanguage. }
///   { ?officalLanguage wdt:P218 ?ISO_Language. }
/// }
/// GROUP BY ?ISO_Country
/// ORDER BY (?ISO_Country)
/// ```
library;

const countryToLanguageMapping = {
  'AD': {'ca'},
  'AE': {'ar'},
  'AF': {'uz', 'tk', 'ps', 'ar'},
  'AG': {'en'},
  'AL': {'sq'},
  'AM': {'hy'},
  'AO': {'pt'},
  'AR': {'es'},
  'AT': {'de'},
  'AW': {'nl'},
  'AZ': {'az'},
  'BD': {'bn'},
  'BE': {'fr', 'nl', 'de'},
  'BF': {'fr'},
  'BG': {'bg'},
  'BH': {'ar'},
  'BI': {'fr', 'en', 'rn'},
  'BJ': {'fr'},
  'BN': {'en', 'ms'},
  'BO': {'qu', 'es', 'ay', 'gn'},
  'BR': {'pt'},
  'BS': {'en'},
  'BT': {'dz'},
  'BW': {'en'},
  'BY': {'ru', 'be'},
  'CA': {'fr', 'en'},
  'CD': {'fr'},
  'CF': {'fr', 'sg'},
  'CG': {'fr'},
  'CH': {'fr', 'de', 'it', 'rm'},
  'CI': {'fr'},
  'CK': {'en'},
  'CL': {'es'},
  'CM': {'fr', 'en'},
  'CN': {'zh'},
  'CO': {'es'},
  'CR': {'es'},
  'CU': {'es'},
  'CV': {'pt'},
  'CY': {'tr', 'el'},
  'CZ': {'cs'},
  'DE': {'de'},
  'DJ': {'fr', 'ar'},
  'DK': {'da'},
  'DM': {'en'},
  'DO': {'es'},
  'DZ': {'ar'},
  'EC': {'es'},
  'EE': {'et'},
  'EG': {'ar'},
  'ER': {'en', 'ti', 'ar'},
  'ES': {'es'},
  'ET': {'am'},
  'FI': {'sv', 'fi'},
  'FJ': {'en', 'fj'},
  'FM': {'en'},
  'FR': {'fr'},
  'GA': {'fr'},
  'GB': {'en'},
  'GD': {'en'},
  'GH': {'en'},
  'GM': {'en'},
  'GN': {'fr'},
  'GR': {'el'},
  'GT': {'es'},
  'GW': {'pt'},
  'GY': {'en'},
  'HN': {'es'},
  'HR': {'hr'},
  'HT': {'fr', 'ht'},
  'HU': {'hu'},
  'ID': {'id', 'jv'},
  'IE': {'en', 'ga'},
  'IL': {'he'},
  'IN': {'hi', 'en'},
  'IQ': {'ku', 'ar'},
  'IR': {'fa'},
  'IS': {'is'},
  'IT': {'it'},
  'JM': {'en'},
  'JO': {'ar'},
  'JP': {'ja'},
  'KE': {'en', 'sw'},
  'KG': {'ru', 'ky'},
  'KH': {'km'},
  'KI': {'en'},
  'KM': {'fr', 'ar'},
  'KN': {'en'},
  'KP': {'ko'},
  'KR': {'ko'},
  'KZ': {'ru', 'kk'},
  'LA': {'lo'},
  'LB': {'ar'},
  'LC': {'en'},
  'LI': {'de'},
  'LK': {'ta', 'si'},
  'LR': {'en'},
  'LS': {'en', 'st'},
  'LT': {'lt'},
  'LV': {'lv'},
  'LY': {'ar'},
  'MA': {'ar'},
  'MG': {'fr', 'mg'},
  'MH': {'en', 'mh'},
  'ML': {'fr'},
  'MM': {'my'},
  'MN': {'mn'},
  'MP': {'en', 'ch'},
  'MR': {'ar'},
  'MT': {'en', 'mt'},
  'MV': {'dv'},
  'MW': {'en', 'ny'},
  'MX': {'es'},
  'MY': {'ms'},
  'MZ': {'pt'},
  'NA': {'en'},
  'NE': {'fr'},
  'NG': {'en'},
  'NI': {'es'},
  'NL': {'nl'},
  'NO': {'no', 'nn', 'nb'},
  'NP': {'ne'},
  'NR': {'en', 'na'},
  'NU': {'en'},
  'NZ': {'en', 'mi'},
  'OM': {'ar'},
  'PE': {'qu', 'es', 'ay'},
  'PG': {'en', 'ho'},
  'PH': {'en'},
  'PK': {'ur', 'en'},
  'PL': {'pl', 'be'},
  'PT': {'pt'},
  'PW': {'en', 'ja'},
  'PY': {'es', 'gn'},
  'QA': {'ar'},
  'RO': {'ro'},
  'RU': {'ru'},
  'RW': {'fr', 'en', 'sw', 'rw'},
  'SA': {'ar'},
  'SB': {'en'},
  'SC': {'fr', 'en'},
  'SD': {'en', 'ar'},
  'SE': {'sv'},
  'SG': {'ta', 'en', 'ms'},
  'SI': {'sl'},
  'SK': {'sk'},
  'SL': {'en'},
  'SN': {'fr', 'wo'},
  'SO': {'so', 'ar'},
  'SS': {'en', 'ar'},
  'ST': {'pt'},
  'SV': {'es'},
  'SX': {'nl', 'en'},
  'SY': {'ar'},
  'TD': {'fr', 'ar'},
  'TG': {'fr'},
  'TH': {'th'},
  'TJ': {'ru', 'tg'},
  'TL': {'pt'},
  'TM': {'tk'},
  'TN': {'ar'},
  'TR': {'tr'},
  'TT': {'en'},
  'TV': {'en'},
  'TZ': {'en', 'sw'},
  'UG': {'en', 'sw'},
  'US': {'en'},
  'UY': {'es'},
  'UZ': {'uz'},
  'VC': {'en'},
  'VE': {'es'},
  'VN': {'vi'},
  'VU': {'fr', 'en', 'bi'},
  'WS': {'en', 'sm'},
  'YE': {'ar'},
  'ZA': {'en', 'zu', 've', 'ss', 'tn', 'ts', 'st', 'nr', 'xh', 'af'},
  'ZM': {'en'},
  'ZW': {'en', 've', 'ny', 'sn', 'tn', 'ts', 'st', 'nd', 'xh'},
};
