![OpenStop](fastlane/metadata/android/en-US/images/featureGraphic.png)

The goal of this app is to collect accessibility data for public transport stops in [OpenStreetMap](https://www.openstreetmap.org) so that everyone can benefit from it.
Due to the huge amount of public transport stops out there we want to encourage all citizen (experienced OSM users and newcomers) to help gathering this data. That's why we are developing this app that allows collecting the data in an easy, accessible and safe manner by asking simple questions. For deeper insight read  the [working principle](/docs/WORKING_PRINCIPLE.md) of the app.

The data shall be the foundation for better routing especially for impaired people and lead to a renovation of non accessible stops, as well as many other things we ourselves can't even imagine right now.

Thanks and happy mapping!

## Download
[<img src="https://github.com/OPENER-next/OpenStop-website/blob/main/img/badges/Google_Play_Store_Badge_EN.svg"
    alt="Get it on Google Play"
    height="50">](https://play.google.com/store/apps/details?id=de.tu_chemnitz.etit.sse.openstop)
[<img src="https://github.com/OPENER-next/OpenStop-website/blob/main/img/badges/App_Store_Badge_EN.svg"
    alt="Download on the App Store"
    height="50">](https://apps.apple.com/app/id6740262037)
[<img src="https://openstop.app/img/badges/F-Droid_Badge_EN.svg"
    alt="Get it on F-Droid"
    height="50">](https://f-droid.org/packages/de.tu_chemnitz.etit.sse.openstop/)

## Screenshots
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/screenshot01.png" alt="Screenshot with map overview" width=150> <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/screenshot02.png" alt="Screenshot with visualized POI" width=150> <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/screenshot03.png" alt="Screenshot with multiple choice question dialog" width=150> <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/screenshot04.png" alt="Screenshot with bool question dialog and extended info box" width=150> <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/screenshot05.png" alt="Screenshot with summary and upload dialog" width=150>

## Contributing
We are always happy, if you not only want to help us mapping, but also want to directly participate in the project.

You can either open issues for enhancement suggestions and bug reports or help us developing the app further. A good starting point for the latter is to read the [build instructions](/docs/BUILD.md) for the app.

You can also help translating the app at [Weblate](https://hosted.weblate.org/projects/openstop/).

## License
This app is released under the terms of the [GNU General Public License v3.0 or later (GPL-3.0-or-later)](/LICENSE).

## Funding
<img src="assets/images/logos/BMDV_Fz_2021_Office_Farbe_de.png" alt="Logo of the German Federal Ministry of Digital Affairs and Transport" width=150> <img src="assets/images/logos/mFUND_Logo_sRGB.png" alt="Logo of the mFUND innovation initiative" width=150>

OpenStop is developed in the project [OPENER next](https://openernext.de), which is funded by the German Federal Ministry for Digital and Transport as part of the mFUND innovation initiative.

## Acknowledgement
Special thanks to Andy Allan ([@gravitystorm](https://github.com/gravitystorm/)) for granting us free access to the beautiful [Thunderforest](https://www.thunderforest.com/) map tiles.
