# Temaki icons for Flutter

This package brings the fabulous [Temaki icon set](https://github.com/ideditor/temaki) to Flutter.
The icons are particularly useful for representing different types of points of interest.

[![](https://cdn.jsdelivr.net/gh/ideditor/temaki@main/dist/temaki-view.svg)](https://opener-next.github.io/temaki_flutter/)

## Usage

Visit the [temaki icon overview](https://opener-next.github.io/temaki_flutter/) page to explore all available icons.

Use the `TemakiIcons` class to get the desired icon, like so:

```dart
TemakiIcons.ICON_NAME_HERE;
```

You can also visit the original documentation for a better overview: https://ideditor.github.io/temaki/docs/
Just keep in mind that it might show newly added icons that aren't yet available in the package. Also names are provided in *snake_case* there while this package uses *lowerCamelCase*.

## Working principle

The icon font and dart code of this package is generated by a GitHub workflow.
- icon font is generated using the npm package [Fantasticon](https://github.com/tancredi/fantasticon)
- dart code is generated via [build_runner](https://pub.dev/packages/build_runner) in conjunction with a custom `Builder` that can be found in `builder/icon_class_generator.dart`

In order to update the icons of this package to the latest Temaki release, first the `TEMAKI_VERSION_TAG` in the `generate_icon_font.yml` workflow needs to be updated. Then the workflow has to be manually executed via the [GitHub actions page](https://github.com/OPENER-next/temaki_flutter/actions/workflows/generate_icon_font.yml). This should automatically generate the new files and directly commit them to this repository. Done 🥳
