package de.tadris.flang_lib.opening

object DefaultOpeningDatabase {

    val db by lazy { OpeningDatabase(SOURCE) }

    private val SOURCE = """
|10|1.0|g2g3:-3.8731277;Uf3:-4.8620434;Hd3:-9.664993;d2c3:-9.9596615;g2h3:-11.737443;h2g3:-12.98402;d2e3:-14.6368265;e2e3:-16.267702;Hf3:-18.00847;Uh3:-19.218346;d2d3:-22.241972;h2h3:-22.822748;e2d3:-23.142643;f2g3:-23.161392;c2c3:-24.516369;f2e3:-25.783236;g2f3:-26.04178;f2f3:-27.280403;e2f3:-30.974983;c2d3:-32.28633;b2:-40.64412;b3:-46.176926
g2g3|9|0.5|b7b6:-3.8731277;e7f6:-0.11654902;uc6:-0.115733564;he6:5.0515148E-14;b7a6:2.5691874;d7e6:6.9696774;e7d6:6.978617;ua6:7.724256;b7c6:8.076301;hc6:8.355459;a7b6:8.912491;d7d6:8.97656;e7e6:14.732445;g7:16.06098;c7b6:16.62904;f7f6:18.692902;a7a6:19.265759;g6:19.299795;c7d6:22.833004;c7c6:24.312725;f7e6:25.44317;d7c6:26.120558
Uf3|9|0.5|b7a6:-4.8620434;b7b6:-2.2772298;uc6:-2.0418947;hc6:-1.3995932;b7c6:-0.96263814;a7b6:-0.9537269;e7f6:-0.8669111;ua6:-0.8318817;he6:-4.8849813E-14;a7a6:0.14059356;g7:1.0981296;d7d6:1.1640493;e7d6:1.6791453;c7c6:5.048183;d7e6:7.275338;e7e6:8.402581;c7b6:8.561499;d7c6:10.202919;f7f6:12.594123;g6:13.563041;c7d6:16.621805;f7e6:17.803526
Hd3|9|0.5|b7b6:-9.664993;b7a6:-6.132501;uc6:-2.9706268;a7b6:-1.5305796;e7f6:-1.4648505;he6:6.1062266E-15;b7c6:0.07947013;hc6:4.8240047;ua6:5.5016055;g7:6.3852124;a7a6:6.5581555;e7d6:6.6970353;f7f6:6.939573;d7d6:6.9536138;d7e6:6.9552383;c7b6:7.1897836;e7e6:7.940588;c7c6:13.66594;g6:13.732786;d7c6:15.94847;c7d6:16.909266;f7e6:17.508629
d2c3|9|0.49289137|b7b6:-9.9596615;uc6:-2.6802676;e7f6:-2.6753473;b7a6:-1.8387691;he6:-1.3139514;e7d6:-1.0669932;ua6:0.061029866;hc6:0.08237143;a7b6:0.110261664;c7b6:1.8242204;d7d6:2.711925;e7e6:3.8836482;d7e6:5.606163;d7c6:6.943367;b7c6:8.064074;a7a6:8.339371;c7d6:9.857021;c7c6:12.660996;f7f6:13.738694;f7e6:18.99466;g7:20.594767;g6:23.796577
g2h3|9|0.38146996|b7b6:-11.737443;e7f6:-10.215619;he6:-7.543201;b7a6:-4.91686;uc6:-4.7378883;a7b6:-3.641494;e7d6:-1.6292614;d7d6:0.0686788;b7c6:0.5543153;ua6:1.3552278;c7b6:2.3658674;d7e6:3.4084446;hc6:4.2428293;c7d6:6.1704006;a7a6:6.8103147;f7f6:7.3762054;e7e6:8.346213;c7c6:9.577983;d7c6:11.586898;f7e6:18.205748;g6:26.41129;g7:32.92345
h2g3|9|0.3292762|b7b6:-12.98402;b7a6:-11.07769;uc6:-4.6079707;e7f6:-2.2772298;g7:-2.271711;he6:-2.271711;b7c6:-1.4870629;hc6:-1.0555847;a7b6:-0.9537269;e7d6:1.8351483;ua6:2.5665128;d7d6:3.44196;a7a6:5.483065;c7b6:7.1897836;d7e6:7.275338;g6:8.834197;e7e6:11.648603;f7f6:12.137432;d7c6:12.479665;c7d6:12.954847;c7c6:13.66594;f7e6:17.52836
d2e3|9|0.2787146|b7b6:-14.6368265;b7a6:-9.738548;e7f6:-9.738548;uc6:-7.532523;he6:-7.0060105;b7c6:-5.1537485;ua6:-4.589077;e7d6:-0.856473;d7d6:-0.108759485;hc6:1.0774183;e7e6:1.2033651;c7b6:1.4983214;a7b6:1.5585308;d7e6:3.0228298;a7a6:4.818976;f7f6:8.346183;c7d6:8.660688;c7c6:10.181959;d7c6:11.680615;f7e6:14.431694;g7:14.992946;g6:21.503895
e2e3|9|0.24204138|uc6:-10.824921;he6:-9.646104;a7b6:-8.587503;b7c6:-6.330389;e7f6:-5.224353;b7a6:-5.1344986;hc6:-3.4417841;ua6:-3.3448966;e7d6:-1.0387968;d7e6:-0.9323335;a7a6:-0.76333433;c7b6:1.9306325;e7e6:2.287576;c7d6:4.190905;f7f6:5.641234;b7b6:6.495536;d7d6:6.92027;c7c6:9.618186;f7e6:10.305206;d7c6:10.350498;g7:12.230834;g6:15.003501
Hf3|8|0.21223398|he6:12.440006;b7b6:12.440006;b7c6:20.843489;a7b6:20.916214;b7a6:21.486853;e7d6:23.3548;uc6:23.54477;e7f6:24.13799;hc6:24.49184;d7d6:26.715816;ua6:27.639917;a7a6:27.760891;g7:28.956045;c7b6:30.901459;d7e6:31.226683;f7f6:31.800436;e7e6:33.022633;c7d6:33.413147;c7c6:36.627506;d7c6:37.79845;g6:40.759754;f7e6:43.670353
Uh3|8|0.19550064|b7b6:8.346159;he6:12.908913;a7b6:16.847006;uc6:16.956594;b7c6:19.490318;b7a6:19.650557;e7d6:23.004004;e7f6:23.477383;a7a6:25.041256;ua6:26.298098;d7d6:27.12145;d7e6:27.233187;e7e6:30.17077;c7b6:30.88525;g7:31.57056;hc6:33.542873;c7c6:34.090134;c7d6:34.62793;f7f6:35.287735;f7e6:37.498684;d7c6:39.384205;g6:60.8709
d2d3|8|0.16332002|b7b6:5.1514993;uc6:6.7087836;he6:6.718162;b7a6:11.69868;b7c6:14.970627;a7b6:15.192039;e7f6:15.261128;hc6:16.712654;a7a6:18.165106;d7d6:19.973206;c7b6:20.00651;e7d6:20.70812;ua6:20.834932;e7e6:21.116072;d7e6:21.455338;f7f6:28.298193;c7c6:30.16268;c7d6:31.344828;d7c6:33.259563;f7e6:39.292004;g7:43.95638;g6:53.139065
h2h3|8|0.15831453|b7b6:4.0967264;a7b6:10.583763;uc6:11.445766;he6:11.665448;e7f6:12.108779;b7c6:13.894865;b7a6:16.590895;hc6:17.966345;a7a6:19.408104;d7e6:20.49651;ua6:21.713568;d7d6:23.741837;e7d6:24.088078;c7b6:25.504461;g7:25.649578;c7d6:28.80851;e7e6:29.697405;d7c6:31.161192;f7f6:31.905525;c7c6:35.329594;f7e6:41.527687;g6:49.544186
e2d3|8|0.15568632|b7b6:6.3458505;e7f6:7.7914457;uc6:13.34298;b7a6:13.34991;a7b6:14.189826;he6:14.611997;hc6:16.60703;e7d6:17.700142;b7c6:18.384024;a7a6:19.901426;d7d6:21.47548;d7e6:22.445524;ua6:23.93612;e7e6:24.704182;c7b6:27.5846;c7c6:28.640272;d7c6:33.257637;c7d6:33.34958;f7f6:33.609573;f7e6:36.148464;g7:44.91366;g6:52.9084
f2g3|8|0.155535|b7b6:4.9655714;he6:6.9893126;uc6:9.007002;a7b6:12.125304;hc6:14.693972;e7f6:16.42072;ua6:17.960667;b7a6:18.422321;e7d6:19.590229;b7c6:20.57922;d7d6:23.134918;d7e6:24.049389;c7b6:24.084661;a7a6:25.000458;g7:27.198883;c7c6:27.239775;e7e6:27.83478;c7d6:28.041065;f7f6:31.151926;d7c6:33.50192;f7e6:34.309593;g6:46.378098
c2c3|8|0.14532602|b7b6:5.4528503;uc6:5.8042326;he6:6.3552923;e7f6:8.891776;b7a6:10.7752075;a7b6:13.04776;hc6:15.994426;b7c6:17.123095;a7a6:17.15629;d7d6:17.73361;ua6:19.520163;e7e6:21.601414;c7b6:21.841776;d7e6:22.919615;e7d6:23.340815;c7c6:28.454407;f7f6:29.478676;c7d6:30.057932;d7c6:32.518696;f7e6:33.159706;g7:42.08887;g6:49.222473
f2e3|8|0.1369231|b7b6:-2.1981094;he6:4.7648554;uc6:5.0600734;a7b6:9.833847;b7a6:10.757649;e7f6:12.520337;hc6:14.2647915;d7e6:14.256534;e7d6:16.178633;a7a6:17.569592;b7c6:18.381456;ua6:19.950583;d7d6:20.449446;e7e6:22.03875;c7b6:22.311514;c7d6:25.877104;f7f6:28.085321;c7c6:31.110771;f7e6:31.744905;d7c6:32.377964;g7:41.75232;g6:46.7337
g2f3|8|0.13532622|b7b6:11.638558;he6:21.09846;e7f6:21.149593;b7c6:21.683928;b7a6:22.188873;uc6:23.820349;a7b6:24.931408;hc6:24.931408;e7d6:27.62155;ua6:28.707876;a7a6:29.016493;d7d6:30.053667;c7b6:31.609085;d7e6:33.618385;c7c6:37.068344;d7c6:39.418514;c7d6:40.542263;e7e6:41.698265;f7f6:41.781136;f7e6:54.688286;g7:62.18678;g6:65.66921
f2f3|8|0.12816527|he6:0.3011937;b7b6:1.2069418;a7b6:6.9070973;uc6:8.09408;hc6:8.575863;b7c6:11.33348;e7f6:11.501468;b7a6:11.538425;e7d6:13.103574;ua6:14.102677;d7d6:17.375841;c7b6:17.609594;d7e6:17.836552;f7f6:20.71534;g7:20.933687;e7e6:22.46351;a7a6:22.641571;c7d6:24.403664;d7c6:27.04948;f7e6:27.731024;c7c6:30.018723;g6:39.17282
e2f3|8|0.11069353|b7b6:-1.730233;he6:2.5864608;a7b6:5.7441573;uc6:7.3079033;b7a6:7.5627007;hc6:8.442966;b7c6:10.030846;ua6:11.482385;e7d6:11.613996;d7d6:12.063052;e7f6:12.187173;a7a6:15.088391;e7e6:16.521933;d7e6:17.414454;c7d6:18.114124;c7b6:20.11417;g7:21.04341;d7c6:22.788155;f7f6:23.252438;c7c6:25.31942;g6:26.94164;f7e6:28.786217
c2d3|8|0.10558472|b7b6:-5.0372415;e7f6:-4.754199;uc6:-4.000444;he6:1.6798857;b7a6:4.685697;b7c6:7.374613;a7b6:8.007766;hc6:11.396043;d7d6:11.74522;e7e6:12.982851;a7a6:13.023141;c7b6:14.4189825;ua6:14.704828;d7e6:15.092354;e7d6:15.190394;c7c6:16.897696;f7f6:19.865858;c7d6:24.686777;d7c6:24.858658;g7:26.797457;f7e6:27.181051;g6:47.266106
b2|7|0.08158605|b7a6:-36.509315;he6:-26.880587;b7b6:-25.254566;e7f6:-24.690609;e7d6:-21.75808;b7c6:-18.445475;uc6:-14.230116;d7e6:-13.812056;d7d6:-12.573679;ua6:-12.153425;hc6:-9.806012;e7e6:-9.669916;f7f6:-9.398394;a7b6:-8.14059;a7a6:-6.3993077;d7c6:-5.934695;c7d6:-5.302348;c7b6:-5.248945;g7:-4.6334553;c7c6:-4.3769464;f7e6:-1.7456739;g6:0.4736362
b3|7|0.07091562|b7b6:-50.382183;b7a6:-43.89492;he6:-22.69603;e7f6:-22.69603;b7c6:-22.69603;e7d6:-20.779818;hc6:-19.83758;uc6:-17.309954;a7b6:-14.82849;ua6:-13.752476;c7c6:-13.686795;d7e6:-13.392078;a7a6:-13.326961;c7b6:-12.642089;d7d6:-12.573679;g7:-11.255136;f7f6:-9.398394;d7c6:-9.072966;g6:-7.8828373;e7e6:-6.803826;c7d6:-6.535903;f7e6:-4.089125
g2g3 b7b6|9|0.25|Kg2:27.28035;g4:26.15275;Hd3:23.41886;d2c3:23.035088;f5:21.39413;Uf3:20.715122;d2e3:20.157309;Ff3:14.706439;Hf3:13.822385;Uh3:11.084317;d2d3:9.797112;e2e3:8.0569105;b2:7.594082;c2c3:5.983689;e2d3:5.63171;Ug2:5.2204156;f2e3:4.523579;Fg2:3.8543181;f7:3.3636749;e2f3:-0.8284856;f2f3:-0.99182844;Ph3:-1.2335064;c2d3:-2.0776699;Hg2:-2.987377;g6:-15.0480385;b3:-15.469817
g2g3 e7f6|9|0.25|Kg2:30.397646;g4:30.253244;Hd3:28.47072;d2c3:24.582436;d2e3:23.683088;Uf3:18.786793;Hf3:17.16893;e2e3:16.81929;Ff3:15.633967;f2e3:14.008943;f7:13.437102;Ug2:12.815891;Uh3:11.97701;d2d3:11.897695;e2d3:9.943368;c2c3:9.080809;Fg2:3.8543181;Hg2:3.2603033;e2f3:2.8517375;f2f3:1.909983;b2:1.4435604;c2d3:1.0134113;b3:-0.21471652;Ph3:-1.2335064;f5:-3.4993708;g6:-10.555028
g2g3 uc6|9|0.25|g4:35.301277;Kg2:20.715122;Hf3:18.864946;Uf3:18.786793;d2c3:18.314497;Ff3:17.771118;f5:17.31391;Hd3:17.207642;Uh3:16.634253;b2:15.707534;d2e3:13.357265;Fg2:13.280147;Ug2:12.815891;f7:9.979862;c2c3:7.079456;d2d3:5.8985815;e2d3:5.2297792;b3:4.9645157;e2e3:3.7464232;f2e3:2.818764;f2f3:1.6972008;e2f3:0.48712438;Hg2:-2.3990493;c2d3:-2.807638;Ph3:-3.6729388;g6:-14.535366
g2g3 he6|9|0.25|Kg2:30.390306;g4:29.60698;d2c3:27.76352;d2e3:25.224045;f5:23.896837;Hd3:23.582582;f7:20.409805;Uf3:19.451164;Hf3:17.802513;Ff3:17.771118;Ug2:13.652775;d2d3:13.371781;e2e3:13.026571;Fg2:12.928583;Uh3:12.758767;e2d3:11.831877;f2e3:10.298662;c2c3:8.511301;Ph3:5.8386574;b2:4.6853414;e2f3:2.9967089;c2d3:0.6467071;b3:-0.6094864;f2f3:-0.99182844;Hg2:-2.987377;g6:-15.171104
g2g3 b7a6|9|0.23283555|Kg2:35.21232;g4:34.127254;Hd3:33.73536;d2c3:31.696386;Uf3:28.565062;d2e3:27.509974;f5:24.182106;Ff3:23.25129;Hf3:21.344255;Uh3:20.095634;e2e3:16.83096;Ug2:16.766418;e2d3:15.818316;f2e3:14.939546;c2c3:13.17674;Fg2:13.070343;Ph3:12.834191;d2d3:11.897695;f7:10.1013;f2f3:9.651324;c2d3:8.0881405;Hg2:5.7897882;e2f3:1.8725542;b2:-5.6026225;g6:-9.8475685;b3:-14.3344755
g2g3 d7e6|8|0.13834059|Hd3:11.226504;Ff3:6.8101616;Uf3:6.0836587;d2c3:5.606163;Kg2:5.079848;g4:4.8290887;d2e3:3.0228298;Uh3:1.7409858;Hf3:0.4515893;f2e3:-3.8413188;e2e3:-4.26841;Fg2:-4.2903285;e2d3:-4.7389455;d2d3:-5.250678;Ph3:-7.520207;f7:-8.130807;f2f3:-10.3684635;c2c3:-14.271722;e2f3:-14.363494;c2d3:-14.49083;Ug2:-15.216618;Hg2:-18.047432;b2:-22.116806;b3:-23.363047;g6:-25.066904;f5:-30.74888
g2g3 e7d6|8|0.13822661|g4:8.964462;Hd3:6.6970353;Uf3:0.45610297;d2e3:1.9428903E-14;d2c3:-1.0669932;f5:-2.3833628;Kg2:-3.0548623;e2e3:-4.4759846;f7:-6.322305;Ff3:-6.4921746;f2e3:-10.218151;d2d3:-12.533849;c2c3:-12.54236;Uh3:-15.343562;Hf3:-15.691014;e2d3:-16.776495;Ph3:-18.184433;Fg2:-18.837778;Ug2:-20.132547;f2f3:-23.279253;c2d3:-23.922813;e2f3:-26.488714;g6:-31.19266;Hg2:-31.474293;b2:-32.177494;b3:-35.275215
g2g3 ua6|8|0.12933952|Hd3:8.255305;g4:6.194237;Ff3:1.4766182;d2c3:1.251448;Kg2:0.77106035;d2e3:-0.1749577;Uf3:-0.48911878;b2:-6.077868;d2d3:-6.6127415;c2c3:-7.210553;Uh3:-7.6599874;e2d3:-8.114092;f7:-8.936683;e2e3:-9.302975;f2e3:-9.327415;Ph3:-11.784633;f2f3:-13.260956;Hf3:-13.445515;Fg2:-13.825944;c2d3:-16.006521;f5:-16.132019;Ug2:-16.836926;e2f3:-26.668903;Hg2:-28.171701;b3:-30.706669;g6:-31.828156
g2g3 b7c6|8|0.12552902|Hd3:11.559789;g4:8.076301;d2c3:5.144201;d2e3:0.08062978;Ff3:0.051995512;Uf3:-0.96263814;Kg2:-3.9691763;c2c3:-5.93101;e2e3:-6.330389;Hf3:-8.062572;f7:-10.774524;f2e3:-11.464918;Uh3:-12.03685;d2d3:-13.865633;Ph3:-14.186711;e2d3:-14.838887;f5:-15.554178;Hg2:-19.9544;Fg2:-20.016502;e2f3:-20.580698;f2f3:-21.8774;Ug2:-25.479858;c2d3:-26.903168;g6:-29.8303;b2:-37.655964;b3:-40.291
g2g3 hc6|8|0.12266339|g4:12.348237;Hd3:8.985555;d2c3:3.159367;Kg2:2.577391;d2e3:1.0774183;f7:0.4816832;Ff3:-0.58940303;Uf3:-2.0579193;e2e3:-3.7297373;f2e3:-5.4434886;Uh3:-6.6481314;c2c3:-7.93228;f5:-8.365739;Hf3:-8.94453;b2:-9.806012;d2d3:-10.380588;e2d3:-10.841402;Ph3:-11.318687;Fg2:-14.221121;Ug2:-15.161753;f2f3:-15.84944;e2f3:-19.215046;b3:-20.605812;Hg2:-20.747335;c2d3:-20.989693;g6:-33.26593
g2g3 a7b6|8|0.117319316|g4:8.912491;d2c3:4.7152495;d2e3:1.5585308;Hd3:-0.22400591;Uf3:-1.3995932;Ff3:-1.5155318;Kg2:-1.9280117;Hf3:-2.971164;b2:-7.6409063;e2d3:-8.608153;f5:-9.040854;Ph3:-10.319731;Uh3:-10.35659;d2d3:-10.365116;e2e3:-10.50051;c2d3:-12.404519;f2e3:-13.44142;c2c3:-13.490556;f7:-15.169407;f2f3:-15.84944;Fg2:-17.738895;b3:-19.030777;e2f3:-20.147495;Hg2:-24.835678;Ug2:-33.014713;g6:-35.477085
g2g3 d7d6|8|0.11673436|g4:8.97656;Hd3:6.9536138;d2e3:-0.006938776;Uf3:-0.48911878;Kg2:-0.7916074;Ff3:-1.870628;d2c3:-1.9757825;e2e3:-5.0113926;Uh3:-5.043583;f2e3:-5.718586;e2d3:-5.7324686;d2d3:-5.894117;f7:-8.098822;Ph3:-10.192001;f5:-11.010209;Fg2:-13.410516;Hf3:-15.268795;c2d3:-17.444609;c2c3:-17.879438;f2f3:-19.252287;b2:-21.913397;e2f3:-23.690134;Ug2:-23.768404;b3:-23.913494;Hg2:-28.171701;g6:-28.770123
Uf3 b7a6|9|0.25|g2g3:30.44682;g2h3:25.475368;Hd3:24.742546;d2c3:24.204626;h2g3:23.265411;e2e3:18.500387;d2d3:17.427052;d2e3:17.060156;h2h3:15.723106;b2:14.451244;e2d3:13.502545;f2e3:11.975543;b3:11.308177;g1:8.923427;c2c3:8.87115;f2g3:5.9442744;c2d3:-0.95960176
Uf3 b7b6|9|0.25|Hd3:26.530294;g2h3:22.706635;g2g3:22.108248;h2g3:20.988838;d2c3:19.073551;h2h3:17.872152;d2e3:16.550432;b2:13.865859;e2e3:13.767453;b3:11.060461;e2d3:8.724201;d2d3:7.855504;g1:4.8977585;f2e3:2.7010136;f2g3:2.541226;c2c3:0.9898521;c2d3:-1.7020792
Uf3 uc6|9|0.25|Hd3:20.550993;h2g3:19.267677;g2g3:18.786793;d2c3:16.935535;b2:15.707534;e2e3:14.429555;h2h3:13.710325;g2h3:13.097253;d2e3:12.305269;g1:7.527407;e2d3:7.38398;d2d3:6.861521;b3:4.9980226;c2c3:3.3414018;f2e3:2.7010136;f2g3:2.2943597;c2d3:-1.729802
Uf3 hc6|9|0.25|g2g3:32.45446;Hd3:29.253798;g2h3:23.469978;d2c3:22.34157;e2e3:21.579353;h2g3:20.205124;d2e3:19.734005;b2:17.49325;h2h3:15.520264;b3:12.401106;f2e3:11.975543;d2d3:11.808527;g1:11.694669;e2d3:11.017228;c2c3:9.383695;f2g3:6.9003825;c2d3:6.6059637
Uf3 b7c6|9|0.25|g2g3:28.686293;d2c3:20.800133;h2g3:19.366257;Hd3:18.453463;g2h3:18.409878;e2d3:17.924248;e2e3:13.818741;h2h3:12.80124;d2d3:12.22572;d2e3:8.373842;c2c3:4.916843;c2d3:3.2026274;g1:2.6802676;f2e3:2.0781486;f2g3:0.8039871;b3:0.38133046;b2:-8.743095
Uf3 a7b6|9|0.25|g2g3:23.192787;h2g3:21.47462;g2h3:21.103737;Hd3:20.913385;b2:19.245535;d2c3:17.626558;e2e3:16.369953;h2h3:14.946736;d2e3:12.305269;b3:10.370763;g1:9.59592;e2d3:7.38398;d2d3:6.728112;f2g3:6.4645214;f2e3:5.870359;c2c3:5.405476;c2d3:-1.729802
Uf3 e7f6|9|0.25|Hd3:22.156351;h2g3:20.790987;e2e3:19.289623;d2c3:19.289623;g2g3:18.969206;g2h3:16.206974;d2e3:15.564628;h2h3:14.52352;b2:13.900752;b3:10.370763;g1:9.59592;f2e3:8.327997;d2d3:7.414016;e2d3:7.38398;f2g3:6.064361;c2c3:5.2443604;c2d3:-1.517131
Uf3 ua6|9|0.25|Hd3:35.748783;g2g3:35.748783;h2g3:26.7188;g2h3:26.543573;e2e3:24.94189;d2c3:22.973644;h2h3:22.071028;d2e3:20.073679;b2:18.020267;e2d3:16.608854;f2e3:15.650929;b3:15.147973;g1:14.121584;d2d3:13.864623;c2c3:9.852286;f2g3:9.560678;c2d3:8.011144
Uf3 he6|9|0.25|g2g3:25.022558;g2h3:22.239023;d2c3:21.734936;Hd3:19.451164;h2g3:19.366257;e2e3:14.879279;d2e3:13.614517;h2h3:12.80124;e2d3:11.880405;b2:10.662413;b3:10.050693;g1:8.786181;c2c3:7.7656655;d2d3:7.096603;f2e3:2.0781486;f2g3:1.479158;c2d3:-1.729802
Uf3 a7a6|9|0.25|Hd3:27.63263;g2g3:27.63263;h2g3:27.438637;g2h3:25.306427;d2c3:25.259737;b2:21.42698;h2h3:19.756002;e2e3:18.243109;d2e3:17.966217;b3:17.899273;d2d3:15.999175;e2d3:14.566784;f2e3:14.290058;g1:13.28419;f2g3:12.96502;c2c3:10.2829895;c2d3:-1.2216101
Uf3 g7|9|0.25|g2g3:36.481556;Hd3:33.647675;d2c3:31.499638;g2h3:27.990793;e2e3:25.682535;d2e3:24.926466;h2g3:22.40878;b3:19.844818;h2h3:19.619364;b2:19.504288;d2d3:17.146923;c2c3:16.719818;g1:16.682587;f2g3:15.4767065;e2d3:14.3646;f2e3:13.521541;c2d3:4.7376704
Uf3 d7d6|9|0.2489175|g2g3:32.95146;Hd3:28.269062;h2g3:27.549168;g2h3:26.043602;h2h3:24.96082;d2c3:24.13182;e2e3:20.975319;b2:18.092648;e2d3:17.052158;d2d3:16.298971;b3:15.584619;d2e3:14.414703;g1:13.962703;f2e3:9.876413;c2d3:8.779465;c2c3:8.286809;f2g3:7.922425
Uf3 e7d6|9|0.22931612|Hd3:27.112444;e2e3:25.750984;g2g3:24.851862;d2c3:24.697353;h2g3:24.523184;g2h3:23.913647;h2h3:21.271332;b2:18.921206;d2e3:17.971788;b3:15.72361;f2e3:13.613143;e2d3:12.817675;g1:11.98404;d2d3:11.339866;f2g3:10.376066;c2c3:10.177797;c2d3:4.0448737
Uf3 c7c6|8|0.1513588|h2g3:13.66594;g2g3:12.41643;d2c3:8.539587;Hd3:3.7185824;d2e3:3.7033124;b2:1.3008959;e2d3:0.62725186;d2d3:-2.819502;e2e3:-3.1133533;g1:-4.1689887;c2c3:-5.5876713;f2e3:-6.506447;b3:-7.458108;f2g3:-8.228772;h2h3:-8.228772;c2d3:-8.756937;g2h3:-8.956199
Uf3 d7e6|8|0.12358514|h2g3:7.275338;g2g3:6.0836587;d2c3:2.8219898;Hd3:1.9677365;d2e3:-1.8700608;g2h3:-5.1189165;e2d3:-6.0552454;h2h3:-7.4263873;b2:-7.7621894;d2d3:-9.848937;e2e3:-10.651454;g1:-13.34298;f2e3:-15.286278;f2g3:-15.429389;c2c3:-18.801949;c2d3:-19.401125;b3:-33.16647
Uf3 e7e6|8|0.11308273|h2g3:13.42123;Hd3:13.42123;g2g3:12.055643;g2h3:0.9822353;d2c3:0.426389;e2e3:-1.4716524;h2h3:-1.516281;d2e3:-1.5828924;d2d3:-2.6913164;b2:-2.9045649;g1:-4.815035;b3:-5.0466533;f2e3:-5.2985387;f2g3:-6.436676;c2c3:-6.660307;e2d3:-7.164674;c2d3:-19.16473
Uf3 c7b6|8|0.11174398|Hd3:9.560065;g2g3:9.522841;h2g3:4.457244;d2c3:1.1777586;d2e3:-0.32784045;e2e3:-0.5101749;e2d3:-3.055739;b2:-3.8131247;d2d3:-5.2639265;f2e3:-6.9276776;g1:-7.9617534;f2g3:-9.027899;h2h3:-11.195917;c2d3:-12.016243;c2c3:-12.157593;g2h3:-13.101102;b3:-13.981639
Hd3 b7b6|9|0.25|g2g3:23.41886;g2h3:17.880999;g2f3:12.032084;h2g3:10.104651;d2c3:8.8451805;Uf3:8.639988;h2h3:3.6235354;e2e3:3.0038123;c2c3:1.3122917;d2e3:0.60826665;Uh3:0.46679485;e1:-0.19580527;f2e3:-0.44012907;f2g3:-4.8392653;f2f3:-7.4493017;e2f3:-8.954338;b2:-10.781347;b3:-24.537203
Hd3 b7a6|9|0.25|g2g3:33.73536;g2h3:26.946938;Uf3:21.419325;d2c3:19.356575;h2g3:18.77776;Uh3:14.338684;g2f3:13.41379;e2e3:13.200592;h2h3:11.54513;d2e3:10.808158;f2e3:10.755409;c2c3:10.192206;e1:9.930502;f2g3:6.9257913;f2f3:6.480807;e2f3:1.5639135;b2:-6.248308;b3:-14.3344755
Hd3 uc6|9|0.224069|g2f3:20.555702;d2c3:20.550993;Uf3:20.550993;e2e3:18.738485;h2g3:17.828123;g2g3:17.207642;g2h3:15.280125;Uh3:14.985088;h2h3:13.710325;b2:13.293329;c2c3:7.833055;f2f3:6.5924044;d2e3:5.7857623;e2f3:4.895;e1:3.794529;b3:3.739467;f2g3:3.164086;f2e3:2.7010136
Hd3 a7b6|8|0.18440174|g2g3:-0.22400591;g2f3:-1.0072193;Uf3:-1.5305796;h2g3:-1.5305796;g2h3:-10.526957;e2e3:-12.126792;b2:-12.740341;f2f3:-14.306519;d2c3:-14.37425;f2g3:-16.003273;h2h3:-16.536205;Uh3:-17.222418;d2e3:-18.008087;f2e3:-18.491388;e2f3:-18.681732;b3:-19.030777;c2c3:-19.037302;e1:-22.006014
Hd3 e7f6|8|0.18292364|g2g3:-1.4648505;Uf3:-3.6491194;h2g3:-7.602551;e2e3:-7.6303496;g2h3:-10.772219;g2f3:-12.930032;d2e3:-15.12888;f2e3:-15.354886;d2c3:-15.900696;Uh3:-16.211752;c2c3:-20.736454;h2h3:-21.59302;f2g3:-22.535706;e1:-23.12474;f2f3:-24.427467;e2f3:-26.237934;b2:-33.10038;b3:-44.424427
Hd3 he6|8|0.15519927|g2g3:6.1062266E-15;Uf3:-5.53581;h2g3:-6.5585523;g2h3:-10.199891;g2f3:-16.733276;e2e3:-16.920221;d2c3:-19.892483;Uh3:-20.737602;d2e3:-25.729233;f2g3:-26.254284;f2e3:-26.622269;c2c3:-27.224323;f2f3:-27.514982;h2h3:-27.74449;e1:-28.154173;e2f3:-32.323566;b2:-32.627594;b3:-43.32312
Hd3 b7c6|8|0.15393357|g2g3:12.107596;g2h3:0.6306727;Uf3:-0.96263814;g2f3:-1.0920172;h2g3:-3.6006467;e2e3:-6.330389;Uh3:-12.03685;f2e3:-12.497032;h2h3:-13.797542;d2e3:-14.732378;b2:-15.181572;d2c3:-16.163298;f2g3:-16.61856;f2f3:-16.61856;e1:-19.71431;e2f3:-20.580698;c2c3:-20.949177;b3:-45.474293
Hd3 hc6|8|0.10352683|g2g3:16.11629;g2h3:3.809949;h2g3:-1.5305796;Uf3:-1.5305796;e2e3:-1.5719064;d2e3:-1.5830396;g2f3:-4.7416487;Uh3:-5.4031835;d2c3:-5.7962008;f2e3:-6.801795;b2:-9.806012;c2c3:-10.463745;h2h3:-12.91664;e1:-12.932855;f2f3:-14.306519;f2g3:-15.907231;e2f3:-20.35676;b3:-20.70039
d2c3 b7b6|9|0.24644569|g2g3:27.29062;h2g3:17.560556;g2h3:17.284214;Uf3:15.746211;e2e3:12.665168;Uh3:12.597067;Hd3:10.483699;b2:9.216758;d4:7.9917073;h2h3:7.5909905;Hf3:7.2304616;g2f3:5.8017015;f2g3:1.4749782;Rd2:1.368891;e2d3:0.99541795;e2f3:0.08668595;Rd3:0.027029367;f2e3:-0.7627922;f2f3:-2.1646223;d7:-12.242422;Pd2:-12.374034;c2d3:-15.055547;d5:-16.791092;b3:-29.723383;d6:-31.456419
d2c3 uc6|8|0.2031315|Hd3:16.084995;Uf3:-2.6706681;g2f3:-2.6802676;g2g3:-2.785797;h2g3:-3.67499;Hf3:-9.872383;h2h3:-10.766724;Uh3:-12.604196;b2:-14.865651;e2e3:-16.267288;g2h3:-17.04564;f2f3:-20.765911;f2g3:-22.962978;f2e3:-23.780924;Rd3:-25.012136;e2d3:-25.149483;e2f3:-25.340887;Rd2:-25.407354;d4:-27.665096;b3:-32.270947;Pd2:-34.930305;d7:-37.242264;d5:-37.875137;c2d3:-40.369473;d6:-58.753784
d2c3 e7f6|8|0.20299429|g2g3:-2.813554;g2h3:-10.215619;h2g3:-10.46465;Hf3:-10.536174;Uf3:-10.632582;Hd3:-15.900696;Uh3:-16.174994;g2f3:-17.35479;h2h3:-18.224026;e2e3:-19.662334;f2e3:-20.825321;d4:-22.356398;e2d3:-22.569809;f2g3:-22.594591;Rd3:-23.909266;Rd2:-24.710085;f2f3:-26.066133;e2f3:-27.485756;c2d3:-37.742863;d7:-40.33204;Pd2:-43.756023;b3:-45.055637;b2:-45.327316;d5:-52.778698;d6:-59.013054
d2c3 b7a6|8|0.18208271|g2g3:-1.8387691;g2h3:-8.426627;Uf3:-9.103168;h2g3:-14.541475;Hd3:-14.541475;Hf3:-14.949253;h2h3:-15.736156;Uh3:-16.343199;g2f3:-16.655006;e2e3:-17.92936;f2e3:-21.178938;f2g3:-21.48432;Rd3:-21.48808;d4:-21.515064;e2d3:-22.522196;Rd2:-23.87066;e2f3:-27.132309;f2f3:-31.40632;d7:-31.785685;Pd2:-40.625248;c2d3:-42.56661;d5:-48.55935;d6:-54.551132;b2:-56.85648;b3:-60.845123
d2c3 he6|8|0.1710298|g2g3:-2.7566197;Uf3:-4.7804084;g2h3:-8.288816;h2g3:-9.082265;h2h3:-15.079994;Hf3:-18.00847;Uh3:-18.657167;g2f3:-19.177029;e2e3:-19.601574;f2g3:-19.733185;Hd3:-19.892483;Rd3:-23.287245;f2e3:-23.780924;e2d3:-24.141321;Rd2:-24.849195;f2f3:-30.520895;d4:-30.84495;e2f3:-30.900219;d7:-37.110672;c2d3:-37.47022;Pd2:-38.826054;b2:-45.801605;b3:-45.801605;d5:-52.73608;d6:-60.323647
d2c3 e7d6|8|0.16628015|g2g3:-1.0669932;Uf3:-5.1377;g2h3:-7.2002435;g2f3:-10.406763;h2g3:-10.427078;Hf3:-11.509814;Hd3:-11.99416;h2h3:-14.947967;e2e3:-15.42557;Uh3:-16.831501;d4:-17.703182;f2e3:-19.379255;f2g3:-23.03604;f2f3:-23.67739;e2d3:-24.244646;Rd3:-25.184702;e2f3:-26.64969;Rd2:-28.338108;d6:-28.343464;c2d3:-36.523388;Pd2:-37.77814;d5:-39.392174;b2:-42.813515;b3:-48.951355
d2c3 ua6|8|0.14756209|g2g3:0.08237143;Hd3:-5.855905;h2g3:-6.82084;g2f3:-7.9678345;g2h3:-9.48707;Uf3:-11.401694;Hf3:-13.273313;e2e3:-13.692964;Uh3:-13.819727;h2h3:-15.063204;Rd3:-15.383327;e2d3:-17.982002;d4:-19.254347;f2e3:-21.333967;Rd2:-22.446856;f2g3:-22.594591;b2:-23.553019;f2f3:-25.130703;e2f3:-26.995417;c2d3:-31.249329;Pd2:-33.668312;d7:-34.83183;b3:-41.45658;d5:-49.325264;d6:-55.652256
d2c3 hc6|8|0.14724849|g2g3:3.159367;Hd3:-5.7962008;g2h3:-6.2529674;Hf3:-7.2373524;h2g3:-7.2373524;g2f3:-9.760797;e2e3:-10.1107645;Uf3:-10.632582;Uh3:-11.2323;Rd3:-14.041089;h2h3:-15.427687;f2e3:-20.17933;b2:-20.896427;Rd2:-21.049213;e2f3:-21.280682;e2d3:-21.844788;f2g3:-22.594591;d5:-23.31478;d4:-24.520496;f2f3:-24.699238;b3:-27.184448;c2d3:-31.491003;Pd2:-31.864956;d7:-42.42507;d6:-55.908863
d2c3 a7b6|8|0.14684066|g2g3:2.9298723;h2g3:-4.3086457;Hf3:-4.458663;g2h3:-6.7999864;Uf3:-10.632582;g2f3:-11.769606;Uh3:-12.604196;e2e3:-13.774858;Hd3:-15.371329;h2h3:-15.427687;b2:-19.648968;e2f3:-21.352448;Rd3:-21.970661;f2f3:-22.007334;f2g3:-22.594591;f2e3:-23.780924;e2d3:-24.557821;Rd2:-24.849195;d4:-27.665096;b3:-29.467606;Pd2:-35.421886;c2d3:-39.521347;d7:-40.78259;d5:-49.43312;d6:-58.845512
d2c3 c7b6|8|0.12548277|g2g3:1.8242204;h2g3:1.6963922;Hf3:1.345066;Uf3:1.1777586;Hd3:-2.5386896;Uh3:-4.1979876;g2h3:-4.806033;e2e3:-5.2030377;g2f3:-6.406993;f2e3:-7.305163;b2:-10.432853;Rd2:-11.5610485;h2h3:-12.148016;Rd3:-13.235521;f2g3:-14.405142;d4:-19.555597;e2d3:-19.716404;e2f3:-23.039236;f2f3:-24.699238;Pd2:-28.172768;c2d3:-31.491003;d7:-34.171356;b3:-38.402275;d5:-42.33708;d6:-51.822586
d2c3 d7d6|8|0.11669211|g2g3:-1.9757825;Uf3:-5.536177;h2g3:-5.855905;g2h3:-6.3964286;g2f3:-7.1683855;Hd3:-9.050494;Uh3:-11.024557;h2h3:-12.243664;Hf3:-14.187195;e2e3:-14.264582;Rd3:-16.352041;f2g3:-17.43967;e2d3:-17.736279;d4:-18.454048;Rd2:-20.346907;f2f3:-22.435966;f2e3:-24.242647;e2f3:-25.484798;Pd2:-26.253431;d6:-28.343464;b2:-32.39896;c2d3:-34.8019;b3:-44.970093;d5:-59.817448
d2c3 e7e6|8|0.10681508|g2g3:8.7828045;g2h3:4.7658973;h2g3:1.9575117;Hd3:1.1642298;Hf3:0.78972924;Uf3:0.426389;Uh3:-0.1929387;g2f3:-0.89435697;e2e3:-3.0124192;f2e3:-5.9123645;h2h3:-5.9961133;Rd3:-6.5230007;Rd2:-7.2609572;d4:-8.762952;f2g3:-11.639112;e2d3:-12.797585;e2f3:-14.639819;f2f3:-15.114939;c2d3:-21.855211;d7:-23.504696;Pd2:-23.912687;b2:-31.830444;b3:-31.858526;d6:-37.454727;d5:-39.392174
g2h3 b7b6|8|0.19073498|Fg4:-11.737443;d2c3:-13.884199;Hd3:-15.233701;d2e3:-18.183786;Ug3:-20.161827;Kg2:-20.404741;f2g3:-23.161392;Hf3:-23.400963;Ff3:-23.95014;Uf3:-24.223276;h2g3:-26.960352;e2e3:-27.692854;f7:-29.275965;f5:-29.450087;b2:-29.457092;d2d3:-30.571459;Ug4:-31.713598;f2e3:-31.899792;e2d3:-31.921545;c2c3:-32.637947;Ug2:-32.93714;e2f3:-33.091843;g5:-34.737988;f2f3:-38.22107;c2d3:-40.67028;Hg2:-40.87995;Fg2:-41.24779;Fg6:-46.555054;g8:-51.91415;b3:-57.402058;Ug6:-68.53788;g7:-78.0466
g2h3 e7f6|8|0.19073498|d2c3:-10.215619;Fg4:-10.215619;Hd3:-10.772219;Ug3:-13.061161;Uf3:-14.794522;Kg2:-14.864885;d2e3:-16.439611;e2e3:-18.754425;Ff3:-19.124403;f2e3:-19.474428;Ug4:-20.225271;h2g3:-21.975117;Hf3:-22.365736;f2g3:-23.154531;f7:-24.714933;d2d3:-24.90013;c2c3:-25.694935;Ug2:-26.966253;e2f3:-27.485756;e2d3:-27.80772;Fg6:-33.1534;Fg2:-33.160053;Hg2:-34.972107;f2f3:-35.484146;g8:-37.43689;b2:-39.841034;c2d3:-41.934185;f5:-42.05077;b3:-50.494366;Ug6:-68.20299;g5:-73.60325;g7:-76.79428
g2h3 he6|8|0.19073498|d2c3:-8.288816;Fg4:-10.199891;Hd3:-10.199891;Ug3:-11.064266;f7:-11.380647;Uf3:-15.204733;Kg2:-15.511899;d2e3:-17.601135;f5:-17.81776;Ff3:-21.564228;f2g3:-22.594477;Ug4:-22.88876;e2d3:-22.992485;Hf3:-23.048698;g8:-24.294142;e2e3:-24.96339;h2g3:-25.40429;c2c3:-25.993341;d2d3:-27.30265;f2e3:-27.941162;Ug2:-31.412823;e2f3:-33.091843;Fg2:-33.3233;Fg6:-33.673203;f2f3:-36.646095;Hg2:-37.53686;c2d3:-37.865284;b2:-42.534996;b3:-46.211998;g7:-61.260082;Ug6:-65.29076;g5:-66.04916
g2h3 b7a6|8|0.1677877|Fg4:-4.91686;Hd3:-7.238573;d2c3:-8.426627;Ug3:-11.208277;Ff3:-14.332583;Kg2:-15.511899;d2e3:-16.99793;Hf3:-19.02693;e2e3:-20.3185;Uf3:-20.445818;f7:-20.835764;h2g3:-21.975117;Ug4:-22.311626;f2g3:-23.154531;c2c3:-23.617256;f5:-23.935808;Ug2:-25.696238;f2e3:-25.957973;e2f3:-27.007189;d2d3:-28.39964;g5:-29.914824;e2d3:-29.92385;f2f3:-31.1177;Fg2:-31.449516;Hg2:-36.430744;Fg6:-38.015244;c2d3:-41.585472;g8:-49.739025;b3:-52.099407;b2:-58.27122;Ug6:-61.43719;g7:-69.866844
g2h3 uc6|8|0.16349754|Fg4:-4.7378883;Hf3:-9.038381;Ug4:-9.038381;Ff3:-10.295012;Hd3:-10.430939;Ug3:-10.8736925;Kg2:-14.734828;Uf3:-16.818052;d2c3:-17.04564;e2f3:-17.380106;d2e3:-19.746866;b2:-21.890034;f2g3:-23.43039;h2g3:-23.779198;e2e3:-24.01286;f5:-24.015413;f7:-24.731924;f2f3:-25.261477;f2e3:-25.281935;e2d3:-26.755333;c2c3:-28.677279;d2d3:-28.705404;Ug2:-33.41707;g5:-34.776417;b3:-35.475277;Fg6:-35.648853;Fg2:-36.075344;Hg2:-39.270493;c2d3:-39.570057;g8:-60.76783;g7:-70.13202;Ug6:-77.48152
g2h3 a7b6|8|0.14135587|Fg4:-3.641494;d2c3:-6.7999864;Ug3:-8.044606;Ug4:-8.299109;d2e3:-9.186171;Ff3:-10.430939;h2g3:-10.540246;Hd3:-10.772219;Kg2:-11.119869;f2g3:-12.681049;Hf3:-12.676189;f7:-15.654729;Uf3:-16.818052;b2:-17.04564;e2d3:-20.474304;d2d3:-20.56511;e2e3:-20.821527;f5:-21.581326;c2c3:-24.091875;f2e3:-24.213856;e2f3:-25.308842;f2f3:-26.640934;b3:-27.331312;c2d3:-29.160679;g5:-29.758345;Ug2:-31.22779;Hg2:-32.967613;Fg6:-35.648853;Fg2:-36.075344;g8:-46.268646;g7:-63.268246;Ug6:-64.417854
g2h3 e7d6|8|0.1132162|Fg4:-1.6292614;Hd3:-1.6292614;e2e3:-6.0250554;Uf3:-6.2239447;Ug4:-6.64166;d2c3:-7.2002435;Kg2:-8.052951;Ff3:-8.069145;d2e3:-8.962515;Ug3:-9.253119;Hf3:-10.120478;f5:-10.967713;g5:-10.966409;f7:-11.447233;e2d3:-12.1868725;f2e3:-13.920676;c2c3:-17.958986;h2g3:-18.184433;f2g3:-18.50088;d2d3:-19.743462;e2f3:-20.471426;Ug2:-26.258091;f2f3:-26.377068;c2d3:-29.166433;Fg6:-29.457022;Fg2:-30.082672;g8:-30.188839;b2:-36.69805;Hg2:-38.565216;b3:-44.728874;g7:-63.3811;Ug6:-63.96195
h2g3 b7b6|8|0.1646381|Hd3:-12.98402;Kh2:-12.98402;Uf3:-12.98402;d2c3:-16.737095;Hf3:-18.00847;d2e3:-20.517015;e2e3:-21.754837;Uh3:-23.82722;e2d3:-23.84716;b2:-24.803963;Ph3:-26.960352;d2d3:-27.127663;f2f3:-30.42215;c2c3:-31.043592;e2f3:-31.450462;f2e3:-31.675518;Uh2:-35.282364;g2f3:-39.42346;c2d3:-39.8163;b3:-55.26244
h2g3 b7a6|8|0.1646381|Uf3:-9.103168;Hd3:-11.296024;e2e3:-11.633645;d2c3:-12.808865;Kh2:-15.218779;d2e3:-15.751832;Hf3:-15.916289;Uh3:-18.617445;Ph3:-21.975117;f2e3:-22.672392;e2d3:-24.099766;c2c3:-26.344715;Uh2:-26.4263;e2f3:-26.732723;f2f3:-28.400942;d2d3:-29.80844;g2f3:-30.332829;c2d3:-40.135857;b3:-50.3415;b2:-57.134335
h2g3 uc6|8|0.1179349|d2c3:-4.2744102;Uf3:-4.6079707;Hd3:-7.8058615;e2e3:-8.727625;Kh2:-9.225938;d2e3:-10.892759;d2d3:-15.625192;e2d3:-16.020493;c2c3:-16.471464;Hf3:-17.120747;Uh3:-17.120747;f2e3:-18.463346;b2:-19.643175;Ph3:-23.779198;f2f3:-25.370546;c2d3:-26.316502;g2f3:-26.494337;Uh2:-28.295944;e2f3:-30.521223;b3:-38.75936
d2e3 b7b6|8|0.1393573|g2g3:-14.6368265;Uf3:-20.517015;h2g3:-20.517015;g2h3:-21.002266;Hd3:-26.033257;Hf3:-26.235672;d4:-26.344494;h2h3:-29.190693;g2f3:-30.672728;Uh3:-30.68976;b2:-34.72052;Rd3:-35.914555;f2g3:-37.39607;Rd2:-37.69591;e2d3:-37.82205;e2f3:-39.382755;c3:-40.263912;f2f3:-42.084652;d7:-45.758488;d5:-49.395794;Pd2:-51.18014;c2d3:-52.981567;d6:-66.57668;b3:-71.56664
d2e3 b7a6|8|0.1393573|g2g3:-9.738548;h2g3:-15.751832;Uf3:-17.103168;g2h3:-18.925938;d4:-20.497984;Hd3:-20.70629;g2f3:-23.383429;h2h3:-25.539665;Hf3:-27.985476;Rd3:-28.71545;Uh3:-29.627417;f2g3:-31.128979;Rd2:-32.967575;c3:-34.494473;e2d3:-35.399178;d7:-35.55351;e2f3:-40.177963;f2f3:-43.88179;d5:-49.085114;Pd2:-49.47799;c2d3:-54.24472;d6:-65.27098;b3:-65.49315;b2:-70.04151
d2e3 e7f6|8|0.1393573|g2g3:-9.738548;Uf3:-14.68409;h2g3:-15.10607;g2h3:-16.439611;g2f3:-17.834536;Uh3:-19.522537;Hd3:-20.817919;Hf3:-21.186762;d4:-23.711187;h2h3:-25.091429;e2d3:-27.4258;Rd3:-28.481787;f2g3:-30.77921;c3:-33.20715;Rd2:-33.81785;e2f3:-37.023155;d7:-37.708336;f2f3:-39.887615;c2d3:-43.279934;d5:-46.289783;b2:-47.26125;Pd2:-47.649296;b3:-50.292297;d6:-52.626766
d2e3 uc6|8|0.11769539|Uf3:-9.198439;g2f3:-9.267389;g2g3:-9.437787;h2g3:-10.892759;Hf3:-18.367409;g2h3:-19.64213;Uh3:-19.672033;h2h3:-20.474794;Hd3:-21.454594;b2:-23.346226;Rd3:-25.344193;d4:-27.665096;e2d3:-28.544613;e2f3:-29.157349;f2g3:-29.305996;Rd2:-31.331337;f2f3:-35.723484;d5:-38.875137;d7:-40.06177;b3:-40.8254;Pd2:-41.580296;c3:-41.92432;c2d3:-46.682537;d6:-58.38172
d2e3 he6|8|0.10957462|g2g3:-7.0060105;h2g3:-17.484905;g2h3:-18.925938;Uf3:-20.516241;Hd3:-23.009544;g2f3:-24.78782;h2h3:-25.539665;Hf3:-27.985476;d4:-28.653177;Rd3:-28.71545;e2d3:-28.901718;f2g3:-31.128979;Uh3:-31.151466;Rd2:-33.48964;c3:-35.73771;d7:-39.699825;e2f3:-40.177963;f2f3:-43.88179;c2d3:-47.561092;d5:-49.447144;Pd2:-49.88871;b2:-51.233444;b3:-57.169712;d6:-64.79093
g2g3 b7b6 Kg2|8|0.125|b5:27.012783;g7:27.28035;kb7:30.390306;he6:30.390306;uc6:30.783611;c4:31.433573;e7f6:31.71021;fc6:34.54889;hc6:37.462193;ua6:38.976112;d7e6:39.67461;d7d6:39.80915;e7d6:39.872646;e7e6:43.47097;c2:44.384068;c7d6:46.697117;f7f6:47.164753;f7e6:47.774353;fb7:47.831806;pa6:49.11741;c7c6:50.905994;d7c6:52.53946;g6:54.226887;ub7:55.174397;hb7:55.331642;b3:61.60184
g2g3 b7b6 g4|8|0.125|b5:26.15275;he6:29.60698;e7f6:31.882341;e7d6:33.769596;kb7:34.656475;fc6:36.125996;uc6:37.694695;hc6:40.488518;ua6:40.838787;g7:41.38643;d7e6:43.720245;d7d6:44.278984;e7e6:44.67223;f7f6:45.87354;c2:47.163387;pa6:47.322662;c7d6:47.936153;fb7:48.370255;ub7:52.783054;d7c6:53.29176;g6:53.84318;c7c6:53.86562;c4:56.180775;hb7:56.995415;f7e6:58.92538;b3:74.89902
g2g3 b7b6 Hd3|8|0.125|b5:23.41886;he6:26.101513;uc6:29.108046;e7f6:29.605404;c2:30.26108;fc6:34.54889;kb7:34.656475;e7d6:35.52502;hc6:37.462193;c4:37.49178;d7e6:39.623493;d7d6:39.80915;e7e6:40.566555;ua6:40.793907;g7:42.52207;fb7:45.711567;pa6:45.90936;c7d6:46.697117;f7f6:46.874313;c7c6:50.905994;ub7:52.43255;d7c6:52.738945;hb7:56.995415;f7e6:57.294365;b3:60.559853;g6:64.47291
g2g3 b7b6 d2c3|8|0.125|b5:23.514822;e7f6:26.393265;he6:27.29062;d7d6:27.29062;e7d6:27.488722;kb7:28.497837;fc6:28.507778;uc6:30.622576;hc6:31.307198;c7d6:33.910667;fb7:37.038986;f7f6:39.217556;c2:40.428318;ua6:40.838787;d7e6:40.926456;e7e6:40.99874;c7c6:43.09759;pa6:45.60726;g7:45.65094;ub7:48.470493;d7c6:48.946854;hb7:50.645943;c4:53.875965;f7e6:54.255383;b3:59.3739;g6:72.386246
g2g3 b7b6 f5|8|0.125|e7e6:21.936703;e7f6:23.30125;b5:23.576008;fc6:26.410719;he6:29.60698;uc6:30.536348;kb7:30.536348;e7d6:33.34835;hc6:34.720547;fb7:35.13041;ua6:36.695026;c2:37.297184;c7c6:40.36137;d7c6:40.9236;g7:41.443268;d7e6:41.762398;d7d6:44.341858;pa6:44.989403;f7f6:45.406578;c7d6:47.122223;ub7:48.038982;hb7:51.806446;g6:52.4699;f7e6:52.693504;c4:56.180775;b3:56.851757
g2g3 b7b6 Uf3|8|0.114238225|e7f6:20.715122;uc6:20.715122;he6:25.022558;kb7:25.787834;e7d6:25.899523;b5:27.012783;fc6:28.114517;c4:31.070335;hc6:34.466274;g7:34.551468;fb7:35.449997;d7d6:35.845226;e7e6:36.584846;c2:37.118786;f7f6:38.768143;d7e6:38.86686;c7d6:39.79117;ua6:40.47331;c7c6:40.695137;d7c6:41.869698;f7e6:45.022194;pa6:47.03048;ub7:52.012024;g6:52.4699;b3:58.030827;hb7:60.388123
g2g3 b7b6 d2e3|8|0.105292104|b5:19.692432;e7f6:23.683088;kb7:25.224045;d7d6:25.224045;he6:25.224045;fc6:26.066193;c4:26.32583;uc6:26.711962;c2:28.258598;e7d6:28.322235;c7d6:31.844093;e7e6:32.559113;hc6:32.604294;d7e6:35.669594;f7f6:36.86272;ua6:38.01367;pa6:38.372215;fb7:39.25297;c7c6:40.70417;g7:40.96344;hb7:45.424038;d7c6:46.707344;f7e6:47.74531;ub7:49.7045;b3:54.732697;g6:67.7842
g2g3 e7f6 Kg2|8|0.125|b7b6:31.71021;uc6:33.304726;a7b6:36.61053;g7:36.640087;hc6:38.011177;a7a6:38.96864;ua6:39.46538;b7c6:39.691113;b7a6:40.494354;c7b6:40.824486;he6:43.818073;d7d6:45.759426;c7c6:48.48259;re6:49.00142;re7:49.470097;c7d6:50.42794;e5:51.12222;pe7:54.984207;d7e6:55.886467;d7c6:55.886467;f7e6:63.68701;e2:64.89851;g6:67.65194;e4:69.39448;e3:84.30347
g2g3 e7f6 g4|8|0.125|b7b6:31.882341;uc6:32.472267;a7b6:38.025677;g7:39.99044;hc6:40.217415;b7a6:40.22931;a7a6:41.39894;ua6:41.705235;d7d6:43.45825;c7b6:43.867218;he6:44.4082;b7c6:45.609447;d7e6:47.72743;c7c6:48.208237;c7d6:49.783684;d7c6:51.54831;re6:51.96287;re7:52.977066;e5:54.686012;g6:57.754078;f7e6:62.9408;e2:64.74351;pe7:66.06394;e4:66.6947;e3:85.18567
g2g3 e7f6 Hd3|8|0.125|uc6:28.47072;b7b6:30.52907;a7b6:34.15112;hc6:35.293373;b7a6:36.602657;ua6:37.792828;a7a6:38.118385;b7c6:40.585674;c7b6:41.631844;he6:43.701393;g7:44.385204;re6:45.248425;d7d6:45.338116;c7c6:47.341022;c7d6:48.46355;re7:49.470097;d7c6:50.5496;d7e6:51.787903;e5:54.686012;e2:55.46051;f7e6:63.303463;pe7:63.590755;e4:70.62679;e3:73.2856;g6:80.64331
g2g3 e7f6 d2c3|8|0.125|b7b6:29.486067;a7b6:29.687744;hc6:29.687744;uc6:31.811892;ua6:32.82354;b7a6:33.806377;a7a6:38.227177;b7c6:38.92776;c7b6:39.18846;he6:41.065144;e5:41.594524;re6:43.155457;d7d6:43.299313;c7d6:44.77833;c7c6:45.584774;re7:46.14303;g7:46.771267;d7e6:47.902782;d7c6:48.73035;f7e6:57.93874;e2:62.13272;pe7:62.709843;e4:65.03976;e3:73.87674;g6:76.28987
g2g3 e7f6 d2e3|8|0.1116976|b7b6:23.683088;uc6:28.683847;b7a6:31.276478;a7b6:32.29355;hc6:32.29355;he6:33.435486;ua6:36.89911;e5:37.97008;b7c6:38.110935;a7a6:38.593975;e3:40.344852;c7b6:40.827065;d7d6:41.329556;re6:43.07168;c7c6:45.55499;d7e6:45.817715;g7:47.577927;d7c6:47.78489;re7:47.994595;c7d6:48.680645;pe7:56.75685;f7e6:61.767437;e4:62.527763;g6:84.40428
g2g3 uc6 g4|8|0.125|e7f6:35.77432;b7b6:35.77432;a7b6:37.240894;he6:38.95713;g7:39.310455;d7d6:41.943653;a7a6:43.79254;d7e6:44.615868;g6:44.814518;b7a6:45.642002;e7d6:45.69851;c7d6:47.40085;c7b6:50.936695;e7e6:52.47417;f7e6:53.062843;b8:54.832336;f7f6:56.210728
g2g3 he6 Kg2|8|0.125|b7b6:30.390306;g7:31.41046;a7b6:33.26274;uc6:33.26274;b7a6:35.395798;e7f6:36.494987;a7a6:38.776726;ua6:38.976112;b7c6:39.795773;d7d6:41.44012;e7d6:45.763004;f7f6:47.164753;c7d6:48.30706;d8:48.97976;c7c6:50.499184;c7b6:52.186882;d7c6:52.402466;g6:59.821312
g2g3 he6 g4|8|0.125|b7b6:29.60698;b7a6:37.955967;uc6:38.95713;a7b6:38.95713;g7:40.6977;d7d6:41.575924;e7f6:44.544273;a7a6:45.6791;b7c6:46.113808;ua6:46.506737;e7d6:48.291603;f7f6:48.626026;c7d6:48.847248;g6:49.244698;d8:50.850048;c7b6:52.481388;d7c6:53.36776;c7c6:53.86562
g2g3 he6 d2c3|8|0.125|b7b6:29.028067;uc6:29.251259;a7b6:29.251259;d7d6:32.89041;ua6:37.036034;e7d6:37.62682;b7a6:37.91626;b7c6:39.562283;e7f6:41.065144;c7c6:41.67188;a7a6:42.438984;c7d6:44.205853;d7c6:45.8149;d8:48.20054;c7b6:48.39562;f7f6:48.487293;g7:65.13816;g6:77.297295
g2g3 he6 d2e3|8|0.125|d7d6:25.224045;b7b6:25.224045;uc6:25.332884;a7b6:25.932934;e7d6:29.4816;b7a6:31.384266;a7a6:31.711561;b7c6:33.708504;c7d6:34.243977;ua6:35.71237;c7b6:37.51625;e7f6:39.459167;c7c6:40.70417;d8:41.605534;d7c6:43.575386;f7f6:43.840843;g7:60.762146;g6:69.01059
g2g3 he6 f5|8|0.115500696|e7f6:27.66579;a7b6:28.571898;uc6:28.571898;b7b6:29.60698;b7a6:30.616253;d7d6:36.165077;b7c6:37.228577;ua6:39.02139;a7a6:39.05439;g7:39.632767;f7f6:40.277283;c7b6:41.83209;c7d6:42.011265;e7d6:42.3015;c7c6:44.401993;d8:45.2326;d7c6:45.434303;g6:49.244698
g2g3 he6 Hd3|8|0.11016898|b7b6:23.582582;uc6:28.044746;a7b6:33.26274;b7a6:33.776184;d7d6:37.949223;ua6:41.563183;e7f6:43.701393;a7a6:44.563297;b7c6:44.585938;e7d6:45.21406;c7d6:46.697117;c7b6:46.818134;f7f6:47.050476;c7c6:47.047028;d8:48.4854;d7c6:52.402466;g7:57.04434;g6:64.47291
Uf3 b7a6 g2g3|8|0.125|fc6:31.490328;uc6:32.95224;hc6:34.949272;d7c6:37.603207;c7c6:46.889378;ub7:52.176895;fb7:55.09528;hb7:66.46768;e7d6:9900.0;a7b6:9900.0;f7e6:9900.0;g6:9900.0;e7f6:9900.0;c2:9900.0;f7f6:9900.0;b4:9900.0;he6:9900.0;g7:9900.0;b2:9900.0;ub6:9900.0;e7e6:9900.0;fb3:9900.0;kb7:9900.0;d7d6:9900.0;c7b6:9900.0;ub5:9900.0;d7e6:9900.0;b1:9900.0;ub3:9900.0;c7d6:9900.0;fb5:9900.0;c4:9900.0
Uf3 b7a6 g2h3|8|0.125|hc6:25.475368;uc6:26.94544;d7c6:29.088308;fc6:29.756594;c7c6:34.362686;ub7:45.572556;fb7:48.549458;hb7:56.65524;b1:9900.0;b2:9900.0;g7:9900.0;ub3:9900.0;c7d6:9900.0;kb7:9900.0;f7e6:9900.0;f7f6:9900.0;ub6:9900.0;d7d6:9900.0;c4:9900.0;g6:9900.0;e7f6:9900.0;ub5:9900.0;fb5:9900.0;c2:9900.0;c7b6:9900.0;a7b6:9900.0;e7d6:9900.0;e7e6:9900.0;fb3:9900.0;he6:9900.0;b4:9900.0;d7e6:9900.0
Uf3 b7a6 Hd3|8|0.125|fc6:24.742546;hc6:32.2443;uc6:33.625496;d7c6:37.370182;c7c6:44.154854;fb7:54.59604;ub7:57.075214;hb7:66.46768;e7e6:9900.0;ub3:9900.0;b2:9900.0;ub6:9900.0;fb3:9900.0;f7e6:9900.0;ub5:9900.0;kb7:9900.0;he6:9900.0;g6:9900.0;d7d6:9900.0;c7b6:9900.0;a7b6:9900.0;g7:9900.0;e7f6:9900.0;c7d6:9900.0;b4:9900.0;c2:9900.0;b1:9900.0;c4:9900.0;e7d6:9900.0;fb5:9900.0;f7f6:9900.0;d7e6:9900.0
Uf3 b7a6 d2c3|8|0.120150074|fc6:24.204626;hc6:25.186537;uc6:30.54968;d7c6:42.281612;ub7:43.475044;c7c6:45.27076;fb7:49.43039;hb7:55.401356;e7f6:9900.0;b4:9900.0;d7d6:9900.0;b1:9900.0;b2:9900.0;e7e6:9900.0;d7e6:9900.0;he6:9900.0;g7:9900.0;e7d6:9900.0;a7b6:9900.0;fb5:9900.0;f7f6:9900.0;ub5:9900.0;ub6:9900.0;ub3:9900.0;f7e6:9900.0;g6:9900.0;c4:9900.0;c7d6:9900.0;c2:9900.0;kb7:9900.0;c7b6:9900.0;fb3:9900.0
Uf3 b7a6 h2g3|8|0.10443635|hc6:23.265411;fc6:30.540213;uc6:30.54968;d7c6:36.16356;c7c6:43.092216;fb7:53.95345;ub7:57.075214;hb7:58.190834;c2:9900.0;f7e6:9900.0;b1:9900.0;f7f6:9900.0;g7:9900.0;fb3:9900.0;b2:9900.0;g6:9900.0;kb7:9900.0;a7b6:9900.0;he6:9900.0;c4:9900.0;d7d6:9900.0;d7e6:9900.0;ub6:9900.0;c7d6:9900.0;fb5:9900.0;e7e6:9900.0;e7d6:9900.0;c7b6:9900.0;ub5:9900.0;b4:9900.0;ub3:9900.0;e7f6:9900.0
Uf3 b7b6 Hd3|8|0.125|fc6:28.114517;uc6:32.451653;fb7:32.64274;hc6:34.50933;c7c6:40.695137;d7c6:41.869698;ub7:56.364315;hb7:60.388123;d7d6:9900.0;f7e6:9900.0;c4:9900.0;e7f6:9900.0;d7e6:9900.0;e7d6:9900.0;pa6:9900.0;c2:9900.0;c7d6:9900.0;b5:9900.0;e7e6:9900.0;f7f6:9900.0;g6:9900.0;kb7:9900.0;ua6:9900.0;he6:9900.0;b3:9900.0;g7:9900.0
Uf3 b7b6 g2h3|8|0.125|uc6:14.047996;fc6:28.48803;hc6:28.521965;c7c6:30.880968;fb7:32.94148;d7c6:38.550964;ub7:45.586002;hb7:50.868397;g6:9900.0;e7e6:9900.0;kb7:9900.0;ua6:9900.0;f7e6:9900.0;c7d6:9900.0;b5:9900.0;e7f6:9900.0;d7d6:9900.0;c2:9900.0;g7:9900.0;c4:9900.0;b3:9900.0;e7d6:9900.0;d7e6:9900.0;he6:9900.0;f7f6:9900.0;pa6:9900.0
Uf3 b7b6 g2g3|8|0.125|uc6:22.108248;fc6:28.114517;hc6:34.50933;fb7:39.093384;c7c6:41.14239;d7c6:41.869698;ub7:53.980247;hb7:60.388123;g6:9900.0;b5:9900.0;c7d6:9900.0;f7f6:9900.0;f7e6:9900.0;c4:9900.0;e7e6:9900.0;ua6:9900.0;pa6:9900.0;d7e6:9900.0;g7:9900.0;e7d6:9900.0;d7d6:9900.0;kb7:9900.0;b3:9900.0;c2:9900.0;he6:9900.0;e7f6:9900.0
Uf3 b7b6 h2g3|8|0.125|uc6:20.988838;fc6:23.551472;hc6:24.151367;c7c6:34.16072;d7c6:39.078003;fb7:42.36712;hb7:50.933872;ub7:56.364315;g6:9900.0;ua6:9900.0;c2:9900.0;b5:9900.0;he6:9900.0;c4:9900.0;d7d6:9900.0;b3:9900.0;e7d6:9900.0;pa6:9900.0;c7d6:9900.0;kb7:9900.0;e7e6:9900.0;e7f6:9900.0;d7e6:9900.0;f7f6:9900.0;f7e6:9900.0;g7:9900.0
Uf3 b7b6 d2c3|8|0.1005801|fc6:15.746211;uc6:20.765194;hc6:26.731848;c7c6:31.595093;fb7:32.288937;d7c6:37.7711;ub7:43.011913;hb7:49.555923;e7f6:9900.0;e7e6:9900.0;c4:9900.0;d7d6:9900.0;g7:9900.0;he6:9900.0;e7d6:9900.0;g6:9900.0;kb7:9900.0;b3:9900.0;c7d6:9900.0;f7e6:9900.0;d7e6:9900.0;c2:9900.0;f7f6:9900.0;pa6:9900.0;ua6:9900.0;b5:9900.0
Uf3 uc6 Hd3|8|0.125|a7b6:20.550993;b7b6:24.142395;e7f6:24.900913;a7a6:27.63263;e7d6:27.865274;d7e6:29.88993;he6:31.097456;d7d6:32.96237;f7f6:33.44618;b7a6:33.625496;b8:34.87797;e7e6:36.272614;g7:36.481556;c7d6:37.29936;c7b6:39.711494;g6:42.602413;f7e6:47.082726
Uf3 uc6 h2g3|8|0.125|b7b6:20.765194;e7f6:21.47462;a7b6:22.640047;he6:22.640047;g7:23.075855;e7d6:26.408365;g6:26.679739;a7a6:28.406538;d7e6:30.008116;b7a6:30.54968;d7d6:33.57116;e7e6:33.747295;f7f6:34.43249;c7d6:37.29936;b8:38.56787;c7b6:40.050358;f7e6:41.91254
Uf3 uc6 g2g3|8|0.125|a7b6:19.245535;e7f6:19.326859;b7b6:20.715122;he6:22.304388;e7d6:25.787834;a7a6:27.63263;d7e6:30.283546;b7a6:31.433416;e7e6:32.84395;d7d6:32.95146;b8:34.87797;f7f6:35.605705;g7:36.481556;c7d6:36.68076;c7b6:39.812557;f7e6:41.258854;g6:48.669342
Uf3 uc6 d2c3|8|0.125|a7b6:19.757093;e7d6:20.377665;b7b6:20.765194;e7f6:21.46881;he6:21.796177;a7a6:27.529459;d7e6:30.008116;d7d6:30.005953;b7a6:30.827675;c7d6:31.047855;e7e6:31.386803;f7f6:31.556156;b8:32.25413;g7:33.871464;c7b6:38.228073;g6:42.162178;f7e6:48.48159
Uf3 uc6 b2|8|0.125|e7f6:15.676115;b7b6:15.707534;g7:19.361776;he6:20.608557;a7a6:21.42698;d7d6:23.428177;c7d6:24.11551;b8:24.422071;b7a6:24.539598;e7d6:25.521185;c7b6:25.671293;a7b6:26.8836;g6:27.867863;e7e6:29.322292;f7f6:30.148905;d7e6:30.283546;f7e6:41.725098
Uf3 uc6 e2e3|8|0.12252024|b7b6:13.227466;he6:14.429555;a7b6:16.369953;a7a6:19.925194;e7f6:20.17138;b7a6:20.231197;e7d6:25.750984;c7b6:26.381443;b8:26.387987;g7:26.422441;c7d6:26.645153;d7e6:27.164465;e7e6:27.83345;d7d6:29.05621;f7f6:31.644035;g6:37.597637;f7e6:42.922337
Uf3 uc6 h2h3|8|0.10963842|e7f6:13.710325;b7b6:14.660673;he6:16.51446;a7b6:17.608398;g7:19.619364;e7d6:21.129501;a7a6:21.185377;g6:26.857153;d7e6:26.955341;b7a6:27.866001;d7d6:28.292295;e7e6:28.468431;f7f6:28.668907;b8:28.946728;c7d6:32.020496;c7b6:34.771496;f7e6:48.48159
Uf3 uc6 g2h3|8|0.100620635|e7f6:13.097253;a7b6:13.097253;b7b6:14.047996;d7e6:23.990997;e7d6:25.19428;a7a6:25.502151;he6:25.86769;d7d6:27.672596;e7e6:27.848362;g7:27.990793;f7f6:28.41001;b7a6:28.713419;b8:30.111025;c7d6:33.10835;c7b6:35.875645;g6:39.37574;f7e6:45.921074
Uf3 hc6 g2g3|8|0.125|a7b6:30.719975;e7f6:32.775543;b7b6:34.50933;b7a6:34.949272;ua6:36.156834;a7a6:37.941536;d7d6:38.297062;e7d6:39.09804;c7b6:39.678482;d7e6:40.97663;d8:40.97663;c7d6:42.240887;e7e6:43.60942;f7f6:48.673298;f7e6:49.738804;g6:62.963425;g7:73.457466
Uf3 hc6 Hd3|8|0.125|a7b6:29.253798;b7a6:32.2443;e7f6:32.775543;b7b6:34.50933;ua6:36.156834;c7b6:36.84963;e7d6:37.40445;a7a6:37.941536;d7d6:38.297062;e7e6:40.446926;d7e6:40.97663;d8:40.97663;c7d6:41.851784;f7f6:46.87135;f7e6:54.621803;g6:56.293694;g7:66.02392
Uf3 b7c6 g2g3|8|0.125|b5:28.686293;e7f6:29.790766;he6:32.723015;ub6:32.854633;kb7:35.02588;e7d6:36.616806;d7d6:38.897327;g7:39.13896;e7e6:40.990986;c7b6:41.14239;pa6:41.986588;c7d6:42.814857;ua6:42.859234;f7f6:43.224457;d7e6:44.294777;a7b6:46.830296;hb7:47.772236;fb7:48.615692;ub7:48.79498;b4:50.1767;f7e6:57.799026;g6:61.308315;b1:73.93339;b3:93.55743;b2:95.379364
Uf3 a7b6 g2g3|8|0.125|e7f6:23.192787;e7d6:28.017864;hc6:30.719975;ka7:31.215616;he6:31.518806;d7d6:33.586975;uc6:34.887665;ua6:36.209774;e7e6:39.28287;d7e6:39.294098;c7d6:39.37532;f7f6:39.439877;c7c6:43.12715;g7:43.200466;ua7:45.40431;d7c6:46.591564;b7c6:46.830296;f7e6:47.012814;g6:61.641712;pa6:9900.0
Uf3 a7b6 h2g3|8|0.125|g7:22.40878;he6:23.017433;e7f6:24.934534;e7d6:26.264986;hc6:26.661669;ka7:26.661669;ua6:27.019833;d7d6:27.549168;g6:32.564987;d7e6:32.8906;uc6:33.16356;e7e6:33.408257;f7f6:34.43249;c7d6:37.29936;c7c6:37.348476;d7c6:40.8085;f7e6:42.153015;b7c6:43.304146;ua7:47.06737;pa6:9900.0
Uf3 a7b6 g2h3|8|0.125|e7f6:14.541475;ka7:21.109598;he6:22.75881;e7d6:23.913647;hc6:24.30443;uc6:27.44493;d7d6:27.462925;ua6:27.582647;e7e6:29.66099;f7f6:30.677309;d7e6:31.076172;c7d6:31.401894;c7c6:31.906145;g7:33.697483;ua7:37.472553;b7c6:38.814686;d7c6:41.46038;f7e6:47.623093;g6:53.36788;pa6:9900.0
Uf3 a7b6 Hd3|8|0.125|uc6:20.913385;e7f6:22.156351;d7e6:24.827755;ka7:27.34948;hc6:29.253798;e7d6:30.385061;d7d6:30.88832;he6:31.097456;e7e6:32.52813;f7f6:34.645233;ua6:36.209774;c7d6:36.68076;c7c6:39.73126;g7:43.200466;d7c6:43.460705;f7e6:44.724274;ua7:45.40431;g6:46.624184;b7c6:46.830296;pa6:9900.0
Uf3 a7b6 b2|8|0.125|e7f6:19.245535;hc6:21.120943;ua6:21.120943;he6:21.950577;uc6:26.8836;e7d6:28.017864;d7d6:28.280489;d7e6:29.657349;ka7:31.478403;ua7:31.930017;c7d6:33.54918;d7c6:34.169014;b7c6:34.548355;g7:34.789806;e7e6:35.707672;f7f6:36.13981;c7c6:37.39341;g6:41.657776;f7e6:47.623093;pa6:9900.0
Uf3 a7b6 d2c3|8|0.125|uc6:17.626558;e7f6:20.547571;ka7:20.547571;hc6:22.34157;e7d6:22.755651;ua6:24.115273;d7d6:24.13182;he6:24.13182;f7f6:31.003794;c7d6:31.047855;g7:31.40199;e7e6:33.138905;d7c6:35.722534;c7c6:36.140835;d7e6:38.15497;ua7:38.35562;b7c6:41.08063;g6:41.617493;f7e6:43.36655;pa6:9900.0
Uf3 a7b6 e2e3|8|0.10992498|he6:16.369953;uc6:17.626558;d7d6:17.838512;e7f6:21.014011;hc6:21.39249;c7d6:23.786972;ka7:23.899952;d7e6:24.26524;g7:26.14038;e7e6:28.277359;ua6:29.51609;e7d6:30.385061;b7c6:31.598413;c7c6:32.071136;f7f6:32.30098;d7c6:33.239315;f7e6:34.655533;ua7:34.725235;g6:35.654045;pa6:9900.0
Uf3 e7f6 Hd3|8|0.125|a7b6:22.156351;b7c6:24.106436;uc6:24.900913;a7a6:29.13582;hc6:30.927067;d7d6:30.984785;he6:32.226166;c7b6:34.380535;ua6:35.291492;c7c6:36.312218;g7:36.481556;c7d6:41.007698;d7c6:41.869698;re6:43.49854;re7:43.81551;d7e6:45.50982;e2:50.02414;e5:52.140553;e4:52.96467;pe7:53.198074;g6:57.717785;e3:73.42792;f7e6:75.89821;b7b6:9900.0;b7a6:9900.0
Uf3 e7f6 h2g3|8|0.125|hc6:20.790987;uc6:21.47462;a7b6:21.47462;b7c6:24.106436;a7a6:27.671762;ua6:28.381973;g7:29.424026;d7d6:32.16774;he6:33.206196;c7b6:34.678246;c7c6:36.552956;d7c6:39.078003;c7d6:41.007698;re6:41.485916;re7:42.05912;d7e6:45.484463;e5:49.35848;pe7:50.284096;e4:50.98232;e2:56.757336;g6:57.78075;f7e6:68.45512;e3:75.3318;b7b6:9900.0;b7a6:9900.0
Uf3 e7f6 e2e3|8|0.125|uc6:20.17138;a7b6:20.379068;he6:23.46506;b7c6:24.106436;d7d6:24.971327;hc6:27.162987;ua6:28.121971;a7a6:28.568207;g7:29.679302;d7e6:32.73619;c7b6:33.445972;re6:33.70751;c7d6:35.03799;c7c6:36.556343;e3:37.200836;e5:37.762024;re7:37.980576;d7c6:39.487846;pe7:43.51431;e4:64.41922;g6:71.71477;f7e6:74.17027;b7a6:9900.0;b7b6:9900.0
Uf3 e7f6 d2c3|8|0.125|uc6:20.17138;a7b6:20.532715;hc6:22.34157;ua6:23.116827;b7c6:26.872967;a7a6:27.5291;g7:27.833744;he6:30.16953;d7d6:30.389458;c7c6:33.458973;c7b6:33.68709;c7d6:34.928802;d7c6:38.399403;e5:38.43301;re6:38.947613;re7:39.704033;d7e6:40.593616;e2:46.000694;pe7:49.03791;e4:55.0401;g6:63.649765;e3:68.56669;f7e6:75.68211;b7a6:9900.0;b7b6:9900.0
Uf3 e7f6 g2g3|8|0.125|uc6:18.786793;a7b6:23.192787;a7a6:27.63263;b7c6:28.686293;hc6:32.775543;d7d6:33.09992;he6:33.478268;ua6:36.156834;g7:36.481556;c7b6:36.987843;c7d6:40.0314;c7c6:41.14239;d7c6:41.869698;re6:43.49854;re7:43.81551;d7e6:46.51966;e5:47.4062;e2:55.010708;pe7:58.62338;g6:65.213875;e4:69.865135;e3:77.995224;f7e6:79.17386;b7a6:9900.0;b7b6:9900.0
Uf3 e7f6 g2h3|8|0.125|uc6:13.52111;a7b6:14.541475;b7c6:18.409878;hc6:23.469978;d7d6:26.043602;ua6:26.878193;c7b6:27.03152;a7a6:27.042658;g7:27.990793;c7c6:30.880968;he6:31.606533;d7c6:33.587822;d7e6:34.61927;c7d6:34.752533;e5:37.277847;re6:38.219677;re7:38.262417;e2:44.22396;g6:50.648792;pe7:50.94841;e4:62.739758;f7e6:70.73055;e3:71.46091;b7a6:9900.0;b7b6:9900.0
Uf3 e7f6 d2e3|8|0.11377906|b7c6:13.752849;uc6:18.1065;a7b6:18.293053;ua6:22.507277;hc6:22.679302;a7a6:23.19174;he6:23.900316;g7:24.731153;d7d6:28.399498;c7b6:33.224667;c7d6:33.421474;c7c6:33.617638;re6:35.21024;re7:35.445408;e5:36.528633;d7c6:37.12789;e3:37.200836;d7e6:38.770832;pe7:49.292408;g6:60.545464;e4:69.865135;f7e6:71.850395;b7b6:9900.0;b7a6:9900.0
Uf3 ua6 Hd3|8|0.125|e7f6:36.156834;hc6:36.156834;a7b6:36.209774;d7d6:36.97349;he6:37.018536;e7d6:37.128704;b7c6:38.557873;f7f6:43.072094;d7e6:43.10651;d7c6:44.113342;g7:44.130596;c7d6:44.404892;b8:45.82633;e7e6:46.459;c7c6:48.17438;c7b6:49.3892;f7e6:57.291267;g6:58.710327;b7b6:9900.0
Uf3 ua6 g2g3|8|0.125|hc6:36.156834;e7f6:36.156834;a7b6:36.209774;d7d6:38.148487;he6:38.148487;b7c6:38.557873;e7d6:40.75415;d7e6:43.10651;c7b6:44.49088;g7:45.077682;d7c6:45.864147;f7f6:46.42596;e7e6:46.459;c7d6:47.50931;b8:48.94405;c7c6:53.64507;f7e6:54.99662;g6:58.710327;b7b6:9900.0
Uf3 he6 g2g3|8|0.125|uc6:25.022558;a7b6:31.518806;b7c6:32.723015;a7a6:33.261623;d7d6:33.27583;e7f6:33.478268;ua6:37.720642;f7f6:37.8912;e7d6:40.5813;c7b6:41.084366;c7d6:42.588844;d7c6:43.362957;c7c6:44.594692;d8:45.408356;g7:54.62314;g6:57.641014;b7b6:9900.0;b7a6:9900.0
Uf3 he6 g2h3|8|0.125|a7b6:22.75881;b7c6:24.85846;uc6:25.86769;c7b6:29.005817;a7a6:29.189425;e7f6:30.93252;c7c6:31.906145;d7d6:35.273643;e7d6:36.4572;d7c6:36.777714;f7f6:39.04248;d8:40.474712;ua6:40.471905;c7d6:40.760765;g7:45.14437;g6:47.593613;b7a6:9900.0;b7b6:9900.0
Uf3 he6 d2c3|8|0.125|uc6:21.734936;d7d6:24.13182;a7b6:24.13182;b7c6:27.446203;ua6:27.716711;e7f6:30.16953;a7a6:30.351385;e7d6:30.593443;f7f6:33.514587;c7d6:35.209957;d8:35.804188;c7c6:36.140835;c7b6:36.166073;d7c6:37.445145;g6:41.700703;g7:53.863983;b7b6:9900.0;b7a6:9900.0
Uf3 he6 Hd3|8|0.125|b7c6:19.451164;d7d6:28.269062;uc6:31.097456;a7b6:31.097456;e7f6:32.43538;a7a6:32.46327;e7d6:35.218014;f7f6:37.244217;ua6:37.586727;d7c6:39.143417;c7b6:39.711494;c7d6:40.760765;c7c6:41.578655;d8:41.63809;g6:42.18989;g7:63.469597;b7a6:9900.0;b7b6:9900.0
Uf3 he6 h2g3|8|0.125|b7c6:19.366257;uc6:22.640047;a7b6:23.017433;d7d6:27.549168;a7a6:29.555593;g6:31.924168;e7f6:33.206196;ua6:34.558914;f7f6:36.599457;c7c6:36.682056;c7b6:37.141415;e7d6:37.85682;c7d6:39.880417;d7c6:40.65026;d8:43.653183;g7:45.77992;b7b6:9900.0;b7a6:9900.0
Uf3 a7a6 Hd3|8|0.125|uc6:27.63263;e7f6:29.79422;he6:32.46327;ka7:33.684258;d7d6:36.97112;g7:37.031105;e7d6:37.52945;hc6:37.941536;b7c6:38.497448;c7b6:39.354248;f7f6:40.16967;e7e6:41.306496;d7e6:42.15902;c7d6:43.310436;c7c6:43.931786;d7c6:44.36071;f7e6:47.592525;g6:57.532776;ua7:57.837547;b7b6:9900.0
Uf3 a7a6 g2g3|8|0.125|uc6:27.63263;e7f6:27.63263;he6:33.261623;ka7:36.010525;hc6:37.941536;e7d6:38.681557;d7d6:39.53539;g7:40.52595;f7f6:40.785492;b7c6:41.986588;c7b6:42.6726;d7e6:44.03314;d7c6:44.36071;c7c6:46.766705;e7e6:47.0165;c7d6:50.31112;ua7:52.07041;f7e6:53.594734;g6:68.22485;b7b6:9900.0
Uf3 a7a6 h2g3|8|0.125|e7f6:28.406538;uc6:28.406538;g7:28.449682;he6:29.555593;hc6:30.683176;ka7:33.684258;d7d6:33.884872;c7b6:34.958908;e7d6:35.691628;b7c6:38.497448;d7e6:39.753708;f7f6:39.803272;e7e6:41.3359;d7c6:42.29305;c7c6:43.15551;c7d6:44.152668;g6:44.61891;f7e6:47.592525;ua7:57.837547;b7b6:9900.0
Uf3 a7a6 g2h3|8|0.125|uc6:26.605852;e7f6:26.941483;ka7:27.042658;c7b6:29.608063;he6:30.136543;hc6:30.961802;d7d6:32.03537;b7c6:33.030434;g7:37.031105;e7d6:37.52945;d7c6:39.819637;d7e6:39.997997;e7e6:40.271076;c7d6:40.289047;c7c6:41.309246;f7f6:42.33871;ua7:42.834473;f7e6:49.85227;g6:57.532776;b7b6:9900.0
Uf3 a7a6 d2c3|8|0.125|uc6:27.5291;e7f6:28.406538;he6:30.351385;ka7:32.054615;d7d6:33.427013;e7d6:33.630157;hc6:36.555088;c7d6:39.059647;f7f6:39.119965;c7b6:39.276245;ua7:39.95723;g7:40.52595;b7c6:40.574936;e7e6:41.24505;d7c6:42.078117;d7e6:42.184486;c7c6:44.329517;f7e6:49.62791;g6:58.6945;b7b6:9900.0
Uf3 a7a6 b2|8|0.1208576|uc6:21.42698;he6:21.42698;g7:22.878145;e7f6:23.058884;hc6:23.72268;ka7:25.412243;d7d6:25.88998;e7d6:28.098112;b7c6:28.206146;f7f6:31.340286;c7b6:31.678474;c7d6:33.457413;d7c6:33.497063;d7e6:34.222088;e7e6:36.37463;c7c6:37.566742;ua7:37.797718;f7e6:39.830418;g6:50.626545;b7b6:9900.0
Uf3 g7 g2g3|8|0.125|uc6:36.481556;e7f6:36.481556;b7c6:39.13896;a7a6:40.52595;d7d6:43.030754;a7b6:43.200466;ua6:44.491627;h8:45.12761;c7b6:45.325714;d7e6:46.335014;e7d6:46.489567;g6:47.721325;f7f6:47.989742;c7c6:49.657322;f8:50.34817;f7e6:53.010574;c7d6:53.150063;d7c6:54.538944;he6:54.62314;e7e6:55.468506;g8:56.53431;hc6:73.457466;b7a6:9900.0;b7b6:9900.0
Uf3 g7 Hd3|8|0.125|b7c6:33.647675;e7f6:36.481556;uc6:36.481556;a7a6:37.031105;d7d6:43.030754;c7b6:43.167892;a7b6:43.200466;ua6:44.491627;g6:44.547745;h8:45.12761;d7e6:45.550095;e7d6:46.489567;f7f6:47.989742;f8:48.029274;c7c6:49.657322;f7e6:53.010574;c7d6:53.150063;d7c6:54.736855;e7e6:55.468506;g8:56.205853;he6:63.469597;hc6:66.02392;b7b6:9900.0;b7a6:9900.0
Uf3 g7 d2c3|8|0.125|uc6:33.904846;e7f6:33.904846;b7c6:35.97942;d7d6:36.100903;a7b6:37.292736;h8:38.094334;ua6:38.361713;e7d6:40.386734;a7a6:40.52595;d7e6:42.91103;c7b6:42.995365;f7f6:43.43376;c7d6:43.520363;d7c6:43.79685;g6:45.545094;g8:46.2711;c7c6:48.822212;f8:49.384003;e7e6:49.658096;hc6:51.195198;f7e6:52.322594;he6:53.863983;b7a6:9900.0;b7b6:9900.0
Hd3 b7b6 g2g3|8|0.125|b5:23.41886;he6:23.582582;uc6:29.108046;e7f6:29.605404;c2:30.26108;e7d6:32.41924;kb7:34.656475;fc6:35.298172;g7:36.360264;c4:38.668564;hc6:38.83921;d7e6:39.623493;d7d6:39.80915;e7e6:41.243244;ua6:41.563183;pa6:43.09034;fb7:45.711567;f7f6:46.26976;c7d6:46.697117;ub7:50.30737;c7c6:52.186882;d7c6:52.738945;hb7:56.995415;f7e6:57.294365;b3:60.559853;g6:64.47291
Hd3 b7b6 g2h3|8|0.125|b5:17.880999;c2:23.045048;he6:24.446337;e7f6:24.463015;uc6:27.358273;kb7:28.41874;fc6:29.522057;ua6:30.5528;hc6:32.57367;pa6:32.641563;c4:32.795387;e7d6:33.45803;d7d6:33.78499;c7d6:34.94958;d7e6:35.113857;c7c6:39.93289;fb7:40.357018;f7f6:40.86386;e7e6:41.709557;ub7:43.839043;d7c6:45.627415;f7e6:51.49814;hb7:52.6199;b3:56.756863;g6:64.42747;g7:70.09193
Hd3 b7a6 g2g3|8|0.125|fb5:33.73536;he6:33.776184;kb7:36.35554;ub6:37.489403;e7d6:37.560894;e7f6:37.894226;fc6:39.540096;uc6:40.58729;c2:42.42512;a7b6:43.09034;g7:43.716595;c7b6:44.103603;c4:44.32;hc6:45.48324;d7e6:48.142372;d7d6:48.71039;e7e6:49.269604;ub5:50.564644;c7d6:50.958763;f7f6:51.28986;d7c6:53.36776;ub7:54.840878;c7c6:56.446117;hb7:58.018887;fb7:58.4965;f7e6:58.799046;b1:61.144592;fb3:62.20229;g6:75.44124;ub3:86.494934;b2:89.5033;b4:98.50931
Hd3 b7a6 g2h3|8|0.110482246|fb5:26.946938;he6:27.59492;e7f6:29.137335;c7b6:31.812788;ub6:32.38116;uc6:32.451374;a7b6:32.641563;c2:33.07794;fc6:33.09533;kb7:33.984596;d7d6:37.666595;e7d6:37.921253;d7e6:39.90902;hc6:40.183365;ub5:41.161182;f7f6:44.08459;c4:44.38448;e7e6:44.8101;c7d6:45.807148;fb7:46.643597;c7c6:50.15136;ub7:50.603065;d7c6:52.692345;b1:55.405396;fb3:55.7767;hb7:56.630283;f7e6:58.96827;g6:76.05463;ub3:82.235374;g7:82.413956;b4:86.25863;b2:86.96078
Uf3 d7d6 g2g3|8|0.12445875|uc6:32.95146;e7f6:33.09992;he6:33.27583;a7b6:33.586975;c4:37.51432;ua6:38.148487;hc6:38.297062;b7c6:38.897327;a7a6:39.53539;ud7:40.908436;fc6:41.58561;g7:43.030754;fd7:44.467224;d5:45.926884;e7e6:46.100758;c7b6:49.02889;f7f6:50.5264;c2:52.74815;f7e6:58.739536;c7c6:58.844585;g6:58.85594;d3:84.34197;b7a6:9900.0;b7b6:9900.0
Uf3 d7d6 Hd3|8|0.12445875|he6:28.269062;d3:28.733025;a7b6:30.532305;e7f6:30.984785;d5:31.949326;fc6:32.71255;uc6:33.57116;ua6:35.291492;b7c6:35.895348;hc6:36.870716;a7a6:36.97112;ud7:39.40834;c4:42.01503;g7:42.110157;fd7:44.467224;e7e6:45.75454;c7b6:48.510456;f7f6:48.75945;g6:52.643116;c7c6:58.844585;f7e6:61.575237;b7b6:9900.0;b7a6:9900.0
Uf3 d7d6 h2g3|8|0.12445875|he6:27.549168;a7b6:27.549168;g7:29.80783;e7f6:33.33078;uc6:33.57116;hc6:34.374935;a7a6:34.78304;b7c6:35.1778;g6:35.217354;fc6:35.60462;ua6:36.97349;ud7:39.350697;fd7:41.14772;c4:43.48282;e7e6:45.75454;f7f6:47.085644;d5:47.180054;c7b6:48.657654;c2:50.912308;f7e6:51.926373;c7c6:57.328644;d3:84.06857;b7a6:9900.0;b7b6:9900.0
Uf3 d7d6 g2h3|8|0.10810189|e7f6:26.043602;a7b6:27.462925;uc6:27.672596;b7c6:31.96364;c4:32.25192;hc6:32.74091;ua6:32.74091;a7a6:34.08566;he6:35.273643;fc6:35.91387;d5:35.99514;g7:36.311516;fd7:39.101974;ud7:39.1725;c7b6:42.239555;c2:43.147266;e7e6:45.16745;g6:46.12776;f7f6:47.479828;c7c6:52.651848;f7e6:61.575237;d3:76.72785;b7a6:9900.0;b7b6:9900.0
d2c3 b7b6 g2g3|8|0.12322284|e7f6:23.694818;he6:27.29062;d7d6:27.29062;kb7:27.29062;e7d6:27.488722;b5:28.50711;fc6:28.507778;uc6:30.622576;hc6:31.232458;c7d6:33.46589;fb7:37.038986;g7:37.16195;f7f6:39.217556;e7e6:40.364517;c2:40.428318;ua6:40.838787;d7e6:40.926456;c7c6:43.09759;pa6:45.60726;d7c6:48.946854;ub7:49.497864;hb7:50.645943;c4:53.875965;f7e6:54.255383;b3:59.3739;g6:72.386246
e2e3 uc6|8|0.12102069|Uf3:2.0681543;Hd3:-8.302911;h2g3:-8.727625;g2g3:-12.673995;Uh3:-13.7644615;d2c3:-13.774858;Ff3:-14.495549;g2f3:-18.269808;Ue2:-18.707544;h2h3:-19.888144;Hf3:-19.947847;e4:-21.761978;Fe2:-22.569597;g2h3:-22.595146;b2:-24.07456;f2g3:-25.866325;c2c3:-27.829222;b3:-27.86505;d2d3:-28.544613;f5:-29.730377;f7:-32.334183;f2f3:-38.139523;c2d3:-43.26036;e6:-65.49045
e2e3 he6|8|0.12102069|e6:-14.437605;Hd3:-16.929909;Uf3:-17.3505;e4:-17.377853;g2g3:-17.607052;d2c3:-17.806019;h2g3:-18.348501;f5:-20.936115;Uh3:-20.936115;Ff3:-22.37179;h2h3:-23.26481;g2h3:-24.96339;Hf3:-28.187433;d2d3:-28.544613;f2g3:-30.504053;Fe2:-31.02611;Ue2:-31.64671;g2f3:-34.02516;c2c3:-36.224308;b2:-37.27298;c2d3:-44.7773;b3:-45.514603;f2f3:-49.811295
e2e3 a7b6|8|0.12102069|h2g3:-8.302911;g2g3:-10.50051;Hd3:-12.126792;b2:-13.024554;g2h3:-13.292241;d2c3:-13.774858;Ff3:-14.024605;Uf3:-15.696474;Uh3:-18.395367;g2f3:-20.496426;Hf3:-21.579222;Ue2:-21.812494;Fe2:-22.569597;h2h3:-22.851767;e4:-24.732828;f5:-24.732828;d2d3:-28.544613;f2g3:-28.806856;b3:-30.289764;c2c3:-31.029875;f7:-32.334183;c2d3:-33.340843;f2f3:-37.394386;e6:-65.49045
e2e3 b7c6|8|0.12102069|g2g3:-6.330389;Hd3:-6.330389;g2h3:-8.550531;h2g3:-8.934559;d2c3:-12.284745;Uh3:-15.471948;h2h3:-17.240337;Ff3:-17.24358;Uf3:-17.535967;g2f3:-17.789272;f5:-19.122322;Hf3:-19.54942;Ue2:-19.984152;Fe2:-23.7046;e4:-26.406013;f7:-28.10249;f2g3:-28.386976;c2c3:-33.153927;d2d3:-34.972775;f2f3:-39.499016;c2d3:-42.45008;b3:-55.631203;b2:-58.671394;e6:-65.9987
e2e3 e7f6|8|0.12102069|Hd3:-7.6303496;g2g3:-7.6303496;h2g3:-8.41975;d2c3:-12.957625;Uf3:-13.149981;Uh3:-16.211752;Ff3:-17.930695;g2h3:-18.754425;Hf3:-20.468313;h2h3:-21.59302;Ue2:-22.483732;f7:-24.107773;Fe2:-24.186344;g2f3:-25.375263;d2d3:-26.90157;e4:-29.22943;f2g3:-29.942635;c2c3:-31.25339;b2:-33.10038;f2f3:-39.356388;f5:-42.639427;c2d3:-43.347443;b3:-46.429005;e6:-55.679775
e2e3 b7a6|8|0.12102069|Hd3:-11.756158;h2g3:-11.819913;g2g3:-12.890986;Uf3:-17.062025;d2c3:-17.92936;g2h3:-20.3185;h2h3:-20.425804;Uh3:-20.702276;Ff3:-22.37179;Hf3:-24.30132;f5:-25.195032;Ue2:-26.431004;Fe2:-27.151777;e4:-27.163895;g2f3:-28.097406;f7:-29.0766;f2g3:-30.504053;d2d3:-34.03825;c2c3:-35.355324;f2f3:-43.84366;c2d3:-54.07387;b3:-62.773354;b2:-66.48865;e6:-67.4389
g2g3 b7a6 Kg2|8|0.11641777|fb5:35.21232;kb7:35.25639;he6:35.395798;g7:36.002888;ub6:37.113895;fc6:38.168808;e7f6:40.494354;e7d6:41.236538;c4:41.266144;uc6:41.45275;hc6:42.234573;ub5:44.78957;d7d6:46.90694;a7b6:49.11741;d7e6:49.34764;e7e6:51.428387;c2:51.836197;b4:52.571545;f7f6:53.26733;c7d6:53.90494;c7b6:54.0123;g6:55.87179;c7c6:57.251984;hb7:58.018887;ub7:58.01722;f7e6:58.99404;fb7:59.092175;d7c6:60.17934;fb3:62.469826;b1:74.87898;ub3:92.301056;b2:93.14978
g2g3 b7a6 g4|8|0.11641777|fb5:37.266552;he6:38.235287;e7d6:39.844986;e7f6:40.487843;ub6:40.988495;kb7:41.741013;fc6:43.304787;uc6:46.484806;g7:46.777122;a7b6:47.322662;hc6:48.82552;d7d6:49.23222;c7b6:49.47428;e7e6:50.00638;c7d6:50.958763;c2:51.999493;f7f6:52.425076;d7c6:53.36776;d7e6:53.695175;ub5:55.453472;b4:56.09214;c4:56.684128;ub7:58.31222;fb7:59.927685;c7c6:60.187626;g6:61.93257;hb7:62.207363;f7e6:63.173744;fb3:73.15929;b1:80.98822;ub3:100.12225;b2:102.74743
g2g3 b7a6 Hd3|8|0.11641777|fb5:34.837776;he6:35.034;e7d6:37.560894;e7f6:37.894226;kb7:40.20493;uc6:40.58729;ub6:40.988495;fc6:41.065716;hc6:42.058247;c2:42.42512;c4:42.504868;c7b6:43.958923;a7b6:45.90936;d7e6:48.142372;d7d6:48.71039;e7e6:49.269604;ub5:50.564644;f7f6:51.28986;c7d6:53.90494;ub7:54.840878;g7:56.487175;fb7:58.4965;f7e6:58.799046;c7c6:58.91689;d7c6:60.17934;fb3:60.89491;b1:61.144592;hb7:61.983543;g6:75.44124;ub3:86.494934;b4:86.64949;b2:93.11965
g2g3 b7a6 d2c3|8|0.11641777|fb5:31.696386;e7f6:36.58986;e7d6:37.09557;he6:38.235287;ub6:38.33267;fc6:39.79448;hc6:40.3996;kb7:40.987568;d7d6:43.073208;c7d6:43.43014;c2:45.035175;uc6:45.125366;a7b6:45.60726;ub5:45.606647;ub7:47.4321;c7b6:47.81764;g7:48.46167;e7e6:50.22817;d7e6:50.27536;f7f6:50.74985;fb7:51.605873;d7c6:52.077698;c7c6:52.15189;hb7:57.20224;f7e6:58.6392;fb3:59.86018;c4:61.136166;b1:62.7168;g6:80.156204;ub3:88.43115;b2:98.906204;b4:100.89114
g2g3 b7a6 Uf3|8|0.10508193|ub5:27.264315;fc6:31.490328;he6:31.490328;uc6:31.541143;hc6:32.2443;kb7:33.625496;fb5:35.21232;e7f6:35.80116;d7c6:37.370182;e7d6:37.58673;ub6:39.214256;c4:41.034782;c7c6:44.154854;g7:44.299694;c2:44.94303;e7e6:46.118595;f7f6:46.709496;a7b6:47.03048;d7d6:47.169;c7d6:49.170498;d7e6:49.70577;c7b6:52.119537;ub7:52.176895;b4:53.006977;f7e6:54.85696;fb7:55.09528;g6:57.669926;hb7:66.46768;fb3:66.671455;b1:80.456535;b2:89.29188;ub3:93.952835
Uf3 e7d6 Hd3|8|0.11465806|a7b6:27.071281;uc6:27.112444;b7c6:29.718456;he6:35.218014;hc6:37.40445;a7a6:37.52945;ua6:37.78581;re6:41.19865;g7:44.019127;re7:46.695766;c7b6:47.389786;d7e6:48.227844;d7c6:49.934875;e5:52.140553;e2:54.10563;c7c6:54.337334;e4:54.957508;g6:55.5707;pe7:62.280952;f7e6:66.70065;e3:77.765526;f6:80.81201;b7b6:9900.0;b7a6:9900.0
Uf3 e7d6 e2e3|8|0.11465806|uc6:25.750984;a7b6:26.260696;he6:26.380817;b7c6:29.240124;hc6:29.500206;a7a6:30.24828;ua6:30.749355;d7e6:36.915905;c7b6:37.12181;re6:37.194;g7:37.811275;e5:38.465496;d7c6:39.373318;e3:40.32604;re7:41.029922;c7c6:43.476646;pe7:48.459126;g6:54.924007;f7e6:61.028748;e4:61.526447;f6:81.144455;b7a6:9900.0;b7b6:9900.0
Uf3 e7d6 g2g3|8|0.11465806|uc6:24.851862;a7b6:28.017864;b7c6:36.616806;a7a6:38.681557;ua6:39.09804;hc6:39.09804;g7:40.386734;he6:40.5813;re6:41.19865;re7:46.954643;c7b6:47.65521;d7e6:48.227844;d7c6:49.934875;e5:51.164986;c7c6:54.337334;e2:57.878082;f7e6:61.612514;pe7:64.12112;g6:64.768715;f6:71.64477;e4:72.32;e3:81.58503;b7a6:9900.0;b7b6:9900.0
Uf3 e7d6 d2c3|8|0.11465806|a7b6:24.697353;uc6:25.521774;ua6:27.056694;hc6:27.056694;he6:30.255247;b7c6:31.342;a7a6:34.75952;re6:38.34514;c7b6:39.159126;g7:40.386734;re7:40.78437;e5:43.4524;d7e6:43.87315;e2:45.55077;d7c6:46.338238;c7c6:47.093796;g6:49.586014;e4:53.61363;pe7:61.255875;f7e6:61.97521;f6:69.89173;e3:70.09332;b7b6:9900.0;b7a6:9900.0
Uf3 e7d6 h2g3|8|0.11465806|hc6:24.523184;uc6:26.264986;a7b6:26.923895;b7c6:29.082325;ua6:31.170654;g7:31.8251;a7a6:35.691628;re6:36.844418;he6:37.85682;g6:39.044968;c7b6:43.95051;d7e6:45.75454;re7:46.431664;c7c6:47.162006;d7c6:48.88185;e5:51.785465;e2:58.339214;pe7:58.644764;e4:59.960915;f7e6:62.51614;f6:71.78136;e3:78.31687;b7a6:9900.0;b7b6:9900.0
Uf3 e7d6 g2h3|8|0.11465806|uc6:25.19428;a7b6:25.4801;b7c6:29.119154;ua6:32.472275;hc6:33.965225;re6:35.91979;he6:36.4572;a7a6:37.52945;e5:44.555874;d7e6:45.16745;g7:45.20855;d7c6:45.238365;c7b6:45.37784;re7:46.695766;c7c6:47.642117;e2:50.246845;g6:55.5707;e4:64.23233;f6:64.25985;f7e6:65.08384;pe7:66.62765;e3:73.34931;b7a6:9900.0;b7b6:9900.0
Uf3 e7d6 h2h3|8|0.11465806|a7b6:21.036512;uc6:21.129501;hc6:23.249798;ua6:25.89179;b7c6:26.092783;a7a6:32.38963;re6:33.375412;he6:33.775124;g7:33.99746;c7b6:36.168472;g6:36.991783;c7c6:38.656963;d7e6:40.475677;e5:41.715702;d7c6:42.377743;re7:42.711193;e2:52.233402;e4:56.67057;pe7:59.863907;f6:66.105835;f7e6:66.88105;e3:72.940285;b7b6:9900.0;b7a6:9900.0
Hd3 uc6 g2f3|8|0.1120345|b7b6:20.555702;e7f6:21.309355;a7b6:21.309355;he6:22.160074;e7d6:28.249844;a7a6:29.657915;b7a6:29.728407;d7e6:34.50816;d7d6:35.12049;e7e6:36.607414;f7f6:36.994392;b8:37.807026;c7b6:39.15595;c7d6:39.6361;g6:43.119217;f7e6:48.799404;g7:71.51533
Hd3 uc6 d2c3|8|0.1120345|he6:20.550993;a7b6:22.12065;b7b6:22.646687;d7d6:23.769255;e7f6:24.900913;a7a6:24.990284;b7a6:27.317139;e7d6:28.53913;c7b6:31.391045;d7e6:31.555725;g7:33.475338;c7d6:35.457104;b8:37.331398;g6:37.99181;e7e6:38.581093;f7f6:40.777973;f7e6:46.876846
Hd3 uc6 Uf3|8|0.1120345|a7b6:20.550993;b7b6:24.142395;e7f6:24.900913;e7d6:26.149412;a7a6:27.63263;he6:31.097456;d7e6:31.247213;e7e6:32.835117;d7d6:32.96237;b7a6:33.625496;f7f6:34.056404;b8:35.237846;g7:36.481556;c7d6:37.29936;c7b6:39.711494;g6:42.602413;f7e6:47.082726
Hd3 uc6 e2e3|8|0.1120345|b7b6:18.738485;he6:19.172113;a7b6:20.549303;e7f6:23.28959;g7:26.482515;a7a6:28.148323;b7a6:29.108786;d7e6:30.646324;d7d6:30.913544;e7e6:32.885696;e7d6:33.136913;b8:36.627037;c7b6:36.627037;c7d6:37.40831;f7e6:38.97927;f7f6:41.661156;g6:57.55792
Hd3 uc6 h2g3|8|0.1120345|b7b6:18.837893;a7b6:18.98919;he6:19.76281;g7:20.979097;e7f6:22.94249;g6:30.359999;d7e6:30.646324;b7a6:32.550068;a7a6:32.71702;e7e6:32.835117;e7d6:33.136913;d7d6:33.389816;f7e6:39.04581;c7d6:39.553547;b8:39.558273;c7b6:39.558273;f7f6:41.661156
Hd3 uc6 g2g3|8|0.1120345|a7b6:17.207642;e7f6:19.808622;he6:21.70525;b7b6:24.142395;e7d6:24.686516;a7a6:24.939703;g7:26.305351;d7e6:30.373535;f7f6:30.609818;d7d6:31.322336;e7e6:31.36389;b7a6:32.95224;g6:33.938885;b8:35.112648;c7b6:35.234707;c7d6:35.25049;f7e6:39.478542
Hd3 uc6 g2h3|8|0.1120345|b7b6:16.65963;a7b6:17.24418;e7f6:17.77146;he6:19.949833;a7a6:25.563799;e7d6:28.530989;b7a6:28.713419;e7e6:29.142569;d7d6:30.43467;f7f6:31.171576;d7e6:31.78549;g7:32.841034;c7b6:33.74008;b8:34.715515;c7d6:35.0169;g6:39.677814;f7e6:44.94424
Hd3 uc6 Uh3|8|0.1120345|b7b6:15.021382;he6:17.311758;a7b6:18.669596;g7:22.749195;e7f6:23.28959;a7a6:24.821587;d7e6:25.32425;b7a6:27.398172;e7e6:28.456009;e7d6:28.933783;g6:30.592485;d7d6:30.913544;c7b6:31.488297;c7d6:32.033825;b8:32.033825;f7f6:32.663303;f7e6:39.623257
Hf3 he6|8|0.10611699|h2g3:-16.622803;d2c3:-16.646261;g2g3:-17.556484;f2g3:-21.436634;g2h3:-23.048698;Uh3:-23.82722;h2h3:-24.834234;d2e3:-27.985476;e2e3:-29.465788;e2d3:-30.148167;e1:-32.512104;c2c3:-32.725952;d2d3:-33.18538;f2e3:-33.724857;c2d3:-37.1375;b2:-54.0735;b3:-55.59638
Hf3 b7b6|8|0.10611699|d2c3:-18.00847;h2g3:-18.00847;g2g3:-18.239672;g2h3:-23.048698;Uh3:-23.82722;d2e3:-26.235672;e2d3:-26.827478;f2g3:-28.915422;e2e3:-29.465788;d2d3:-30.358551;h2h3:-31.68016;e1:-31.767353;f2e3:-34.106346;c2c3:-36.687508;c2d3:-39.865505;b2:-48.915924;b3:-67.781685
d2c3 uc6 Hd3|8|0.10156575|a7b6:20.550993;he6:20.550993;d7d6:22.176308;b7b6:22.435226;e7f6:24.900913;a7a6:24.990284;g7:25.945923;e7d6:26.149412;b7a6:27.317139;e7e6:30.565023;c7b6:31.175167;f7f6:31.372015;d7e6:31.555725;b8:33.89244;c7d6:35.457104;g6:36.0613;f7e6:45.977303
d2c3 e7f6 g2g3|8|0.10149714|b7b6:27.481047;a7b6:29.687744;hc6:29.687744;uc6:30.805897;ua6:32.82354;b7a6:33.24906;a7a6:38.227177;g7:38.467335;b7c6:38.92776;c7b6:39.18846;he6:41.065144;e5:41.594524;d7d6:42.789803;re6:42.873623;c7d6:43.496723;c7c6:45.584774;re7:46.14303;d7e6:47.902782;d7c6:48.73035;f7e6:57.93874;e2:62.13272;pe7:62.709843;e4:65.03976;e3:72.28331;g6:76.28987
    """.trimIndent()

}