package de.tadris.flang_lib.script

import de.tadris.flang_lib.Board
import de.tadris.flang_lib.bot.CFlangEngine
import de.tadris.flang_lib.bot.CFlangSocketEngine
import de.tadris.flang_lib.bot.Engine
import de.tadris.flang_lib.bot.FastNeoBoardEvaluation
import de.tadris.flang_lib.bot.fast.FastFlangBot
import de.tadris.flang_lib.fast.fast

fun main(){
    val forEveryMove = false
    val moveStep = 5
    val board = Board.fromFMN("g2g3 uc6 Uf3 g7 Kg2 h8 Ph3 f3 e2f3 d7d6 g3g4 b7b6 Kg3 he6 Ph4 kb7 f5 hc5 Pf4 pa6 Kg4 fc6 Ph5 a6a5 Pg5 ka6 h6 ph6 h6 e7e6 g5 kb5 b2 f5 h7 h7 h6 f6 g5 he4 f6 b6c5 e4 e4 Hd3 fh5 h1 d3 g3 h1 c2d3 a5b4 g4 g4 g5 d7 g4 d5 f5 pd6 e6 c6 f6 c5c4 c4 c4 e6 b3 f6 kd5 f5 b2 e3")
    println(board.getFBN2())
    val depth = 12

    //val engine: Engine = FastFlangBot(depth, depth, false, { FastNeoBoardEvaluation() }, ttSizeMB = 1024)
    val engine: Engine = CFlangEngine(minDepth = 1, maxDepth = depth, ttSizeMB = 2048, threads = Runtime.getRuntime().availableProcessors())

    fun showForBoard(board: Board){
        val result = engine.findBestMoveWithFixedDepth(board, true, depth)
        println(result)
    }

    val start = System.currentTimeMillis()
    if(forEveryMove){
        var counter = 0
        board.moveList.forEachGameState { step, _ ->
            if(counter % moveStep == 0){
                showForBoard(step)
            }
            counter++
        }
    }else{
        showForBoard(board)
    }
    val time = System.currentTimeMillis() - start
    println("\nTotal time: $time ms")
}