package de.tadris.flang_lib.script

import de.tadris.flang_lib.Board
import de.tadris.flang_lib.bot.FastNeoBoardEvaluation
import de.tadris.flang_lib.fast.fast

fun main(){
    val eval = FastNeoBoardEvaluation()
    val board = Board.fromFBN2("+2PRHFUK2PPPP1P7P-24pppppp2kufhrp2")
    board.printBoard()

    println(board.getFBN2() + " -> ${eval.evaluate(board.fast())}")

    board.moveList.forEachGameState { state, _ ->
        val eval = eval.evaluate(state.fast())
        println(state.getFBN2() + " -> $eval")
    }

}