package de.tadris.flang_lib.script

import de.tadris.flang_lib.Board
import de.tadris.flang_lib.bot.FlangBot
import de.tadris.flang_lib.bot.NeoBoardEvaluation

fun main(){

    val maxDepth = 6
    val board = Board.fromFMN("b2 b7a6 b3")
    val eval = NeoBoardEvaluation()
    fun Board.findBestMove(depth: Int) =
        FlangBot(depth, depth, evaluation = eval).findBestMove(this, printTime = false)

    val result = board.findBestMove(maxDepth)
    result.evaluations.forEachIndexed { index, moveEvaluation ->
        print("${index + 1}. ${moveEvaluation.move}")
        val boardCopy = board.clone(true)
        boardCopy.executeOnBoard(moveEvaluation.move)
        for(depth in (maxDepth - 1) downTo 1){
            val nextMove = boardCopy.findBestMove(depth).bestMove.move
            print(" -> $nextMove")
            boardCopy.executeOnBoard(nextMove)
        }
        println()
    }

}