package de.tadris.flang_lib.bot.fast

import de.tadris.flang_lib.Board
import de.tadris.flang_lib.bot.FastNeoBoardEvaluation
import de.tadris.flang_lib.bot.NeoBoardEvaluation
import de.tadris.flang_lib.bot.ParallelFlangBot

/**
 * Debug test to compare move selection between original and fast bot
 */
fun main() {
    println("Debug: Comparing move selection consistency")
    println("=" * 50)
    
    // Create a default board
    val board = Board.fromFMN("Uf3 uc6 Hd3 a7b6 Kg1 ka7 Pb2 c2 Rc1 pa6 e2e3 a4 g2g3 d7e6 Kg2 d3 d3 b2 Rc2 g7 e3d4 ub5 Pc4 pc6 Kh3 uf5 a3 f7g6 f5 f5 b4 he6 e5 c6c5 a4 hg5 c5 c8 Kh4")
    println("Board FBN: ${board.getFBN2()}")
    println()
    
    // Test multiple times to check consistency
    repeat(50) { i ->
        println("Test Run ${i + 1}:")
        
        // Original bot
        val originalBot = ParallelFlangBot(
            minDepth = 6,
            maxDepth = 6, // Reduced depth for faster testing
            evaluationFactory = { NeoBoardEvaluation(board) }
        )
        
        val result1 = originalBot.findBestMove(board, printTime = false)
        println("Original: ${result1.bestMove.move} (${result1.bestMove.evaluation})")
        
        // Fast bot
        val fastBot = FastFlangBot(
            minDepth = 6,
            maxDepth = 6,
            evaluationFactory = { FastNeoBoardEvaluation() },
            ttSizeMB = 8
        )
        
        val result2 = fastBot.findBestMoveIterative(board, printTime = false)
        println("Fast:     ${result2.bestMove.move} (${result2.bestMove.evaluation})")
        
        val movesMatch = result1.bestMove.move.toString() == result2.bestMove.move.toString()
        println("Moves match: $movesMatch")
        println("Eval diff: ${kotlin.math.abs(result1.bestMove.evaluation - result2.bestMove.evaluation)}")
        println()
        
        // Clear TT for next run
        //fastBot.clearTranspositionTable()
    }
    
    println("Debug test completed!")
}

private operator fun String.times(n: Int): String = this.repeat(n)