package de.tadris.flang_lib


class Location(val board: Board, x: Int, y: Int) : Vector(x, y) {

    val piece get() = board.getAt(this)

    fun getMovesToHere() = board.findAllMoves(board.atMove).filter { it.target == this }

    override fun add(other: Vector): Location {
        return Location(board, x+other.x, y+other.y)
    }

    override fun toLocation(board: Board): Location {
        return if(board === this.board) this else Location(board, x, y)
    }
}