package de.tadris.flang.game

import android.app.Activity
import de.tadris.flang_lib.Board
import de.tadris.flang_lib.action.Move

class PersistentAnalysisGameController(activity: Activity, active: Boolean) : AnalysisGameController(activity, Board(), active) {

    private val gameStateManager = GameStateManager(activity)

    init {
        // Load saved board state
        board = gameStateManager.loadGameState()
    }

    override fun onMoveRequested(move: Move, newBoardRequest: Board?, onCancel: (() -> Unit)?) {
        super.onMoveRequested(move, newBoardRequest, onCancel)
        // Save board state after each move
        gameStateManager.saveGameState(board)
    }

    override fun resignGame() {
        super.resignGame()
        // Save board state after resignation
        gameStateManager.saveGameState(board)
    }

    fun clearSavedState() {
        gameStateManager.clearGameState()
    }
}