package de.tadris.flang.game

import android.content.Context
import de.tadris.flang_lib.Board
import androidx.core.content.edit

class GameStateManager(private val context: Context) {

    companion object {
        private const val PREF_NAME = "play_over_board_game"
        private const val KEY_BOARD_STATE = "board_state_fmn2"
    }

    fun saveGameState(board: Board) {
        val prefs = context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE)
        val fmn2 = board.getFMN2()
        prefs.edit { putString(KEY_BOARD_STATE, fmn2) }
    }

    fun loadGameState(): Board {
        val prefs = context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE)
        val savedFMN2 = prefs.getString(KEY_BOARD_STATE, null)
        
        return if (savedFMN2 != null) {
            try {
                Board.fromFMN(savedFMN2)
            } catch (e: Exception) {
                // If loading fails, return default board
                e.printStackTrace()
                Board()
            }
        } else {
            Board()
        }
    }

    fun clearGameState() {
        val prefs = context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE)
        prefs.edit { remove(KEY_BOARD_STATE) }
    }
}