package de.tadris.flang_lib.script

import de.tadris.flang_lib.Board
import de.tadris.flang_lib.bot.FastNeoBoardEvaluation
import de.tadris.flang_lib.bot.FlangBot
import de.tadris.flang_lib.bot.NeoBoardEvaluation
import de.tadris.flang_lib.bot.fast.FastFlangBot
import kotlin.math.absoluteValue
import kotlin.math.roundToInt

fun main(){
    var moveScoreErrorSum = 0.0
    var totalScores = 0
    var correctBestMove = 0
    var totalResults = 0

    var totalTimeBase = 0L
    var totalTimeTest = 0L

    val base = FastFlangBot(4, 5, false, { FastNeoBoardEvaluation() }, ttSizeMB = 1024, threads = 1)
    val test = FastFlangBot(4, 5, false, { FastNeoBoardEvaluation() }, ttSizeMB = 1024, threads = 1, useLMR = true, useNullMovePruning = true)

    val board = Board.fromFMN("g2g3 b7b6 Kg2 g7 b2 he6 b3 b3 b1 uc6 b3 b7 f2f3 h8 Ue3 pb5 c3 a7b6 Hc2 c7d6 g3g4 f7g6 Hd4 uc5 Pd3 e5 e6 e3 f2 d7e6 e3 h2 f3e4 d5 d3d4 e4 Fe4 e4 e4 c6 Ke5 e2 e1 pc5 f4 e1 c5 c5 f3 d5 f2 ke4 e1 d3 d1 d3c3")

    var counter = 0
    board.moveList.forEachGameState { step, _ ->
        if(counter % 5 == 0){
            val startBase = System.currentTimeMillis()
            val result1 = base.findBestMove(step)
            totalTimeBase += System.currentTimeMillis() - startBase
            val startTest = System.currentTimeMillis()
            val result2 = test.findBestMove(step)
            totalTimeTest += System.currentTimeMillis() - startTest

            result1.evaluations.forEach { eval ->
                val result2Eval = result2.evaluations.find { it.move == eval.move }!!
                moveScoreErrorSum += (result2Eval.evaluation - eval.evaluation).absoluteValue
                totalScores++
            }
            if(result1.bestMove.move == result2.bestMove.move){
                correctBestMove++
            }
            totalResults++
        }
        counter++
    }
    println("\n===============================")
    println("Average evaluation error: " + (moveScoreErrorSum / totalScores))
    println("Best move accuracy: " + (correctBestMove * 100.0 / totalResults).roundToInt() + "%")

    println("\nTotal time base: $totalTimeBase ms")
    println("Total time test: $totalTimeTest ms")
}