package de.tadris.flang_lib.script

import de.tadris.flang_lib.Board
import de.tadris.flang_lib.bot.FastNeoBoardEvaluation
import de.tadris.flang_lib.bot.fast.FastFlangBot

fun main(){
    val forEveryMove = false
    val moveStep = 5
    val board = Board.fromFMN("g2f3 b7a6 b2 c2 c2 kb7 Kg2 kc6 Kh3 b2 h4 kb5 h5 ub4")

    fun showForBoard(board: Board){
        val result = FastFlangBot(4, 4, false, { FastNeoBoardEvaluation() }, ttSizeMB = 1024, useLME = true, lmeMaxExtension = 1)
            .findBestMove(board)
        println(result)
    }

    val start = System.currentTimeMillis()
    if(forEveryMove){
        var counter = 0
        board.moveList.forEachGameState { step, _ ->
            if(counter % moveStep == 0){
                showForBoard(step)
            }
            counter++
        }
    }else{
        showForBoard(board)
    }
    val time = System.currentTimeMillis() - start
    println("\nTotal time: $time ms")
}