package de.tadris.flang_lib.fast

import de.tadris.flang_lib.Type

typealias FastType = Byte

const val FAST_NONE: Byte = 0
const val FAST_PAWN: Byte = 1
const val FAST_HORSE: Byte = 2
const val FAST_ROOK: Byte = 3
const val FAST_FLANGER: Byte = 4
const val FAST_UNI: Byte = 5
const val FAST_KING: Byte = 6

val FastType.hasDoubleMoves get() = this == FAST_FLANGER

val FastType.hasFreeze get() = this != FAST_NONE && this != FAST_KING

val FastType.moves get() = when(this){
    FAST_PAWN -> Type.PAWN.moves
    FAST_HORSE -> Type.HORSE.moves
    FAST_ROOK -> Type.ROOK.moves
    FAST_FLANGER -> Type.FLANGER.moves
    FAST_UNI -> Type.UNI.moves
    FAST_KING -> Type.KING.moves
    else -> throw Exception("Unknown type $this")
}

val FastType.pieceValue get() = when(this){
    FAST_PAWN -> Type.PAWN.value
    FAST_HORSE -> Type.HORSE.value
    FAST_ROOK -> Type.ROOK.value
    FAST_FLANGER -> Type.FLANGER.value
    FAST_UNI -> Type.UNI.value
    FAST_KING -> Type.KING.value
    else -> throw Exception("Unknown type $this")
}