package de.tadris.flang_lib.script

import de.tadris.flang_lib.Board
import de.tadris.flang_lib.bot.FastNeoBoardEvaluation
import de.tadris.flang_lib.fast.fast

fun main(){
    val eval = FastNeoBoardEvaluation()
    val board = Board.fromFMN("g2g3 b7b6 Kg2 g7 b2 he6 b3 b3 b1 uc6 b3 b7 f2f3 h8 Ue3 pb5 c3 a7b6 Hc2 c7d6 g3g4 f7g6 Hd4 uc5 Pd3 e5 e6 e3 f2 d7e6 e3 h2 f3e4 d5 d3d4 e4 Fe4 e4 e4 c6 Ke5 e2 e1 pc5 f4 e1 c5 c5 f3 d5 f2 ke4 e1 d3 d1 d3c3")

    board.moveList.forEachGameState { state, _ ->
        val eval = eval.evaluate(state.fast())
        println(state.getFBN2() + " -> $eval")
    }

}