package de.tadris.flang_lib.bot

import de.tadris.flang_lib.fast.FastBoard

/**
 * Can evaluate instances of [FastBoard]. Similar to [BoardEvaluation] but uses [FastBoard].
 */
interface FastBoardEvaluation {

    /**
     * Evaluates the board and gives an estimation of how good the position is for white or black.
     * Note: this method is not Thread-safe and may only be called after another call has been completed.
     * @return evaluation in centipawns
     */
    fun evaluate(board: FastBoard): Double

}