package android.util;

/**
 * Mock implementation for android.util.Log
 *
 * @noinspection unused
 */
public class Log {
    public static int d(String tag, String msg) {
        System.out.println("DEBUG: " + tag + ": " + msg);
        return 0;
    }

    public static int i(String tag, String msg) {
        System.out.println("INFO: " + tag + ": " + msg);
        return 0;
    }

    public static int w(String tag, String msg) {
        System.out.println("WARN: " + tag + ": " + msg);
        return 0;
    }

    public static int e(String tag, String msg) {
        System.out.println("ERROR: " + tag + ": " + msg);
        return 0;
    }

    public static boolean isLoggable(String tag, int level) {
        return true;
    }

    public static int println(int priority, String tag, String msg) {
        return switch (priority) {
            case 2 -> // DEBUG
                    d(tag, msg);
            case 3 -> // INFO
                    i(tag, msg);
            case 4 -> // WARN
                    w(tag, msg);
            case 5 -> // ERROR
                    e(tag, msg);
            default -> 0; // Unknown priority
        };
    }
}