package de.storchp.fdroidbuildstatus.utils

import android.view.View
import androidx.core.graphics.Insets
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat

fun View.addInsetsListener(
    types: List<Int> = listOf(
        WindowInsetsCompat.Type.systemBars(),
        WindowInsetsCompat.Type.displayCutout()
    ),
    apply: View.(Insets) -> Unit
) {
    ViewCompat.setOnApplyWindowInsetsListener(this) { v, insets ->
        val typeMask = types.fold(0) { acc, type ->
            acc or type
        }
        v.apply(insets.getInsets(typeMask))
        insets
    }
}
