package de.storchp.fdroidbuildstatus

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.RelativeLayout
import de.storchp.fdroidbuildstatus.databinding.ActivityDetailMetadataBinding
import de.storchp.fdroidbuildstatus.model.App
import de.storchp.fdroidbuildstatus.utils.DrawableUtils

class DetailsMetadataView(
    context: Context,
    attrs: AttributeSet?,
    defStyleAttr: Int,
    defStyleRes: Int
) : RelativeLayout(context, attrs, defStyleAttr, defStyleRes) {

    val binding =
        ActivityDetailMetadataBinding.inflate(LayoutInflater.from(context), this, true)

    @JvmOverloads
    constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : this(
        context = context,
        attrs = attrs,
        defStyleAttr = defStyleAttr,
        defStyleRes = 0
    )

    fun setApp(app: App) {
        binding.appName.text = app.name
        binding.appId.text = app.id
        DrawableUtils.setIconWithTint(
            context,
            binding.disabledIcon,
            R.drawable.ic_disabled_24dp,
            binding.appName.currentTextColor
        )
        DrawableUtils.setIconWithTint(
            context,
            binding.archivedIcon,
            R.drawable.ic_archive_24,
            binding.appName.currentTextColor
        )
        DrawableUtils.setIconWithTint(
            context,
            binding.noPackagesIcon,
            R.drawable.ic_no_packages_24,
            binding.appName.currentTextColor
        )
        DrawableUtils.setIconWithTint(
            context,
            binding.noUpdateCheckIcon,
            R.drawable.ic_no_update_check_24,
            binding.appName.currentTextColor
        )
        DrawableUtils.setIconWithTint(
            context,
            binding.needsUpdateIcon,
            R.drawable.ic_upgrade_24dp,
            binding.appName.currentTextColor
        )
        setFavoriteIcon(app)
        binding.disabledIcon.visibility =
            if (app.disabled) VISIBLE else GONE
        binding.archivedIcon.visibility =
            if (app.archived) VISIBLE else GONE
        binding.noPackagesIcon.visibility =
            if (app.noPackages) VISIBLE else GONE
        binding.noUpdateCheckIcon.visibility =
            if (app.noUpdateCheck) VISIBLE else GONE
        binding.needsUpdateIcon.visibility =
            if (app.needsUpdate) VISIBLE else GONE
    }

    fun setFavoriteIcon(app: App) {
        DrawableUtils.setIconWithTint(
            context,
            binding.favouriteIcon,
            app.favouriteIcon,
            binding.appName.currentTextColor
        )
    }

    fun setMetadataVersion(value: String?) {
        binding.metadataVersion.text = value
    }

    fun setPublishedVersions(value: String?) {
        binding.publishedVersions.text = value
    }

    fun setAppName(value: String?) {
        binding.appName.text = value
    }

    fun setFavouriteOnClickListener(onClickListener: (View) -> Unit) {
        binding.favouriteIcon.setOnClickListener(onClickListener)
    }
}