// SPDX-License-Identifier: GPL-3.0-or-later

package de.sesu8642.feudaltactics.menu.common.ui;

/**
 * Constants for names used in the skin.
 */
public final class SkinConstants {

    public static final String FONT_HEADLINE = "headline";
    public static final String FONT_OVERLAY = "overlay";
    public static final String FONT_OVERLAY_WITH_BACKGROUND = "overlay_w_bg";
    public static final String FONT_HEXAGON = "bestagon";
    public static final String COLOR_HIGHLIGHT2 = "highlight2";
    public static final String COLOR_DISABLED = "disabled";
    public static final String COLOR_BACKGROUND = "background";
    public static final String SEMI_TRANSPARENT_BACKGROUND_DRAWABLE = "black_semi_transparent";
    public static final String BUTTON_SPEED_HALF = "half_speed";
    public static final String BUTTON_SPEED_REGULAR = "regular_speed";
    public static final String BUTTON_SPEED_DOUBLE = "double_speed";
    public static final String BUTTON_UNDO = "undo";
    public static final String BUTTON_BUY_PEASANT = "buy_peasant";
    public static final String BUTTON_BUY_CASTLE = "buy_castle";
    public static final String BUTTON_END_TURN = "end_turn";
    public static final String BUTTON_SKIP_TURN = "skip_turn";
    public static final String BUTTON_PAUSE = "pause";
    public static final String BUTTON_INFO = "info";
    public static final String BUTTON_DIE = "die";
    public static final String BUTTON_COPY = "copy";
    public static final String BUTTON_COPY_TICK = "copy_tick";
    public static final String BUTTON_COPY_NO_BACKGROUND = "copy_no_background";
    public static final String BUTTON_COPY_TICK_NO_BACKGROUND = "copy_tick_no_background";
    public static final String BUTTON_PASTE = "paste";
    public static final String SPRITE_HAND = "hand";
    public static final String SPRITE_HAND_THUMB = "hand_thumb";
    public static final String SELECT_BOX_STYLE_COLOR_SELECT = "colorselect";

    private SkinConstants() {
        // prevent instantiation
        throw new AssertionError();
    }

}
