# アプリの制限

AirGuardはBluetoothベースのトラッカーのみを検出できます。GPSを使用し、モバイル通信を介して所有者と位置情報を共有するトラッカーは検出できません。

AirGuardは多種多様なトラッカーを検出できますが、音を鳴らす、所有者を特定する、またはデバイスが現在所有者と接続されているかを確認するなどの高度な機能は、メーカーによって異なります。

**Google「デバイスを探す」対応デバイス**
これらはGoogleの「デバイスを探す」ネットワークと互換性のあるトラッカーです。
* **所有者と接続中:** ✅ (所有者が近くにいるか判定します)
* **音を鳴らす:** ✅
* **所有者の特定:** ✅

**Apple AirTag & 「探す」対応デバイス**
これには、AirTag、AirPods、およびAppleの「探す」ネットワークを使用するサードパーティ製トラッカー（ChipoloやPebblebeeなど）が含まれます。
* **所有者と接続中:** ✅ (所有者が近くにいるか判定します)
* **音を鳴らす:** ✅ (利用可能性は特定のデバイスモードに依存します)
* **所有者の特定:** ✅ (AirTagおよび対応する「探す」デバイスのNFC経由)

**Samsung SmartTags**
これらはSamsungによって製造されたトラッカーです。
* **所有者と接続中:** ✅ (所有者が近くにいるか判定します)
* **音を鳴らす:** ❌
* **所有者の特定:** ❌

**Tileトラッカー**
TileはBluetoothトラッカーを専門に製造する会社です。
* **所有者と接続中:** ❌
* **音を鳴らす:** ❌
* **所有者の特定:** ❌

**Chipoloトラッカー (「探す」非対応)**
これらは、Appleの「探す」ネットワークの一部ではない、Chipoloの標準的なBluetoothトラッカーです。
* **所有者と接続中:** ✅ (一部のモデルでサポート)
* **音を鳴らす:** ❌
* **所有者の特定:** ❌

**Pebblebee (「探す」非対応)**
これらは、Appleの「探す」ネットワークの一部ではない、Pebblebeeの標準的なBluetoothトラッカーです。
* **所有者と接続中:** ❌
* **音を鳴らす:** ✅
* **所有者の特定:** ❌

### 追加の技術的制限

**接続ステータス**
現在、すべての種類のトラッカーについて、所有者と接続されているかどうかを判断することはできません。トラッカーがこの機能をサポートしていない場合（例：Tile）、所有者が近くにいてもAirGuardはそれを除外できません。そのため、自分や友人のトラッカーが頻繁に表示される場合があります。

**ランダム化された識別子**
一部のBluetoothトラッカーは、定期的（時には1日に数回）にその身元（Bluetooth MACアドレス）を変更します。
これらのランダム化されたIDを常に照合できるとは限らないため、AirGuardは同じトラッカーを時間の経過とともに複数の異なるエントリとして表示する場合があります。識別を変更しないトラッカー（例：Tile）はより一貫して検出されますが、頻繁に近くにいる場合、誤検出の可能性が高くなる可能性があります。