# よくある質問 (FAQ)

## 一般および主要機能

**どのような種類のトラッカーを検出できますか？**
現在、Google「デバイスを探す」デバイス、Apple AirTag、AirPods、「探す」対応デバイス、紛失モードのその他のAppleデバイス、Samsung SmartTags、Chipolo、およびTileなど、さまざまなトラッカーを検出しています。

**AirGuardはどれくらいのバッテリーを使用しますか？**
AirGuardは電力効率が良いように設計されています。通常の使用では、バッテリー寿命に大きな違いを感じることはありません。通常、バッテリーの1％未満しか使用しません。

**AirGuardはずっと無料ですか？**
はい、AirGuardは無期限に無料で提供する予定です。

## 検出について理解する

**近くにトラッカーを見つけたらどうすればいいですか？**
手動検索でエリア内のトラッカーに気付いても、すぐに心配しないでください。これらのトラッカーは単に近くにあるだけで、必ずしもあなたを追跡しているわけではありません。私たちのアプリ、AirGuardは、これらのトラッカーのいずれかがあなたと一緒に移動している場合に警告します。そうでない場合、通常は心配する必要はありません。

**白いデバイスと灰色のデバイスの違いは何ですか？**
白いデバイス（ダークモードでは黒）は「オフライン」モードにあり、所有者から切断されています。これらは追跡の脅威となる可能性があります。私たちはそれらの場所を保存し、それらがあなたを追跡していると思われる場合に警告します。灰色のデバイスは接続されているか、最近所有者のデバイスに接続されていました。それらは一般的に安全であり、アプリには保存されません。

**「接続されたデバイス」とはどういう意味ですか？**
接続されたデバイスとは、現在または最近（15分以内）に所有者のデバイスに接続されたデバイスのことです。これらは所有者の近くにありリスクがないため、アプリには保存されません。

**所有者に接続されたデバイスは安全ですか？**
はい、所有者にリンクされたデバイスは、独立して位置データを送信できないため安全です。これにより、不要な追跡やストーカー行為には適していません。

**なぜ接続されたデバイスのデータを保存しないのですか？**
接続されたデバイスは通常、所有者と一緒に移動しているため、追跡の脅威ではありません。たとえば、電車の中で誰かがiPhoneとバッグの中にAirTagを持っている場合、警告は届きません。AirTagはあなたを追跡していないと想定します。しかし、近くにiPhoneがない場合、AirTagは懸念事項になる可能性があります。

**なぜ一部のトラッカーが2回表示されるのですか？**
トラッカーは定期的にBluetooth IDを変更する場合があるため、2回表示されることがあります。これにより、一貫して追跡することが難しくなり、重複したリストにつながります。

**なぜアプリで自分のAirTagが常に表示されないのですか？**
時々、あなたのAirTagがアプリに表示されない場合があります。ただし、他の人のApple IDにリンクされており、あなたのデバイスに接続されていない場合は常に表示されます。

## 追跡アラートとリスク

**アプリはどのように追跡リスクを評価しますか？**
アプリは追跡リスクレベル（リスクなし、中リスク、高リスク）を計算します。これは、追跡デバイスがあなたの近くにいた頻度や場所など、いくつかの要因に基づいています。高リスクが常に追跡されていることを意味するわけではないため、常にトラッカーのマップを確認してください。

**追跡アラートを受け取った場合、どのような手順を踏むべきですか？**
1. 手動でトラッカーを探します。
2. 可能であれば、音を鳴らして見つけます。
3. アプリのマップを調べて、どれくらいの期間あなたを追跡しているかを確認します。
4. トラッカーを無効にするか、バッテリーを取り外します。取り外せない場合（Tileトラッカーなど）は、アルミホイルで包んで信号を弱めます。
5. トラッカーを持って警察に通報します。
6. トラッカーが無効になるまで、自宅などの安全な場所に行かないでください。

**アラートの後にトラッカーが見つからない場合はどうすればよいですか？**
特に公共交通機関などの混雑した場所では、誤報が発生する可能性があります。別の日に繰り返しアラートを受け取る場合は、再確認してください。音機能、信号強度インジケーター、または詳細スキャンを利用してデバイスを特定します。

**なぜトラッカーの音を鳴らすのに問題が生じる可能性があるのですか？**
この問題は、トラッカーから遠すぎる場合に発生する可能性があります。近づいて、信号強度または詳細スキャンを使用して見つけるのを助けてください。検索中にトラッカーが範囲外に移動したり、所有者に接続したりした場合にも、問題が発生する可能性があります。時々、トラッカーは内部状態に応じて音を鳴らさないことを決定する場合もあります。

## アプリ設定とデバイス管理

**設定の「検出感度」は何をしますか？**
この設定は、トラッカーがリスクと見なされる前にあなたを追跡する必要がある期間を調整します。感度が低いということは、より長く追跡する必要があることを意味します。感度が高いと、デバイスをより早くフラグ付けします。

**省電力スキャンモードを有効にすることの影響は何ですか？**
このモードはスキャン頻度を減らし、エネルギーを節約しますが、検出効果を低下させます。一部のリスクのあるデバイスを見逃す可能性があります。より良い安全性のために、通常のモードを使用することをお勧めします。これは最新の電話ではバッテリーを大幅に消耗しません。

**アプリの位置情報アクセスを制限するとどうなりますか？**
位置情報アクセスがない場合、アプリはBluetoothスキャンのみに依存します。トラッカーに対するあなたの動きを追跡できないため、誤報が増える可能性があります。より正確なアラートのために、位置情報アクセスを許可することをお勧めします。

**自分のトラッカーを無視したりラベルを付けたりできますか？**
現在、技術的な制限により、Tileブランドのトラッカーのみを無視できます。トラッカーにラベルを付けることはできますが、同じトラッカーがIDを変更し、新しいトラッカーとして認識される可能性があることに注意してください。後で識別するためだけに名前を付けることをお勧めします。

**なぜ一部のデバイスを無視できないのですか？**
識別子を頻繁に変更するデバイスは無視できません。それらがキーを変更すると、私たちのシステムはそれらを新しいデバイスとして扱い、新しいアラートをトリガーします。一部のデバイス（Samsung SmartTagsなど）は頻繁にキーを変更しますが、変更しないもの（ChipoloやTileなど）は無視できます。