<h5 align="center"><img src="https://github.com/seemoo-lab/AirGuard/blob/main/fastlane/metadata/android/en-US/images/icon.png" width="200px"></h5>
<h1 align="center">AirGuard - AirTag tracking protection</h1>

<p align="center">
  <a href="https://github.com/seemoo-lab/AirGuard/releases">
    <img src="https://img.shields.io/github/release/seemoo-lab/AirGuard.svg?logo=github" />
  </a>
  <a href="https://f-droid.org/packages/de.seemoo.at_tracking_detection">
    <img src="https://img.shields.io/f-droid/v/de.seemoo.at_tracking_detection.svg" />
  </a>
  <a href="https://play.google.com/store/apps/details?id=de.seemoo.at_tracking_detection.release">
    <img src="https://img.shields.io/endpoint?color=green&logo=google-play&logoColor=green&url=https%3A%2F%2Fplay.cuzi.workers.dev%2Fplay%3Fi%3Dde.seemoo.at_tracking_detection.release%26l%3DGoogle%2520Play%26m%3D%24version" />
  </a>
  <img src="https://github.com/seemoo-lab/AirGuard/actions/workflows/android.yml/badge.svg" />
 </p>

<p align="center">
  <img src="https://github.com/seemoo-lab/AirGuard/raw/main/fastlane/metadata/android/en-US/images/phoneScreenshots/1_en-US.png" width=200px>
  <img src="https://github.com/seemoo-lab/AirGuard/raw/main/fastlane/metadata/android/en-US/images/phoneScreenshots/2_en-US.png" width=200px>
  <img src="https://github.com/seemoo-lab/AirGuard/raw/main/fastlane/metadata/android/en-US/images/phoneScreenshots/3_en-US.png" width=200px>
  <img src="https://github.com/seemoo-lab/AirGuard/raw/main/fastlane/metadata/android/en-US/images/phoneScreenshots/4_en-US.png" width=200px>
</p>

**Protect yourself from Find My Tracking**

The AirTags and other Find My devices are simple, small and perfect to track Android users! 
Without tracking warnings, as integrated on iOS, anyone could try to track your behavior by placing an AirTag in your jacket, backpack or car. 

With AirGuard you get the anti-tracking protection you deserve! 
The app periodically scans your surroundings for potential tracking devices, like AirTags or other Find My devices. 
If a devices follows you, you will get a notification in less than an hour! 

With the app you can play a sound on AirTags and find it easily. Afterward, you can view at which locations the device has tracked you. 

If no one is trying to track you, the app will never bother you.

## Get the app 
The app is available on [Google Play](https://play.google.com/store/apps/details?id=de.seemoo.at_tracking_detection.release), [F-Droid](https://f-droid.org/packages/de.seemoo.at_tracking_detection) or download it here from the GitHub releases.

<a href='https://play.google.com/store/apps/details?id=de.seemoo.at_tracking_detection.release' target="_blank" rel="noopener noreferrer">
  <img alt='Get it on Google Play' src='https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png' height="80"/>
</a>
<a href="https://f-droid.org/packages/de.seemoo.at_tracking_detection" target="_blank" rel="noopener noreferrer">
    <img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
    alt="Get it on F-Droid"
    height="80">
</a>

## Details 

###  Who are we?
We are part of the Technical University of Darmstadt in Germany. This project is part of a scientific research from the Secure Mobile Networking Lab. Our goal is to protect privacy and to find out how many people are opposed to tracking.
In this app you can voluntarily participate in a research study that will share anonymized data with us.

This app will never get monetized by showing ads, in-app purchases or anything else.

### How does it work? 

AirGuard uses Bluetooth scans of your Android phone to find AirTags and Find My trackers. Every tracker that is found will be saved locally on your device. 
Whenever a tracker gets detected multiple times the app will recognize this. It compares the locations where the tracker has been detected. 
If a tracker is detected at least 3 times and the locations have changed (to make sure its not your neighbour) the app sends you a notification. 
If this tracker is an AirTag you can play a sound to find it. 

All this happens locally on your device and the private information, like location, tracker ids, etc will never leave your device. 

### Disclaimer
AirTag, FindMy and iOS are trademarks of Apple Inc.
We are not working together with Apple Inc.
