## Privacy policy
This project is part of a scientific thesis to earn the degree of Bachelor of Science. To protect private data, we have used the Minimal Data Usage principle and the Offline First principle. Accordingly, all personal data is stored only locally on the device. In addition, we do not collect any data that is not necessary for the use of the app.

## Responsibility
Responsible for the development of the app and the our study server is *Niklas Bittner*, student of computer science at the Technical University of Darmstadt. The main supervisor of this work is *Alexander Matern, M.Sc* as a PhD student and research assistant at the Technical University of Darmstadt at the Secure Mobile Networking Lab.

Address: Alexander Matern
Pankratiusstraße 2,
64289 Darmstadt

## Study
There is also the **voluntary** possibility to participate in a scientific study. In this study we would like to find out how often people are threatened by tracking (stalking). Whether Apple's Find My devices are actually used for tracking people. And ultimately, how well we can protect people from this through our app. 

In case of consent, the app then sends anonymized data to our server, which is later analyzed and published as part of the study. With the help of this data, it is not possible for us to identify participants in the study.

## Data collection
Unless you participate in the study, all data generated is stored only on your device and cannot be viewed by us. This includes the following types of data:

* Location data (if consented is given).
* Found tracking device (e.g AirTags)
  * MAC address of the devices
  * Content of the sent Bluetooth advertisements
  * When was the device first found
  * When was the device found last

In case of voluntary participation in the study, only anonymized data is collected, which does not allow us to identify participants, even if we have only one participant. The following data will be collected anonymously:

* Information about found tracking devices
  * 1 status byte from the Bluetooth advertisements
  * Indicates current charge level and whether it is an AirTag/Find My device or other Apple device
  * Whether the device was ignored by you
  * Whether you can connect to the device (to play the sound)
  * Dates when a device was found
  * Broadcast strength
* Notifications
  * Date of the notification
  * If the notification was classified as a false alarm
* Optional feedback
  * If you have found a device which tracks you you can tell us where

**This app does not include advertisements to users, ad libraries or tracking frameworks. Your data will never be shared with a third party**

## Data access 

The app accesses your location data (if consent is given) through the Android location services. 
Furthermore, we use the Bluetooth Android API to scan for nearby devices. We filter our scans so we only find those Bluetooth devices that are sending AirTag / Find My messages. 

## Data storage and usage 
We store our study data on a server hosted at the Technical University of Darmstadt. Only the two responsible persons have access to it.

The data on your device is not accessible to other apps.

## Purpose of usage
The data on your device is necessary for the app to work.

The data on the server is only for voluntary participation in our study.

## Sharing of user data 
Identifiable user data is not shared with ourselves and not with any third party. 

Anonymized user data gathered during our study can be published in an aggregated form. This data does not allow to identify any user. 

## Duration of storage 

The app's local data is stored as long as the app is installed. 

The data that is part of the study will be published when the study is completed. 

## Rights of the users

### Information
According to the GDPR, there is a right to information. This allows you to view your personal data processed by any organization. 
However, since we do not store or process personal data, we cannot show it to you.

### Deletion of data
To delete all personal data, it is sufficient to delete the app. Data that was collected voluntarily for the purpose of the study cannot be deleted, as it is not identifiable.

### Right of objection
You have the right to object to the use of the data. If you no longer wish to participate in the study, simply deactivate the corresponding setting.

## Other
AirTag, FindMy, iPhone, etc are trademarks protected by Apple.
