# FAQ

## General & Core Function

**What types of trackers can you detect?**
We currently detect various trackers, including Apple AirTags, AirPods, FindMy devices, other Apple devices in Lost Mode, Samsung SmartTags, Chipolos, and Tiles.

**How much battery does AirGuard use?**
AirGuard is designed to be power-efficient. With typical usage, you won't notice a significant difference in battery life; it usually uses less than 1% of your battery.

**Will AirGuard always be free?**
Yes, we plan to keep AirGuard free indefinitely.

## Understanding Detections

**What should I do if I see trackers nearby?**
If you notice trackers in your area through a manual search, don't worry immediately. These trackers are simply close by and not necessarily following you. Our app, AirGuard, will alert you if any of these trackers are moving with you. If they're not, it's usually nothing to be concerned about.

**What's the difference between white and gray devices?**
White devices (or black in dark mode) are in "offline" mode, disconnected from their owner. These can be tracking threats. We save their locations and alert you if they seem to be following you. Gray devices are connected or were recently connected to their owner's device. They're generally safe and aren't saved in the app.

**What does 'connected device' mean?**
A connected device is one currently or recently (within 15 minutes) connected to its owner's device. These aren't saved in the app as they pose no risk, being near their owner.

**Are devices connected to their owners safe?**
Yes, devices linked to their owners are safe because they can't independently send location data. This makes them unsuitable for unwanted tracking or stalking.

**Why don't you save data on connected devices?**
Connected devices are usually traveling with their owner, so they aren't a tracking threat. For example, if someone on the train has an iPhone and an AirTag in their bag, you won't get an alert. We assume the AirTag isn't tracking you. But if there's no iPhone nearby, the AirTag might be a concern.

**Why are some trackers listed twice?**
Trackers may appear twice because they can change their Bluetooth identity periodically. This makes it hard to consistently track them, leading to duplicate listings.

**Why don't I always see my AirTags in the app?**
Sometimes, your AirTags might not show up in the app. However, they are always visible if linked to someone else's Apple ID and not connected to your device.

## Tracking Alerts & Risks

**How does the app assess tracking risk?**
The app calculates tracking risk levels: no risk, medium risk, and high risk. This is based on several factors, including how often and where the tracking device has been near you. High risk doesn't always mean you're being tracked, so always check the tracker's map.

**What steps should I take if I get a tracking alert?**
1. Manually search for the tracker.
2. If possible, activate its sound to locate it.
3. Examine the app's map to see how long it's been following you.
4. Disable the tracker or remove its battery. If it's not removable (like in Tile trackers), wrap it in aluminum foil to weaken its signal.
5. Report to the police with the tracker.
6. Don't go to a safe place, like your home, until the tracker is deactivated.

**What if I can't find the tracker after an alert?**
False alarms can occur, especially in crowded areas like public transportation. If you get repeated alerts on different days, recheck. Utilize sound features, signal strength indicators, or detailed scans to locate the device.

**Why might I have trouble activating a tracker's sound?**
This issue can arise if you're too far from the tracker. Move closer and use the signal strength or detailed scan to help locate it. The problem can also occur if the tracker moves out of range or connects to its owner during your search. Sometimes the tracker can also decide not to play the sound depending on its internal state.

## App Settings & Device Management

**What does 'detection sensitivity' in settings do?**
This setting adjusts how long a tracker must follow you before being considered a risk. Lower sensitivity means it must follow you longer; higher sensitivity flags devices more quickly.

**What's the impact of enabling low power scan mode?**
This mode reduces scan frequency, saving energy but decreasing detection effectiveness. It might miss some risky devices. We suggest using the normal mode for better safety, which doesn't significantly drain more battery on modern phones.

**What if I restrict the app's location access?**
Without location access, the app relies on Bluetooth scans alone. This can lead to more false alarms as we can't track your movement relative to the tracker. We recommend allowing location access for more accurate alerts.

**Can I ignore or label my own trackers?**
Currently, you can only ignore Tile brand trackers due to technical limitations. You can label trackers but be aware that the same tracker can change its id and will be seen as a new tracker. We recommend naming them just for identifying them later.

**Why can't I ignore some devices?**
Devices that frequently change their identifier can't be ignored. When they change their key, our system treats them as new devices, triggering new alerts. Some devices (like Samsung SmartTags) change keys often, but you can ignore non-changing ones (like Chipolos and Tiles).