# Add project specific ProGuard rules here.
# You can control the set of applied configuration files using the
# proguardFiles setting in build.gradle.
#
# For more details, see
#   http://developer.android.com/guide/developing/tools/proguard.html

# If your project uses WebView with JS, uncomment the following
# and specify the fully qualified class name to the JavaScript interface
# class:
#-keepclassmembers class fqcn.of.javascript.interface.for.webview {
#   public *;
#}

# Uncomment this to preserve the line number information for
# debugging stack traces.
#-keepattributes SourceFile,LineNumberTable

# If you keep the line number information, uncomment this to
# hide the original source file name.
#-renamesourcefileattribute SourceFile
#-keepattributes LineNumberTable,SourceFile
#-renamesourcefileattribute SourceFile

# Keep all classes generated by Dagger
-keep class dagger.** { *; }
-keep class javax.inject.** { *; }

# Keep annotations used by Dagger
-keepattributes RuntimeVisibleAnnotations

# Allow processing of Dagger modules
-keep class * {
    @dagger.* <fields>;
    @dagger.* <methods>;
    @javax.inject.* <fields>;
    @javax.inject.* <methods>;
}

# Keep Dagger Factories and Components
-keep class **_Factory { *; }
-keep class **_MembersInjector { *; }
-keep class dagger.hilt.** { *; }
-keep class dagger.internal.** { *; }
-keep class **Component { *; }

# Timber rules
-dontwarn org.jetbrains.annotations.**
-keep class timber.log.** { *; }

-dontwarn com.google.api.client.http.GenericUrl
-dontwarn com.google.api.client.http.HttpHeaders
-dontwarn com.google.api.client.http.HttpRequest
-dontwarn com.google.api.client.http.HttpRequestFactory
-dontwarn com.google.api.client.http.HttpResponse
-dontwarn com.google.api.client.http.HttpTransport
-dontwarn com.google.api.client.http.javanet.NetHttpTransport$Builder
-dontwarn com.google.api.client.http.javanet.NetHttpTransport
-dontwarn javax.annotation.Nullable
-dontwarn javax.annotation.concurrent.GuardedBy
-dontwarn javax.annotation.concurrent.ThreadSafe
-dontwarn javax.el.BeanELResolver
-dontwarn javax.el.ELContext
-dontwarn javax.el.ELResolver
-dontwarn javax.el.ExpressionFactory
-dontwarn javax.el.FunctionMapper
-dontwarn javax.el.ValueExpression
-dontwarn javax.el.VariableMapper
-dontwarn javax.naming.NamingEnumeration
-dontwarn javax.naming.NamingException
-dontwarn javax.naming.directory.Attribute
-dontwarn javax.naming.directory.Attributes
-dontwarn javax.naming.directory.DirContext
-dontwarn javax.naming.directory.InitialDirContext
-dontwarn javax.naming.directory.SearchControls
-dontwarn javax.naming.directory.SearchResult
-dontwarn org.ietf.jgss.GSSContext
-dontwarn org.ietf.jgss.GSSCredential
-dontwarn org.ietf.jgss.GSSException
-dontwarn org.ietf.jgss.GSSManager
-dontwarn org.ietf.jgss.GSSName
-dontwarn org.ietf.jgss.Oid
-dontwarn org.joda.time.Instant

# Keep MBassY event bus classes used by SMBJ
-keepclassmembers class net.engio.** { *; }
-keepnames class net.engio.** { *; }
-keepattributes Signature,*Annotation*

# Reproducible and privacy-aware configuration for F-Droid
-dontoptimize
-dontobfuscate

-keepattributes Signature,InnerClasses,EnclosingMethod
-keepattributes SourceFile,LineNumberTable

-keep class de.schliweb.sambalite.** { *; }
-keep interface de.schliweb.sambalite.** { *; }

# keep third-party libs intact
-keep class com.hierynomus.** { *; }
-keep interface com.hierynomus.** { *; }

# ===== CORE PROGUARD RULES =====

# ZIP file operations (used by folder upload)
-keep class java.util.zip.ZipEntry { *; }
-keep class java.util.zip.ZipOutputStream { *; }
-keep class java.util.zip.ZipInputStream { *; }

# Security and hashing (used by file operations)
-keep class java.security.MessageDigest { *; }

# Material Design 3 and UI components
-keep class com.google.android.material.** { *; }
-keep class androidx.core.content.ContextCompat { *; }

# Background processing and scheduling
-keep class java.util.concurrent.Executors { *; }

# ===== END CORE PROGUARD RULES =====