# Issue Templates

This directory contains templates for creating standardized GitHub issues.

## 📋 Available Templates

### 🐛 Bug Report (`bug_report.yml`)
For reporting bugs and unexpected behavior:
- Environment details
- Reproduction steps
- Expected vs actual behavior
- Logs and screenshots

### 💡 Feature Request (`feature_request.yml`)
For suggesting new features:
- Feature description
- Use case and motivation
- Implementation considerations
- Alternatives considered

### 📚 Documentation (`documentation.yml`)
For documentation improvements:
- What needs to be documented
- Target audience
- Content suggestions
- Priority level

### 🛡️ Security Issue (`security_issue.yml`)
For security-related concerns:
- Private reporting guidelines
- Severity assessment
- Impact description
- Mitigation suggestions

## 🎯 Guidelines

### Before Creating an Issue
1. **Search existing issues** to avoid duplicates
2. **Choose the right template** for your issue type
3. **Provide complete information** as requested in the template
4. **Use clear, descriptive titles**

### Issue Lifecycle
1. **Triage**: Maintainers will review and label issues
2. **Assignment**: Issues may be assigned to contributors
3. **Progress**: Updates will be provided as work progresses
4. **Resolution**: Issues will be closed when resolved

### Labels and Priority
Issues will be labeled based on:
- **Type**: bug, feature, documentation, security
- **Priority**: low, medium, high, critical
- **Component**: ui, networking, storage, testing
- **Status**: needs-info, in-progress, ready-for-review

## 🔧 Custom Templates

If you need a different type of issue template:
1. Check if existing templates can be adapted
2. Open a discussion about the new template need
3. Contribute a new template via pull request

---

Using these templates helps maintain consistency and ensures all necessary information is captured for efficient issue resolution.
