#!/usr/bin/python3
import os

import requests
import sys
from pathlib import Path

# Arguments you need to provide:
# 1.- client_id = Amazon client API id
# 2.- client_secret = Amazon client API secret
# 3.- app_id = Amazon app id
# 4.- local_apk_path = Path for the apk file to submit
arguments = sys.argv



client_id = os.environ["CLIENT_ID"]
client_secret = os.environ["CLIENT_SECRET"]
app_id = os.environ["APP_ID"]
apk_location = "app/build/outputs/bundle/appstore/app-appstore.aab"

BASE_URL = 'https://developer.amazon.com/api/appstore'

scope = "appstore::apps:readwrite"
grant_type = "client_credentials"
data = {
    "grant_type": grant_type,
    "client_id": client_id,
    "client_secret": client_secret,
    "scope": scope
}

print ("** Requesting authorization **")

amazon_auth_url = "https://api.amazon.com/auth/o2/token"
auth_response = requests.post(amazon_auth_url, data=data)

# Read token from auth response
auth_response_json = auth_response.json()
auth_token = auth_response_json["access_token"]

auth_token_header_value = "Bearer %s" % auth_token

headers = {"Authorization": auth_token_header_value}

print ("** Checking for open edit **")

get_edits_path = '/v1/applications/%s/edits' % app_id
get_edits_url = BASE_URL + get_edits_path
get_edits_response = requests.get(get_edits_url, headers=headers)
current_edit = get_edits_response.json()

if 'id' in current_edit:
    edit_id = current_edit['id']
    print("** Using current edit **")
else:
    print ("** Creating new edit **")

    create_edit_path = '/v1/applications/%s/edits' % app_id
    create_edit_url = BASE_URL + create_edit_path
    create_edit_response = requests.post(create_edit_url, headers=headers)
    current_edit = create_edit_response.json()
    print (current_edit)

    edit_id = current_edit['id']

print ("** Uploading bundle")

get_apks_path = '/v1/applications/%s/edits/%s/apks' % (app_id, edit_id)
get_apks_url = BASE_URL + get_apks_path
apks = requests.get(get_apks_url, headers=headers)

if apks:
    firstApk = apks.json()[0]

    # Get apk information
    apk_id = firstApk['id']
    print("\n--Getting " + apk_id + " apk information--")
    apkVersionCode = firstApk['versionCode']

    get_apk_info_path = '/v1/applications/%s/edits/%s/apks/%s' % (app_id, edit_id, apk_id)
    get_apk_info_url = BASE_URL + get_apk_info_path
    apk_info = requests.get(get_apk_info_url, headers=headers)

    apk_etag = apk_info.headers['Etag']
    print("Apk id:" + apk_id + ", Version code:" + str(apkVersionCode) + ", Etag: " + apk_etag)

    # Open the apk file on your local machine
    print("\n--Uploading apk from local path: " + apk_location + "--")
    apk_file_name = Path(apk_location).stem
    local_apk = open(apk_location, 'rb').read()
    print (len(local_apk))
    replace_apk_path = '/v1/applications/%s/edits/%s/apks/%s/replace' % (app_id, edit_id, apk_id)
    replace_apk_url = BASE_URL + replace_apk_path
    replace_apk_headers = {
        'Content-Type': 'application/vnd.android.package-archive',
        'If-Match': apk_etag,
        'fileName': apk_file_name
    }
    replace_apk_headers.update(headers)

    replace_apk_response = requests.put(replace_apk_url, headers=replace_apk_headers, data=local_apk)
    if replace_apk_response.status_code != 200:
        print("Apk replacement failed: " + str(replace_apk_response.json()['errors']))
    else:
        print("Apk replacement success")



