package de.rainerhock.eightbitwonders;

import android.content.Context;
import android.util.Log;

import com.google.android.play.agesignals.AgeSignalsException;
import com.google.android.play.agesignals.AgeSignalsManager;
import com.google.android.play.agesignals.AgeSignalsManagerFactory;
import com.google.android.play.agesignals.AgeSignalsRequest;
import com.google.android.play.agesignals.AgeSignalsResult;
import com.google.android.play.agesignals.model.AgeSignalsErrorCode;
import com.google.android.play.agesignals.model.AgeSignalsVerificationStatus;
import com.google.android.play.agesignals.testing.FakeAgeSignalsManager;

import java.util.Calendar;
import java.util.HashMap;

class AgeVerificationProviderImpl extends AgeVerificationImplBase {
    private static FakeAgeSignalsManager mFakeAgeSignalsManager = null;
    static void setFakeAgeSignalsManager(final FakeAgeSignalsManager manager) {
        if (BaseActivity.isInUnitTest()) {
            mFakeAgeSignalsManager = manager;
        } else {
            throw new IllegalStateException(
                    "Calls to setFakeAgeSignalsManager are only allowed in unit test");
        }
    }
    // CHECKSTYLE DISABLE MagicNumber FOR 45 LINES
    static FakeAgeSignalsManager getPendingChangesUser() {
        AgeSignalsResult fakeSupervisedApprovalPendingUser =
                AgeSignalsResult.builder()
                        .setUserStatus(AgeSignalsVerificationStatus.SUPERVISED_APPROVAL_PENDING)
                        .setAgeLower(13)
                        .setAgeUpper(17)
                        .setInstallId("fake_install_id")
                        .build();
        FakeAgeSignalsManager manager = new FakeAgeSignalsManager();
        manager.setNextAgeSignalsResult(fakeSupervisedApprovalPendingUser);
        return manager;
    }
    static FakeAgeSignalsManager getDeniedAccessUser() {
        AgeSignalsResult fakeSupervisedApprovalDeniedUser =
                AgeSignalsResult.builder()
                        .setUserStatus(AgeSignalsVerificationStatus.SUPERVISED_APPROVAL_DENIED)
                        .setAgeLower(13)
                        .setAgeUpper(17)
                        .setInstallId("fake_install_id")
                        .build();
        FakeAgeSignalsManager manager = new FakeAgeSignalsManager();
        manager.setNextAgeSignalsResult(fakeSupervisedApprovalDeniedUser);
        return manager;
    }
    static FakeAgeSignalsManager getUnknownUser() {
        AgeSignalsResult fakeUnknownUser =
                AgeSignalsResult.builder().setUserStatus(AgeSignalsVerificationStatus.UNKNOWN)
                        .build();
        FakeAgeSignalsManager manager = new FakeAgeSignalsManager();
        manager.setNextAgeSignalsResult(fakeUnknownUser);
        return manager;
    }
    static FakeAgeSignalsManager getErrorForUser() {
        FakeAgeSignalsManager manager = new FakeAgeSignalsManager();
        manager.setNextAgeSignalsException(
                new AgeSignalsException(AgeSignalsErrorCode.NETWORK_ERROR));
        return manager;
    }
    static FakeAgeSignalsManager getFakeSupervisedUser() {
        AgeSignalsResult fakeSupervisedUser =
                AgeSignalsResult.builder()
                        .setUserStatus(AgeSignalsVerificationStatus.SUPERVISED)
                        .setAgeLower(13)
                        .setAgeUpper(17)
                        .setInstallId("fake_install_id")
                        .build();
        FakeAgeSignalsManager manager = new FakeAgeSignalsManager();
        manager.setNextAgeSignalsResult(fakeSupervisedUser);
        return manager;
    }
    static FakeAgeSignalsManager getFakeVerifiedUser() {
        AgeSignalsResult fakeVerifiedUser =
                AgeSignalsResult.builder()
                        .setUserStatus(AgeSignalsVerificationStatus.VERIFIED)
                        .build();
        FakeAgeSignalsManager manager = new FakeAgeSignalsManager();
        manager.setNextAgeSignalsResult(fakeVerifiedUser);
        return manager;
    }


    public static FakeAgeSignalsManager getNotAffectedUser() {
        AgeSignalsResult fakeVerifiedUser =
                AgeSignalsResult.builder()
                        .setUserStatus(null)
                        .build();
        FakeAgeSignalsManager manager = new FakeAgeSignalsManager();
        manager.setNextAgeSignalsResult(fakeVerifiedUser);
        return manager;
    }

    @Override
    public void checkAccess(final Context ctx, final AgeVerification.AgeVerificationUi ui,
                            final Runnable runOnSuccess) {
        AgeSignalsManager ageSignalsManager;
        if (mFakeAgeSignalsManager != null) {
            ageSignalsManager = mFakeAgeSignalsManager;
        } else {
            ageSignalsManager = AgeSignalsManagerFactory.create(ctx);
        }
        ageSignalsManager.checkAgeSignals(AgeSignalsRequest.builder().build())
                .addOnSuccessListener(ageSignalsResult -> {
                    Integer userstatus = ageSignalsResult.userStatus();
                    Log.v(getTag(), "OnSuccessListener called, userstatus = " + userstatus);
                    if (userstatus != null) {
                        if (userstatus.equals(
                                AgeSignalsVerificationStatus.SUPERVISED_APPROVAL_PENDING)) {
                            ui.showMessage(ctx, R.string.supervised_approval_pending);
                        }
                        if (userstatus.equals(
                                AgeSignalsVerificationStatus.SUPERVISED_APPROVAL_DENIED)) {
                            ui.showMessage(ctx, R.string.supervised_approval_denied);
                        }
                        if (userstatus.equals(
                                AgeSignalsVerificationStatus.VERIFIED)) {
                            Log.v(getTag(), "access ok");
                            ui.setUserNonAffected(ctx);
                            runOnSuccess.run();
                        }
                        if (userstatus.equals(
                                AgeSignalsVerificationStatus.SUPERVISED)) {
                            Log.v(getTag(), "access ok");
                            runOnSuccess.run();
                        }
                        if (userstatus.equals(
                                AgeSignalsVerificationStatus.UNKNOWN)) {
                            ui.showMessage(ctx, R.string.unknown_user_pls);
                        }
                    } else {
                        Log.v(getTag(), "access ok");
                        ui.setUserNonAffected(ctx);

                        runOnSuccess.run();
                    }
                }).addOnFailureListener(e -> {
                    // CHECKSTYLE DISABLE MagicNumber FOR 2 LINES
                    if (mFakeAgeSignalsManager == null
                            && Calendar.getInstance().get(Calendar.YEAR) < 2026) {
                        Log.v(getTag(), e.getMessage() + " occurred, but not Running in test mode and not 2026 yet");
                        runOnSuccess.run();
                    } else {
                        if (e instanceof AgeSignalsException) {
                            int errorcode = ((AgeSignalsException) e).getErrorCode();
                            Log.v(getTag(), "Error " + errorcode + " occurred");
                            Integer i = ERRORTEXTS.get(errorcode);
                            int message = (i != null ? i : R.string.please_try_again_later);
                            ui.showMessage(ctx, message);

                        } else {
                            Log.v(getTag(), "Error '" + e.getMessage() + "' occurred");
                            ui.showMessage(ctx, R.string.please_try_again_later);
                        }
                    }
                });
    }
    private static final HashMap<Integer, Integer> ERRORTEXTS = new HashMap<Integer, Integer>() {{
        put(AgeSignalsErrorCode.API_NOT_AVAILABLE, R.string.api_not_available);
        put(AgeSignalsErrorCode.PLAY_STORE_NOT_FOUND, R.string.play_store_not_installed);
        put(AgeSignalsErrorCode.NETWORK_ERROR, R.string.network_error);
        put(AgeSignalsErrorCode.PLAY_SERVICES_NOT_FOUND, R.string.api_not_available);
        put(AgeSignalsErrorCode.CANNOT_BIND_TO_SERVICE, R.string.play_store_not_installed);
        put(AgeSignalsErrorCode.PLAY_STORE_VERSION_OUTDATED, R.string.play_store_not_installed);
        put(AgeSignalsErrorCode.PLAY_SERVICES_VERSION_OUTDATED, R.string.play_store_not_installed);
        put(AgeSignalsErrorCode.CLIENT_TRANSIENT_ERROR, R.string.please_try_again_later);
        put(AgeSignalsErrorCode.APP_NOT_OWNED, R.string.not_installed_by_playstore);
        put(AgeSignalsErrorCode.INTERNAL_ERROR, R.string.please_try_again_later);



    }};
}
