//
// Created by rainer on 07.03.23.
//
#include <string.h>
#include "javascript.h"
#include "javascript_callbacks.h"
#include "lib.h"
#include "charset.h"
#include "mem.h"

static JSValue log(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    uint32_t level=0;
    expected_parameters params[] = {
            {"level", JS_TAG_INT, 1, 1, 6},
            {"text", JS_TAG_UNDEFINED, 0, 0, 0}

    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, params, LEN(params));
    if (!JS_IsException(ret)) {
        JS_ToUint32(ctx, &level, argv[0]);
        const char* logtext=JS_ToCString(ctx, argv[1]);
        js_write_to_log((int) level, logtext);
        ret = JS_UNDEFINED;
        JS_FreeCString(ctx, logtext);
    }
    return ret;
}

const JSCFunctionListEntry developerfunctions[] = {
        JS_CFUNC_DEF("log", 2, log),
        JS_PROP_INT32_DEF("LOG_VERBOSE",2,JS_PROP_CONFIGURABLE),
        JS_PROP_INT32_DEF("LOG_DEBUG",3,JS_PROP_CONFIGURABLE),
        JS_PROP_INT32_DEF("LOG_INFO",4,JS_PROP_CONFIGURABLE),
        JS_PROP_INT32_DEF("LOG_WARN",5,JS_PROP_CONFIGURABLE),
        JS_PROP_INT32_DEF("LOG_ERROR",6,JS_PROP_CONFIGURABLE),
};
int developerfunctions_size = sizeof(developerfunctions) / sizeof(developerfunctions[0]);
